/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.net.URI;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>RenameAttachment</b> OData function import.
 *
 */
public class RenameAttachmentFluentHelper
    extends
    SingleValuedFluentHelperFunction<RenameAttachmentFluentHelper, AttachmentContent, AttachmentContent>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>RenameAttachment</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     *            </p>
     * @param fileName
     *            FileName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FileName</b>
     *            </p>
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     *            </p>
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LogicalDocument</b>
     *            </p>
     */
    public RenameAttachmentFluentHelper(
        @Nonnull final String servicePath,
        @Nullable final String documentInfoRecordDocType,
        @Nullable final String documentInfoRecordDocVersion,
        @Nonnull final String logicalDocument,
        @Nonnull final String archiveDocumentID,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject,
        @Nonnull final String fileName,
        @Nullable final String documentInfoRecordDocNumber,
        @Nullable final String documentInfoRecordDocPart )
    {
        super(servicePath);
        if( documentInfoRecordDocType != null ) {
            values.put("DocumentInfoRecordDocType", documentInfoRecordDocType);
        }
        if( documentInfoRecordDocVersion != null ) {
            values.put("DocumentInfoRecordDocVersion", documentInfoRecordDocVersion);
        }
        values.put("LogicalDocument", logicalDocument);
        values.put("ArchiveDocumentID", archiveDocumentID);
        if( businessObjectTypeName != null ) {
            values.put("BusinessObjectTypeName", businessObjectTypeName);
        }
        values.put("LinkedSAPObjectKey", linkedSAPObjectKey);
        if( semanticObject != null ) {
            values.put("SemanticObject", semanticObject);
        }
        values.put("FileName", fileName);
        if( documentInfoRecordDocNumber != null ) {
            values.put("DocumentInfoRecordDocNumber", documentInfoRecordDocNumber);
        }
        if( documentInfoRecordDocPart != null ) {
            values.put("DocumentInfoRecordDocPart", documentInfoRecordDocPart);
        }
    }

    /**
     * Creates a fluent helper object that will execute the <b>RenameAttachment</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param fileName
     *            FileName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FileName</b>
     *            </p>
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     *            </p>
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LogicalDocument</b>
     *            </p>
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     *            </p>
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     */
    public RenameAttachmentFluentHelper(
        @Nonnull final String servicePath,
        @Nullable final String documentInfoRecordDocType,
        @Nullable final String documentInfoRecordDocVersion,
        @Nonnull final String logicalDocument,
        @Nonnull final String archiveDocumentID,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject,
        @Nonnull final String fileName,
        @Nullable final String documentInfoRecordDocNumber,
        @Nullable final String documentInfoRecordDocPart,
        @Nullable final String sAPObjectNodeType,
        @Nullable final String sAPObjectType )
    {
        super(servicePath);
        if( documentInfoRecordDocType != null ) {
            values.put("DocumentInfoRecordDocType", documentInfoRecordDocType);
        }
        if( documentInfoRecordDocVersion != null ) {
            values.put("DocumentInfoRecordDocVersion", documentInfoRecordDocVersion);
        }
        values.put("LogicalDocument", logicalDocument);
        values.put("ArchiveDocumentID", archiveDocumentID);
        if( businessObjectTypeName != null ) {
            values.put("BusinessObjectTypeName", businessObjectTypeName);
        }
        values.put("LinkedSAPObjectKey", linkedSAPObjectKey);
        if( semanticObject != null ) {
            values.put("SemanticObject", semanticObject);
        }
        values.put("FileName", fileName);
        if( documentInfoRecordDocNumber != null ) {
            values.put("DocumentInfoRecordDocNumber", documentInfoRecordDocNumber);
        }
        if( documentInfoRecordDocPart != null ) {
            values.put("DocumentInfoRecordDocPart", documentInfoRecordDocPart);
        }
        if( sAPObjectNodeType != null ) {
            values.put("SAPObjectNodeType", sAPObjectNodeType);
        }
        if( sAPObjectType != null ) {
            values.put("SAPObjectType", sAPObjectType);
        }
    }

    @Override
    @Nonnull
    protected Class<AttachmentContent> getEntityClass()
    {
        return AttachmentContent.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "RenameAttachment";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public AttachmentContent executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
