/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.SAPObjectDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable.SAPObjectDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Harmonized Document Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SAPObjectDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAPObjectDocument extends VdmEntity<SAPObjectDocument>
{

    /**
     * Selector for all available fields of SAPObjectDocument.
     *
     */
    public final static SAPObjectDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAPObjectType
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> SAP_OBJECT_TYPE =
        new SAPObjectDocumentField<String>("SAPObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @return SAPObjectNodeType
     */
    @Key
    @SerializedName( "SAPObjectNodeType" )
    @JsonProperty( "SAPObjectNodeType" )
    @Nullable
    @ODataField( odataName = "SAPObjectNodeType" )
    private String sAPObjectNodeType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectNodeType</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> SAP_OBJECT_NODE_TYPE =
        new SAPObjectDocumentField<String>("SAPObjectNodeType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @return HarmonizedDocumentType
     */
    @Key
    @SerializedName( "HarmonizedDocumentType" )
    @JsonProperty( "HarmonizedDocumentType" )
    @Nullable
    @ODataField( odataName = "HarmonizedDocumentType" )
    private String harmonizedDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>HarmonizedDocumentType</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> HARMONIZED_DOCUMENT_TYPE =
        new SAPObjectDocumentField<String>("HarmonizedDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeDescription</b>
     * </p>
     *
     * @return DocumentTypeDescription
     */
    @SerializedName( "DocumentTypeDescription" )
    @JsonProperty( "DocumentTypeDescription" )
    @Nullable
    @ODataField( odataName = "DocumentTypeDescription" )
    private String documentTypeDescription;
    /**
     * Use with available fluent helpers to apply the <b>DocumentTypeDescription</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> DOCUMENT_TYPE_DESCRIPTION =
        new SAPObjectDocumentField<String>("DocumentTypeDescription");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>PermittedArchiveLinkMimeType</b>
     * </p>
     *
     * @return PermittedArchiveLinkMimeType
     */
    @SerializedName( "PermittedArchiveLinkMimeType" )
    @JsonProperty( "PermittedArchiveLinkMimeType" )
    @Nullable
    @ODataField( odataName = "PermittedArchiveLinkMimeType" )
    private String permittedArchiveLinkMimeType;
    /**
     * Use with available fluent helpers to apply the <b>PermittedArchiveLinkMimeType</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> PERMITTED_ARCHIVE_LINK_MIME_TYPE =
        new SAPObjectDocumentField<String>("PermittedArchiveLinkMimeType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentFramework</b>
     * </p>
     *
     * @return AttachmentFramework
     */
    @SerializedName( "AttachmentFramework" )
    @JsonProperty( "AttachmentFramework" )
    @Nullable
    @ODataField( odataName = "AttachmentFramework" )
    private String attachmentFramework;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentFramework</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> ATTACHMENT_FRAMEWORK =
        new SAPObjectDocumentField<String>("AttachmentFramework");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeIsDefault</b>
     * </p>
     *
     * @return DocumentTypeIsDefault
     */
    @SerializedName( "DocumentTypeIsDefault" )
    @JsonProperty( "DocumentTypeIsDefault" )
    @Nullable
    @ODataField( odataName = "DocumentTypeIsDefault" )
    private String documentTypeIsDefault;
    /**
     * Use with available fluent helpers to apply the <b>DocumentTypeIsDefault</b> field to query operations.
     *
     */
    public final static SAPObjectDocumentField<String> DOCUMENT_TYPE_IS_DEFAULT =
        new SAPObjectDocumentField<String>("DocumentTypeIsDefault");

    @Nonnull
    @Override
    public Class<SAPObjectDocument> getType()
    {
        return SAPObjectDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAPObjectType
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     */
    public void setSAPObjectNodeType( @Nullable final String sAPObjectNodeType )
    {
        rememberChangedField("SAPObjectNodeType", this.sAPObjectNodeType);
        this.sAPObjectNodeType = sAPObjectNodeType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     */
    public void setHarmonizedDocumentType( @Nullable final String harmonizedDocumentType )
    {
        rememberChangedField("HarmonizedDocumentType", this.harmonizedDocumentType);
        this.harmonizedDocumentType = harmonizedDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeDescription</b>
     * </p>
     *
     * @param documentTypeDescription
     *            DocumentTypeDescription
     */
    public void setDocumentTypeDescription( @Nullable final String documentTypeDescription )
    {
        rememberChangedField("DocumentTypeDescription", this.documentTypeDescription);
        this.documentTypeDescription = documentTypeDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>PermittedArchiveLinkMimeType</b>
     * </p>
     *
     * @param permittedArchiveLinkMimeType
     *            PermittedArchiveLinkMimeType
     */
    public void setPermittedArchiveLinkMimeType( @Nullable final String permittedArchiveLinkMimeType )
    {
        rememberChangedField("PermittedArchiveLinkMimeType", this.permittedArchiveLinkMimeType);
        this.permittedArchiveLinkMimeType = permittedArchiveLinkMimeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentFramework</b>
     * </p>
     *
     * @param attachmentFramework
     *            AttachmentFramework
     */
    public void setAttachmentFramework( @Nullable final String attachmentFramework )
    {
        rememberChangedField("AttachmentFramework", this.attachmentFramework);
        this.attachmentFramework = attachmentFramework;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeIsDefault</b>
     * </p>
     *
     * @param documentTypeIsDefault
     *            DocumentTypeIsDefault
     */
    public void setDocumentTypeIsDefault( @Nullable final String documentTypeIsDefault )
    {
        rememberChangedField("DocumentTypeIsDefault", this.documentTypeIsDefault);
        this.documentTypeIsDefault = documentTypeIsDefault;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAPObjectDocumentTypeSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SAPObjectType", getSAPObjectType());
        result.put("SAPObjectNodeType", getSAPObjectNodeType());
        result.put("HarmonizedDocumentType", getHarmonizedDocumentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectNodeType", getSAPObjectNodeType());
        values.put("HarmonizedDocumentType", getHarmonizedDocumentType());
        values.put("DocumentTypeDescription", getDocumentTypeDescription());
        values.put("PermittedArchiveLinkMimeType", getPermittedArchiveLinkMimeType());
        values.put("AttachmentFramework", getAttachmentFramework());
        values.put("DocumentTypeIsDefault", getDocumentTypeIsDefault());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectNodeType") ) {
                final Object value = values.remove("SAPObjectNodeType");
                if( (value == null) || (!value.equals(getSAPObjectNodeType())) ) {
                    setSAPObjectNodeType(((String) value));
                }
            }
            if( values.containsKey("HarmonizedDocumentType") ) {
                final Object value = values.remove("HarmonizedDocumentType");
                if( (value == null) || (!value.equals(getHarmonizedDocumentType())) ) {
                    setHarmonizedDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocumentTypeDescription") ) {
                final Object value = values.remove("DocumentTypeDescription");
                if( (value == null) || (!value.equals(getDocumentTypeDescription())) ) {
                    setDocumentTypeDescription(((String) value));
                }
            }
            if( values.containsKey("PermittedArchiveLinkMimeType") ) {
                final Object value = values.remove("PermittedArchiveLinkMimeType");
                if( (value == null) || (!value.equals(getPermittedArchiveLinkMimeType())) ) {
                    setPermittedArchiveLinkMimeType(((String) value));
                }
            }
            if( values.containsKey("AttachmentFramework") ) {
                final Object value = values.remove("AttachmentFramework");
                if( (value == null) || (!value.equals(getAttachmentFramework())) ) {
                    setAttachmentFramework(((String) value));
                }
            }
            if( values.containsKey("DocumentTypeIsDefault") ) {
                final Object value = values.remove("DocumentTypeIsDefault");
                if( (value == null) || (!value.equals(getDocumentTypeIsDefault())) ) {
                    setDocumentTypeIsDefault(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SAPObjectDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAPObjectDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAPObjectDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAPObjectDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService.DEFAULT_SERVICE_PATH);
    }

}
