/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService AttachmentService}.
 *
 */
public interface AttachmentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<AttachmentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<AttachmentServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     * AttachmentContent} entity and save it to the S/4HANA system.
     *
     * @param attachmentContent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *            AttachmentContent} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    AttachmentServiceBatchChangeSet createAttachmentContent( @Nonnull final AttachmentContent attachmentContent );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     * AttachmentContent} entity in the S/4HANA system.
     *
     * @param attachmentContent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *            AttachmentContent} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    AttachmentServiceBatchChangeSet deleteAttachmentContent( @Nonnull final AttachmentContent attachmentContent );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity and save it to the S/4HANA system.
     *
     * @param attachmentHarmonizedOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *            AttachmentHarmonizedOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    AttachmentServiceBatchChangeSet createAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity in the S/4HANA system.
     *
     * @param attachmentHarmonizedOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *            AttachmentHarmonizedOperation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    AttachmentServiceBatchChangeSet deleteAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     * DocumentInfoRecordAttch} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordAttch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     *            DocumentInfoRecordAttch} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    AttachmentServiceBatchChangeSet
        createDocumentInfoRecordAttch( @Nonnull final DocumentInfoRecordAttch documentInfoRecordAttch );

}
