/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link AttachmentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService AttachmentService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultAttachmentServiceBatch
    extends
    BatchFluentHelperBasic<AttachmentServiceBatch, AttachmentServiceBatchChangeSet>
    implements
    AttachmentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultAttachmentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAttachmentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultAttachmentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAttachmentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultAttachmentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultAttachmentServiceBatchChangeSet(this, service);
    }

}
