/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch;

/**
 * Implementation of the {@link AttachmentServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService AttachmentService}.
 *
 */
public class DefaultAttachmentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<AttachmentServiceBatch, AttachmentServiceBatchChangeSet>
    implements
    AttachmentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService service;

    @SuppressWarnings( "deprecation" )
    DefaultAttachmentServiceBatchChangeSet(
        @Nonnull final DefaultAttachmentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultAttachmentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet createAttachmentContent( @Nonnull final AttachmentContent attachmentContent )
    {
        return addRequestCreate(service::createAttachmentContent, attachmentContent);
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet deleteAttachmentContent( @Nonnull final AttachmentContent attachmentContent )
    {
        return addRequestDelete(service::deleteAttachmentContent, attachmentContent);
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet createAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation )
    {
        return addRequestCreate(service::createAttachmentHarmonizedOperation, attachmentHarmonizedOperation);
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet deleteAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation )
    {
        return addRequestDelete(service::deleteAttachmentHarmonizedOperation, attachmentHarmonizedOperation);
    }

    @Nonnull
    @Override
    public AttachmentServiceBatchChangeSet createDocumentInfoRecordAttch(
        @Nonnull final DocumentInfoRecordAttch documentInfoRecordAttch )
    {
        return addRequestCreate(service::createDocumentInfoRecordAttch, documentInfoRecordAttch);
    }

}
