/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent AttachmentContent}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.AttachmentContentField
 * AttachmentContentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.link.AttachmentContentLink
 * AttachmentContentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#LOGICAL_DOCUMENT
 * LOGICAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#ARCHIVE_DOCUMENT_ID
 * ARCHIVE_DOCUMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#LINKED_SAP_OBJECT_KEY
 * LINKED_SAP_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#BUSINESS_OBJECT_TYPE_NAME
 * BUSINESS_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#SEMANTIC_OBJECT
 * SEMANTIC_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#WORKSTATION_APPLICATION
 * WORKSTATION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#FILE_SIZE FILE_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#FILE_NAME FILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#DOCUMENT_URL
 * DOCUMENT_URL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#MIME_TYPE MIME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#CONTENT CONTENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#CREATED_BY_USER_FULL_NAME
 * CREATED_BY_USER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#BUSINESS_OBJECT_TYPE
 * BUSINESS_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#LAST_CHANGED_BY_USER_FULL_NAME
 * LAST_CHANGED_BY_USER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#STORAGE_CATEGORY
 * STORAGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#ARCHIVE_LINK_REPOSITORY
 * ARCHIVE_LINK_REPOSITORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#SAP_OBJECT_NODE_TYPE
 * SAP_OBJECT_NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#HARMONIZED_DOCUMENT_TYPE
 * HARMONIZED_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#ATTACHMENT_DELETION_IS_ALLOWED
 * ATTACHMENT_DELETION_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#ATTACHMENT_RENAME_IS_ALLOWED
 * ATTACHMENT_RENAME_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#SOURCE SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent#ATTACHMENT_CONTENT_HASH
 * ATTACHMENT_CONTENT_HASH}</li>
 * </ul>
 *
 */
public interface AttachmentContentSelectable extends EntitySelectable<AttachmentContent>
{

}
