/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
 * AttachmentHarmonizedOperation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.AttachmentHarmonizedOperationField
 * AttachmentHarmonizedOperationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.link.AttachmentHarmonizedOperationLink
 * AttachmentHarmonizedOperationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#LOGICAL_DOCUMENT
 * LOGICAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#ARCHIVE_DOCUMENT_ID
 * ARCHIVE_DOCUMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#LINKED_SAP_OBJECT_KEY
 * LINKED_SAP_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#BUSINESS_OBJECT_TYPE_NAME
 * BUSINESS_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#FILE_SIZE
 * FILE_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#FILE_NAME
 * FILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#MIME_TYPE
 * MIME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CHECKOUT_USER
 * CHECKOUT_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CHECKOUT_USER_FULL_NAME
 * CHECKOUT_USER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CREATED_BY_USER_FULL_NAME
 * CREATED_BY_USER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#LAST_CHANGED_BY_USER_FULL_NAME
 * LAST_CHANGED_BY_USER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#STORAGE_CATEGORY
 * STORAGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#ARCHIVE_LINK_REPOSITORY
 * ARCHIVE_LINK_REPOSITORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#SAP_OBJECT_NODE_TYPE
 * SAP_OBJECT_NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#HARMONIZED_DOCUMENT_TYPE
 * HARMONIZED_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#ATTACHMENT_DELETION_IS_ALLOWED
 * ATTACHMENT_DELETION_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#ATTACHMENT_RENAME_IS_ALLOWED
 * ATTACHMENT_RENAME_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#URL_TO_UPLOAD_ATTACHMENT
 * URL_TO_UPLOAD_ATTACHMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#URL_TO_READ_ATTACHMENT
 * URL_TO_READ_ATTACHMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation#ONE_TIME_VALID_TOKEN_FOR_ATTACHMENT
 * ONE_TIME_VALID_TOKEN_FOR_ATTACHMENT}</li>
 * </ul>
 *
 */
public interface AttachmentHarmonizedOperationSelectable extends EntitySelectable<AttachmentHarmonizedOperation>
{

}
