/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
 * DocumentInfoRecordAttch}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.DocumentInfoRecordAttchField
 * DocumentInfoRecordAttchField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.link.DocumentInfoRecordAttchLink
 * DocumentInfoRecordAttchLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_INFO_RECORD
 * DOCUMENT_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_DESCRIPTION
 * DOCUMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#EXTERNAL_DOCUMENT_STATUS
 * EXTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOCUMENT_STATUS_NAME
 * DOCUMENT_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#DOC_INFO_RECD_IS_MARKED_FOR_DELETION
 * DOC_INFO_RECD_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch#TO_DOCUMENT_INFO_RECORD_TO_ATTACHMENT_NAVIGATION
 * TO_DOCUMENT_INFO_RECORD_TO_ATTACHMENT_NAVIGATION}</li>
 * </ul>
 *
 */
public interface DocumentInfoRecordAttchSelectable extends EntitySelectable<DocumentInfoRecordAttch>
{

}
