/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument SAPObjectDocument}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.SAPObjectDocumentField
 * SAPObjectDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.link.SAPObjectDocumentLink
 * SAPObjectDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#SAP_OBJECT_NODE_TYPE
 * SAP_OBJECT_NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#HARMONIZED_DOCUMENT_TYPE
 * HARMONIZED_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#DOCUMENT_TYPE_DESCRIPTION
 * DOCUMENT_TYPE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#PERMITTED_ARCHIVE_LINK_MIME_TYPE
 * PERMITTED_ARCHIVE_LINK_MIME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#ATTACHMENT_FRAMEWORK
 * ATTACHMENT_FRAMEWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.SAPObjectDocument#DOCUMENT_TYPE_IS_DEFAULT
 * DOCUMENT_TYPE_IS_DEFAULT}</li>
 * </ul>
 *
 */
public interface SAPObjectDocumentSelectable extends EntitySelectable<SAPObjectDocument>
{

}
