/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.field.BankDetailField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.selectable.BankDetailSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Bank Details
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BankDetailType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BankDetail extends VdmEntity<BankDetail>
{

    /**
     * Selector for all available fields of BankDetail.
     *
     */
    public final static BankDetailSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     *
     * @return Country/Region Key of Bank
     */
    @Key
    @SerializedName( "BankCountry" )
    @JsonProperty( "BankCountry" )
    @Nullable
    @ODataField( odataName = "BankCountry" )
    private String bankCountry;
    /**
     * Use with available fluent helpers to apply the <b>BankCountry</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BANK_COUNTRY = new BankDetailField<String>("BankCountry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankInternalID</b>
     * </p>
     *
     * @return Bank Keys
     */
    @Key
    @SerializedName( "BankInternalID" )
    @JsonProperty( "BankInternalID" )
    @Nullable
    @ODataField( odataName = "BankInternalID" )
    private String bankInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BankInternalID</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BANK_INTERNAL_ID = new BankDetailField<String>("BankInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     *
     * @return Name of Financial Institution
     */
    @SerializedName( "BankName" )
    @JsonProperty( "BankName" )
    @Nullable
    @ODataField( odataName = "BankName" )
    private String bankName;
    /**
     * Use with available fluent helpers to apply the <b>BankName</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BANK_NAME = new BankDetailField<String>("BankName");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     *
     * @return SWIFT/BIC for International Payments
     */
    @SerializedName( "SWIFTCode" )
    @JsonProperty( "SWIFTCode" )
    @Nullable
    @ODataField( odataName = "SWIFTCode" )
    private String sWIFTCode;
    /**
     * Use with available fluent helpers to apply the <b>SWIFTCode</b> field to query operations.
     *
     */
    public final static BankDetailField<String> SWIFT_CODE = new BankDetailField<String>("SWIFTCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankGroup</b>
     * </p>
     *
     * @return Bank group (bank network)
     */
    @SerializedName( "BankGroup" )
    @JsonProperty( "BankGroup" )
    @Nullable
    @ODataField( odataName = "BankGroup" )
    private String bankGroup;
    /**
     * Use with available fluent helpers to apply the <b>BankGroup</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BANK_GROUP = new BankDetailField<String>("BankGroup");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankNumber</b>
     * </p>
     *
     * @return Bank Number
     */
    @SerializedName( "BankNumber" )
    @JsonProperty( "BankNumber" )
    @Nullable
    @ODataField( odataName = "BankNumber" )
    private String bankNumber;
    /**
     * Use with available fluent helpers to apply the <b>BankNumber</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BANK_NUMBER = new BankDetailField<String>("BankNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static BankDetailField<String> REGION = new BankDetailField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static BankDetailField<String> STREET_NAME = new BankDetailField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static BankDetailField<String> CITY_NAME = new BankDetailField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @return Bank Branch
     */
    @SerializedName( "Branch" )
    @JsonProperty( "Branch" )
    @Nullable
    @ODataField( odataName = "Branch" )
    private String branch;
    /**
     * Use with available fluent helpers to apply the <b>Branch</b> field to query operations.
     *
     */
    public final static BankDetailField<String> BRANCH = new BankDetailField<String>("Branch");

    @Nonnull
    @Override
    public Class<BankDetail> getType()
    {
        return BankDetail.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     *
     * @param bankCountry
     *            Country/Region Key of Bank
     */
    public void setBankCountry( @Nullable final String bankCountry )
    {
        rememberChangedField("BankCountry", this.bankCountry);
        this.bankCountry = bankCountry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankInternalID</b>
     * </p>
     *
     * @param bankInternalID
     *            Bank Keys
     */
    public void setBankInternalID( @Nullable final String bankInternalID )
    {
        rememberChangedField("BankInternalID", this.bankInternalID);
        this.bankInternalID = bankInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     *
     * @param bankName
     *            Name of Financial Institution
     */
    public void setBankName( @Nullable final String bankName )
    {
        rememberChangedField("BankName", this.bankName);
        this.bankName = bankName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     *
     * @param sWIFTCode
     *            SWIFT/BIC for International Payments
     */
    public void setSWIFTCode( @Nullable final String sWIFTCode )
    {
        rememberChangedField("SWIFTCode", this.sWIFTCode);
        this.sWIFTCode = sWIFTCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankGroup</b>
     * </p>
     *
     * @param bankGroup
     *            Bank group (bank network)
     */
    public void setBankGroup( @Nullable final String bankGroup )
    {
        rememberChangedField("BankGroup", this.bankGroup);
        this.bankGroup = bankGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankNumber</b>
     * </p>
     *
     * @param bankNumber
     *            Bank Number
     */
    public void setBankNumber( @Nullable final String bankNumber )
    {
        rememberChangedField("BankNumber", this.bankNumber);
        this.bankNumber = bankNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street and House Number
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *            Bank Branch
     */
    public void setBranch( @Nullable final String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BankDetail";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BankCountry", getBankCountry());
        result.put("BankInternalID", getBankInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BankCountry", getBankCountry());
        values.put("BankInternalID", getBankInternalID());
        values.put("BankName", getBankName());
        values.put("SWIFTCode", getSWIFTCode());
        values.put("BankGroup", getBankGroup());
        values.put("BankNumber", getBankNumber());
        values.put("Region", getRegion());
        values.put("StreetName", getStreetName());
        values.put("CityName", getCityName());
        values.put("Branch", getBranch());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BankCountry") ) {
                final Object value = values.remove("BankCountry");
                if( (value == null) || (!value.equals(getBankCountry())) ) {
                    setBankCountry(((String) value));
                }
            }
            if( values.containsKey("BankInternalID") ) {
                final Object value = values.remove("BankInternalID");
                if( (value == null) || (!value.equals(getBankInternalID())) ) {
                    setBankInternalID(((String) value));
                }
            }
            if( values.containsKey("BankName") ) {
                final Object value = values.remove("BankName");
                if( (value == null) || (!value.equals(getBankName())) ) {
                    setBankName(((String) value));
                }
            }
            if( values.containsKey("SWIFTCode") ) {
                final Object value = values.remove("SWIFTCode");
                if( (value == null) || (!value.equals(getSWIFTCode())) ) {
                    setSWIFTCode(((String) value));
                }
            }
            if( values.containsKey("BankGroup") ) {
                final Object value = values.remove("BankGroup");
                if( (value == null) || (!value.equals(getBankGroup())) ) {
                    setBankGroup(((String) value));
                }
            }
            if( values.containsKey("BankNumber") ) {
                final Object value = values.remove("BankNumber");
                if( (value == null) || (!value.equals(getBankNumber())) ) {
                    setBankNumber(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BankDetailField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BankDetailField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BankDetailField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BankDetailField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService.DEFAULT_SERVICE_PATH);
    }

}
