/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BankDetailServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService BankDetailService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBankDetailServiceBatch
    extends
    BatchFluentHelperBasic<BankDetailServiceBatch, BankDetailServiceBatchChangeSet>
    implements
    BankDetailServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBankDetailServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBankDetailServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBankDetailServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBankDetailServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBankDetailServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BankDetailServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBankDetailServiceBatchChangeSet(this, service);
    }

}
