/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BankDetailServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService BankDetailService}.
 *
 */
public class DefaultBankDetailServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BankDetailServiceBatch, BankDetailServiceBatchChangeSet>
    implements
    BankDetailServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService service;

    @SuppressWarnings( "deprecation" )
    DefaultBankDetailServiceBatchChangeSet(
        @Nonnull final DefaultBankDetailServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankDetailService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBankDetailServiceBatchChangeSet getThis()
    {
        return this;
    }

}
