/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail BankDetail}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.field.BankDetailField BankDetailField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.link.BankDetailLink BankDetailLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BANK_COUNTRY BANK_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BANK_INTERNAL_ID
 * BANK_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BANK_NAME BANK_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#SWIFT_CODE SWIFT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BANK_GROUP BANK_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BANK_NUMBER BANK_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#STREET_NAME STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#CITY_NAME CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail#BRANCH BRANCH}</li>
 * </ul>
 *
 */
public interface BankDetailSelectable extends EntitySelectable<BankDetail>
{

}
