/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.BankReconciliationStatementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.link.BankReconciliationStatementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable.BankReconciliationStatementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Bank Reconciliation Statements
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BankReconciliationStatementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BankReconciliationStatement extends VdmEntity<BankReconciliationStatement>
{

    /**
     * Selector for all available fields of BankReconciliationStatement.
     *
     */
    public final static BankReconciliationStatementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> COMPANY_CODE =
        new BankReconciliationStatementField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank
     */
    @Key
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> HOUSE_BANK =
        new BankReconciliationStatementField<String>("HouseBank");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return Account ID
     */
    @Key
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> HOUSE_BANK_ACCOUNT =
        new BankReconciliationStatementField<String>("HouseBankAccount");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @return Reconciliation Date
     */
    @Key
    @SerializedName( "BankReconciliationDate" )
    @JsonProperty( "BankReconciliationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BankReconciliationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bankReconciliationDate;
    /**
     * Use with available fluent helpers to apply the <b>BankReconciliationDate</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<LocalDateTime> BANK_RECONCILIATION_DATE =
        new BankReconciliationStatementField<LocalDateTime>("BankReconciliationDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> LEDGER =
        new BankReconciliationStatementField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "HouseBankCurrency" )
    @JsonProperty( "HouseBankCurrency" )
    @Nullable
    @ODataField( odataName = "HouseBankCurrency" )
    private String houseBankCurrency;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankCurrency</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> HOUSE_BANK_CURRENCY =
        new BankReconciliationStatementField<String>("HouseBankCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BankAccount</b>
     * </p>
     *
     * @return Bank Account
     */
    @SerializedName( "BankAccount" )
    @JsonProperty( "BankAccount" )
    @Nullable
    @ODataField( odataName = "BankAccount" )
    private String bankAccount;
    /**
     * Use with available fluent helpers to apply the <b>BankAccount</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> BANK_ACCOUNT =
        new BankReconciliationStatementField<String>("BankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>BankAccountReferenceText</b>
     * </p>
     *
     * @return Reference info.
     */
    @SerializedName( "BankAccountReferenceText" )
    @JsonProperty( "BankAccountReferenceText" )
    @Nullable
    @ODataField( odataName = "BankAccountReferenceText" )
    private String bankAccountReferenceText;
    /**
     * Use with available fluent helpers to apply the <b>BankAccountReferenceText</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> BANK_ACCOUNT_REFERENCE_TEXT =
        new BankReconciliationStatementField<String>("BankAccountReferenceText");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     *
     * @return Bank Name
     */
    @SerializedName( "BankName" )
    @JsonProperty( "BankName" )
    @Nullable
    @ODataField( odataName = "BankName" )
    private String bankName;
    /**
     * Use with available fluent helpers to apply the <b>BankName</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> BANK_NAME =
        new BankReconciliationStatementField<String>("BankName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> GL_ACCOUNT =
        new BankReconciliationStatementField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedGLAcctBalanceAmt</b>
     * </p>
     *
     * @return Adj.Closing Balance
     */
    @SerializedName( "AdjustedGLAcctBalanceAmt" )
    @JsonProperty( "AdjustedGLAcctBalanceAmt" )
    @Nullable
    @ODataField( odataName = "AdjustedGLAcctBalanceAmt" )
    private BigDecimal adjustedGLAcctBalanceAmt;
    /**
     * Use with available fluent helpers to apply the <b>AdjustedGLAcctBalanceAmt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> ADJUSTED_GL_ACCT_BALANCE_AMT =
        new BankReconciliationStatementField<BigDecimal>("AdjustedGLAcctBalanceAmt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedBkAcctBalanceAmt</b>
     * </p>
     *
     * @return Adj.Closing Balance
     */
    @SerializedName( "AdjustedBkAcctBalanceAmt" )
    @JsonProperty( "AdjustedBkAcctBalanceAmt" )
    @Nullable
    @ODataField( odataName = "AdjustedBkAcctBalanceAmt" )
    private BigDecimal adjustedBkAcctBalanceAmt;
    /**
     * Use with available fluent helpers to apply the <b>AdjustedBkAcctBalanceAmt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> ADJUSTED_BK_ACCT_BALANCE_AMT =
        new BankReconciliationStatementField<BigDecimal>("AdjustedBkAcctBalanceAmt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankAcctBalanceAmt</b>
     * </p>
     *
     * @return Bank Balance Amount
     */
    @SerializedName( "BankAcctBalanceAmt" )
    @JsonProperty( "BankAcctBalanceAmt" )
    @Nullable
    @ODataField( odataName = "BankAcctBalanceAmt" )
    private BigDecimal bankAcctBalanceAmt;
    /**
     * Use with available fluent helpers to apply the <b>BankAcctBalanceAmt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> BANK_ACCT_BALANCE_AMT =
        new BankReconciliationStatementField<BigDecimal>("BankAcctBalanceAmt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GLAcctBalanceAmt</b>
     * </p>
     *
     * @return Closing Balance
     */
    @SerializedName( "GLAcctBalanceAmt" )
    @JsonProperty( "GLAcctBalanceAmt" )
    @Nullable
    @ODataField( odataName = "GLAcctBalanceAmt" )
    private BigDecimal gLAcctBalanceAmt;
    /**
     * Use with available fluent helpers to apply the <b>GLAcctBalanceAmt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> GL_ACCT_BALANCE_AMT =
        new BankReconciliationStatementField<BigDecimal>("GLAcctBalanceAmt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedIncgBkStmntPayt</b>
     * </p>
     *
     * @return Umtchd Incing. In BK
     */
    @SerializedName( "UnmatchedIncgBkStmntPayt" )
    @JsonProperty( "UnmatchedIncgBkStmntPayt" )
    @Nullable
    @ODataField( odataName = "UnmatchedIncgBkStmntPayt" )
    private BigDecimal unmatchedIncgBkStmntPayt;
    /**
     * Use with available fluent helpers to apply the <b>UnmatchedIncgBkStmntPayt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> UNMATCHED_INCG_BK_STMNT_PAYT =
        new BankReconciliationStatementField<BigDecimal>("UnmatchedIncgBkStmntPayt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedOutgBkStmntPayt</b>
     * </p>
     *
     * @return Umtchd Otcing. In BK
     */
    @SerializedName( "UnmatchedOutgBkStmntPayt" )
    @JsonProperty( "UnmatchedOutgBkStmntPayt" )
    @Nullable
    @ODataField( odataName = "UnmatchedOutgBkStmntPayt" )
    private BigDecimal unmatchedOutgBkStmntPayt;
    /**
     * Use with available fluent helpers to apply the <b>UnmatchedOutgBkStmntPayt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> UNMATCHED_OUTG_BK_STMNT_PAYT =
        new BankReconciliationStatementField<BigDecimal>("UnmatchedOutgBkStmntPayt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedIncgJrnlEntrPayt</b>
     * </p>
     *
     * @return Umtchd Incing. In JE
     */
    @SerializedName( "UnmatchedIncgJrnlEntrPayt" )
    @JsonProperty( "UnmatchedIncgJrnlEntrPayt" )
    @Nullable
    @ODataField( odataName = "UnmatchedIncgJrnlEntrPayt" )
    private BigDecimal unmatchedIncgJrnlEntrPayt;
    /**
     * Use with available fluent helpers to apply the <b>UnmatchedIncgJrnlEntrPayt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> UNMATCHED_INCG_JRNL_ENTR_PAYT =
        new BankReconciliationStatementField<BigDecimal>("UnmatchedIncgJrnlEntrPayt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedOutgJrnlEntrPayt</b>
     * </p>
     *
     * @return Umtchd Otcing. In JE
     */
    @SerializedName( "UnmatchedOutgJrnlEntrPayt" )
    @JsonProperty( "UnmatchedOutgJrnlEntrPayt" )
    @Nullable
    @ODataField( odataName = "UnmatchedOutgJrnlEntrPayt" )
    private BigDecimal unmatchedOutgJrnlEntrPayt;
    /**
     * Use with available fluent helpers to apply the <b>UnmatchedOutgJrnlEntrPayt</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<BigDecimal> UNMATCHED_OUTG_JRNL_ENTR_PAYT =
        new BankReconciliationStatementField<BigDecimal>("UnmatchedOutgJrnlEntrPayt");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreationUserName</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "CreationUserName" )
    @JsonProperty( "CreationUserName" )
    @Nullable
    @ODataField( odataName = "CreationUserName" )
    private String creationUserName;
    /**
     * Use with available fluent helpers to apply the <b>CreationUserName</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> CREATION_USER_NAME =
        new BankReconciliationStatementField<String>("CreationUserName");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>UserDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "UserDescription" )
    @JsonProperty( "UserDescription" )
    @Nullable
    @ODataField( odataName = "UserDescription" )
    private String userDescription;
    /**
     * Use with available fluent helpers to apply the <b>UserDescription</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> USER_DESCRIPTION =
        new BankReconciliationStatementField<String>("UserDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp (Changed)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BankReconciliationStatementField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Name
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> COMPANY_CODE_NAME =
        new BankReconciliationStatementField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccountDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "HouseBankAccountDescription" )
    @JsonProperty( "HouseBankAccountDescription" )
    @Nullable
    @ODataField( odataName = "HouseBankAccountDescription" )
    private String houseBankAccountDescription;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccountDescription</b> field to query operations.
     *
     */
    public final static BankReconciliationStatementField<String> HOUSE_BANK_ACCOUNT_DESCRIPTION =
        new BankReconciliationStatementField<String>("HouseBankAccountDescription");
    /**
     * Navigation property <b>JournalEntryItemSet</b> for <b>BankReconciliationStatement</b> to multiple
     * <b>JournalEntryItem</b>.
     *
     */
    @SerializedName( "JournalEntryItemSet" )
    @JsonProperty( "JournalEntryItemSet" )
    @ODataField( odataName = "JournalEntryItemSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JournalEntryItem> toJournalEntryItemSet;
    /**
     * Navigation property <b>BankStatementItemSet</b> for <b>BankReconciliationStatement</b> to multiple
     * <b>BankStatementItem</b>.
     *
     */
    @SerializedName( "BankStatementItemSet" )
    @JsonProperty( "BankStatementItemSet" )
    @ODataField( odataName = "BankStatementItemSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BankStatementItem> toBankStatementItemSet;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryItemSet</b> navigation property to query
     * operations.
     *
     */
    public final static BankReconciliationStatementLink<JournalEntryItem> TO_JOURNAL_ENTRY_ITEM_SET =
        new BankReconciliationStatementLink<JournalEntryItem>("JournalEntryItemSet");
    /**
     * Use with available fluent helpers to apply the <b>BankStatementItemSet</b> navigation property to query
     * operations.
     *
     */
    public final static BankReconciliationStatementLink<BankStatementItem> TO_BANK_STATEMENT_ITEM_SET =
        new BankReconciliationStatementLink<BankStatementItem>("BankStatementItemSet");

    @Nonnull
    @Override
    public Class<BankReconciliationStatement> getType()
    {
        return BankReconciliationStatement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            Account ID
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @param bankReconciliationDate
     *            Reconciliation Date
     */
    public void setBankReconciliationDate( @Nullable final LocalDateTime bankReconciliationDate )
    {
        rememberChangedField("BankReconciliationDate", this.bankReconciliationDate);
        this.bankReconciliationDate = bankReconciliationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankCurrency</b>
     * </p>
     *
     * @param houseBankCurrency
     *            Currency
     */
    public void setHouseBankCurrency( @Nullable final String houseBankCurrency )
    {
        rememberChangedField("HouseBankCurrency", this.houseBankCurrency);
        this.houseBankCurrency = houseBankCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BankAccount</b>
     * </p>
     *
     * @param bankAccount
     *            Bank Account
     */
    public void setBankAccount( @Nullable final String bankAccount )
    {
        rememberChangedField("BankAccount", this.bankAccount);
        this.bankAccount = bankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>BankAccountReferenceText</b>
     * </p>
     *
     * @param bankAccountReferenceText
     *            Reference info.
     */
    public void setBankAccountReferenceText( @Nullable final String bankAccountReferenceText )
    {
        rememberChangedField("BankAccountReferenceText", this.bankAccountReferenceText);
        this.bankAccountReferenceText = bankAccountReferenceText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     *
     * @param bankName
     *            Bank Name
     */
    public void setBankName( @Nullable final String bankName )
    {
        rememberChangedField("BankName", this.bankName);
        this.bankName = bankName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedGLAcctBalanceAmt</b>
     * </p>
     *
     * @param adjustedGLAcctBalanceAmt
     *            Adj.Closing Balance
     */
    public void setAdjustedGLAcctBalanceAmt( @Nullable final BigDecimal adjustedGLAcctBalanceAmt )
    {
        rememberChangedField("AdjustedGLAcctBalanceAmt", this.adjustedGLAcctBalanceAmt);
        this.adjustedGLAcctBalanceAmt = adjustedGLAcctBalanceAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedBkAcctBalanceAmt</b>
     * </p>
     *
     * @param adjustedBkAcctBalanceAmt
     *            Adj.Closing Balance
     */
    public void setAdjustedBkAcctBalanceAmt( @Nullable final BigDecimal adjustedBkAcctBalanceAmt )
    {
        rememberChangedField("AdjustedBkAcctBalanceAmt", this.adjustedBkAcctBalanceAmt);
        this.adjustedBkAcctBalanceAmt = adjustedBkAcctBalanceAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankAcctBalanceAmt</b>
     * </p>
     *
     * @param bankAcctBalanceAmt
     *            Bank Balance Amount
     */
    public void setBankAcctBalanceAmt( @Nullable final BigDecimal bankAcctBalanceAmt )
    {
        rememberChangedField("BankAcctBalanceAmt", this.bankAcctBalanceAmt);
        this.bankAcctBalanceAmt = bankAcctBalanceAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GLAcctBalanceAmt</b>
     * </p>
     *
     * @param gLAcctBalanceAmt
     *            Closing Balance
     */
    public void setGLAcctBalanceAmt( @Nullable final BigDecimal gLAcctBalanceAmt )
    {
        rememberChangedField("GLAcctBalanceAmt", this.gLAcctBalanceAmt);
        this.gLAcctBalanceAmt = gLAcctBalanceAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedIncgBkStmntPayt</b>
     * </p>
     *
     * @param unmatchedIncgBkStmntPayt
     *            Umtchd Incing. In BK
     */
    public void setUnmatchedIncgBkStmntPayt( @Nullable final BigDecimal unmatchedIncgBkStmntPayt )
    {
        rememberChangedField("UnmatchedIncgBkStmntPayt", this.unmatchedIncgBkStmntPayt);
        this.unmatchedIncgBkStmntPayt = unmatchedIncgBkStmntPayt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedOutgBkStmntPayt</b>
     * </p>
     *
     * @param unmatchedOutgBkStmntPayt
     *            Umtchd Otcing. In BK
     */
    public void setUnmatchedOutgBkStmntPayt( @Nullable final BigDecimal unmatchedOutgBkStmntPayt )
    {
        rememberChangedField("UnmatchedOutgBkStmntPayt", this.unmatchedOutgBkStmntPayt);
        this.unmatchedOutgBkStmntPayt = unmatchedOutgBkStmntPayt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedIncgJrnlEntrPayt</b>
     * </p>
     *
     * @param unmatchedIncgJrnlEntrPayt
     *            Umtchd Incing. In JE
     */
    public void setUnmatchedIncgJrnlEntrPayt( @Nullable final BigDecimal unmatchedIncgJrnlEntrPayt )
    {
        rememberChangedField("UnmatchedIncgJrnlEntrPayt", this.unmatchedIncgJrnlEntrPayt);
        this.unmatchedIncgJrnlEntrPayt = unmatchedIncgJrnlEntrPayt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnmatchedOutgJrnlEntrPayt</b>
     * </p>
     *
     * @param unmatchedOutgJrnlEntrPayt
     *            Umtchd Otcing. In JE
     */
    public void setUnmatchedOutgJrnlEntrPayt( @Nullable final BigDecimal unmatchedOutgJrnlEntrPayt )
    {
        rememberChangedField("UnmatchedOutgJrnlEntrPayt", this.unmatchedOutgJrnlEntrPayt);
        this.unmatchedOutgJrnlEntrPayt = unmatchedOutgJrnlEntrPayt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreationUserName</b>
     * </p>
     *
     * @param creationUserName
     *            Changed By
     */
    public void setCreationUserName( @Nullable final String creationUserName )
    {
        rememberChangedField("CreationUserName", this.creationUserName);
        this.creationUserName = creationUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>UserDescription</b>
     * </p>
     *
     * @param userDescription
     *            Description
     */
    public void setUserDescription( @Nullable final String userDescription )
    {
        rememberChangedField("UserDescription", this.userDescription);
        this.userDescription = userDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp (Changed)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Name
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccountDescription</b>
     * </p>
     *
     * @param houseBankAccountDescription
     *            Description
     */
    public void setHouseBankAccountDescription( @Nullable final String houseBankAccountDescription )
    {
        rememberChangedField("HouseBankAccountDescription", this.houseBankAccountDescription);
        this.houseBankAccountDescription = houseBankAccountDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BankReconciliationStatementSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("HouseBank", getHouseBank());
        result.put("HouseBankAccount", getHouseBankAccount());
        result.put("BankReconciliationDate", getBankReconciliationDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("BankReconciliationDate", getBankReconciliationDate());
        values.put("Ledger", getLedger());
        values.put("HouseBankCurrency", getHouseBankCurrency());
        values.put("BankAccount", getBankAccount());
        values.put("BankAccountReferenceText", getBankAccountReferenceText());
        values.put("BankName", getBankName());
        values.put("GLAccount", getGLAccount());
        values.put("AdjustedGLAcctBalanceAmt", getAdjustedGLAcctBalanceAmt());
        values.put("AdjustedBkAcctBalanceAmt", getAdjustedBkAcctBalanceAmt());
        values.put("BankAcctBalanceAmt", getBankAcctBalanceAmt());
        values.put("GLAcctBalanceAmt", getGLAcctBalanceAmt());
        values.put("UnmatchedIncgBkStmntPayt", getUnmatchedIncgBkStmntPayt());
        values.put("UnmatchedOutgBkStmntPayt", getUnmatchedOutgBkStmntPayt());
        values.put("UnmatchedIncgJrnlEntrPayt", getUnmatchedIncgJrnlEntrPayt());
        values.put("UnmatchedOutgJrnlEntrPayt", getUnmatchedOutgJrnlEntrPayt());
        values.put("CreationUserName", getCreationUserName());
        values.put("UserDescription", getUserDescription());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("HouseBankAccountDescription", getHouseBankAccountDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankReconciliationDate") ) {
                final Object value = values.remove("BankReconciliationDate");
                if( (value == null) || (!value.equals(getBankReconciliationDate())) ) {
                    setBankReconciliationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("HouseBankCurrency") ) {
                final Object value = values.remove("HouseBankCurrency");
                if( (value == null) || (!value.equals(getHouseBankCurrency())) ) {
                    setHouseBankCurrency(((String) value));
                }
            }
            if( values.containsKey("BankAccount") ) {
                final Object value = values.remove("BankAccount");
                if( (value == null) || (!value.equals(getBankAccount())) ) {
                    setBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankAccountReferenceText") ) {
                final Object value = values.remove("BankAccountReferenceText");
                if( (value == null) || (!value.equals(getBankAccountReferenceText())) ) {
                    setBankAccountReferenceText(((String) value));
                }
            }
            if( values.containsKey("BankName") ) {
                final Object value = values.remove("BankName");
                if( (value == null) || (!value.equals(getBankName())) ) {
                    setBankName(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("AdjustedGLAcctBalanceAmt") ) {
                final Object value = values.remove("AdjustedGLAcctBalanceAmt");
                if( (value == null) || (!value.equals(getAdjustedGLAcctBalanceAmt())) ) {
                    setAdjustedGLAcctBalanceAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdjustedBkAcctBalanceAmt") ) {
                final Object value = values.remove("AdjustedBkAcctBalanceAmt");
                if( (value == null) || (!value.equals(getAdjustedBkAcctBalanceAmt())) ) {
                    setAdjustedBkAcctBalanceAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("BankAcctBalanceAmt") ) {
                final Object value = values.remove("BankAcctBalanceAmt");
                if( (value == null) || (!value.equals(getBankAcctBalanceAmt())) ) {
                    setBankAcctBalanceAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("GLAcctBalanceAmt") ) {
                final Object value = values.remove("GLAcctBalanceAmt");
                if( (value == null) || (!value.equals(getGLAcctBalanceAmt())) ) {
                    setGLAcctBalanceAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnmatchedIncgBkStmntPayt") ) {
                final Object value = values.remove("UnmatchedIncgBkStmntPayt");
                if( (value == null) || (!value.equals(getUnmatchedIncgBkStmntPayt())) ) {
                    setUnmatchedIncgBkStmntPayt(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnmatchedOutgBkStmntPayt") ) {
                final Object value = values.remove("UnmatchedOutgBkStmntPayt");
                if( (value == null) || (!value.equals(getUnmatchedOutgBkStmntPayt())) ) {
                    setUnmatchedOutgBkStmntPayt(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnmatchedIncgJrnlEntrPayt") ) {
                final Object value = values.remove("UnmatchedIncgJrnlEntrPayt");
                if( (value == null) || (!value.equals(getUnmatchedIncgJrnlEntrPayt())) ) {
                    setUnmatchedIncgJrnlEntrPayt(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnmatchedOutgJrnlEntrPayt") ) {
                final Object value = values.remove("UnmatchedOutgJrnlEntrPayt");
                if( (value == null) || (!value.equals(getUnmatchedOutgJrnlEntrPayt())) ) {
                    setUnmatchedOutgJrnlEntrPayt(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreationUserName") ) {
                final Object value = values.remove("CreationUserName");
                if( (value == null) || (!value.equals(getCreationUserName())) ) {
                    setCreationUserName(((String) value));
                }
            }
            if( values.containsKey("UserDescription") ) {
                final Object value = values.remove("UserDescription");
                if( (value == null) || (!value.equals(getUserDescription())) ) {
                    setUserDescription(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccountDescription") ) {
                final Object value = values.remove("HouseBankAccountDescription");
                if( (value == null) || (!value.equals(getHouseBankAccountDescription())) ) {
                    setHouseBankAccountDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("JournalEntryItemSet") ) {
                final Object value = (values).remove("JournalEntryItemSet");
                if( value instanceof Iterable ) {
                    if( toJournalEntryItemSet == null ) {
                        toJournalEntryItemSet = Lists.newArrayList();
                    } else {
                        toJournalEntryItemSet = Lists.newArrayList(toJournalEntryItemSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JournalEntryItem entity;
                        if( toJournalEntryItemSet.size() > i ) {
                            entity = toJournalEntryItemSet.get(i);
                        } else {
                            entity = new JournalEntryItem();
                            toJournalEntryItemSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("BankStatementItemSet") ) {
                final Object value = (values).remove("BankStatementItemSet");
                if( value instanceof Iterable ) {
                    if( toBankStatementItemSet == null ) {
                        toBankStatementItemSet = Lists.newArrayList();
                    } else {
                        toBankStatementItemSet = Lists.newArrayList(toBankStatementItemSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BankStatementItem entity;
                        if( toBankStatementItemSet.size() > i ) {
                            entity = toBankStatementItemSet.get(i);
                        } else {
                            entity = new BankStatementItem();
                            toBankStatementItemSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BankReconciliationStatementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BankReconciliationStatementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BankReconciliationStatementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BankReconciliationStatementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toJournalEntryItemSet != null ) {
            (values).put("JournalEntryItemSet", toJournalEntryItemSet);
        }
        if( toBankStatementItemSet != null ) {
            (values).put("BankStatementItemSet", toBankStatementItemSet);
        }
        return values;
    }

    /**
     * Fetches the <b>JournalEntryItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>JournalEntryItemSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>JournalEntryItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JournalEntryItem> fetchJournalEntryItemSet()
    {
        return fetchFieldAsList("JournalEntryItemSet", JournalEntryItem.class);
    }

    /**
     * Retrieval of associated <b>JournalEntryItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>JournalEntryItemSet</b>.
     * <p>
     * If the navigation property <b>JournalEntryItemSet</b> of a queried <b>BankReconciliationStatement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>JournalEntryItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JournalEntryItem> getJournalEntryItemSetOrFetch()
    {
        if( toJournalEntryItemSet == null ) {
            toJournalEntryItemSet = fetchJournalEntryItemSet();
        }
        return toJournalEntryItemSet;
    }

    /**
     * Retrieval of associated <b>JournalEntryItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>JournalEntryItemSet</b>.
     * <p>
     * If the navigation property for an entity <b>BankReconciliationStatement</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>JournalEntryItemSet</b> is already loaded, the result will
     *         contain the <b>JournalEntryItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JournalEntryItem>> getJournalEntryItemSetIfPresent()
    {
        return Option.of(toJournalEntryItemSet);
    }

    /**
     * Overwrites the list of associated <b>JournalEntryItem</b> entities for the loaded navigation property
     * <b>JournalEntryItemSet</b>.
     * <p>
     * If the navigation property <b>JournalEntryItemSet</b> of a queried <b>BankReconciliationStatement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>JournalEntryItem</b> entities.
     */
    public void setJournalEntryItemSet( @Nonnull final List<JournalEntryItem> value )
    {
        if( toJournalEntryItemSet == null ) {
            toJournalEntryItemSet = Lists.newArrayList();
        }
        toJournalEntryItemSet.clear();
        toJournalEntryItemSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JournalEntryItem</b> entities. This corresponds to the OData
     * navigation property <b>JournalEntryItemSet</b>.
     * <p>
     * If the navigation property <b>JournalEntryItemSet</b> of a queried <b>BankReconciliationStatement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>JournalEntryItem</b> entities.
     */
    public void addJournalEntryItemSet( JournalEntryItem... entity )
    {
        if( toJournalEntryItemSet == null ) {
            toJournalEntryItemSet = Lists.newArrayList();
        }
        toJournalEntryItemSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BankStatementItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>BankStatementItemSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BankStatementItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BankStatementItem> fetchBankStatementItemSet()
    {
        return fetchFieldAsList("BankStatementItemSet", BankStatementItem.class);
    }

    /**
     * Retrieval of associated <b>BankStatementItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>BankStatementItemSet</b>.
     * <p>
     * If the navigation property <b>BankStatementItemSet</b> of a queried <b>BankReconciliationStatement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BankStatementItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BankStatementItem> getBankStatementItemSetOrFetch()
    {
        if( toBankStatementItemSet == null ) {
            toBankStatementItemSet = fetchBankStatementItemSet();
        }
        return toBankStatementItemSet;
    }

    /**
     * Retrieval of associated <b>BankStatementItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>BankStatementItemSet</b>.
     * <p>
     * If the navigation property for an entity <b>BankReconciliationStatement</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>BankStatementItemSet</b> is already loaded, the result will
     *         contain the <b>BankStatementItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BankStatementItem>> getBankStatementItemSetIfPresent()
    {
        return Option.of(toBankStatementItemSet);
    }

    /**
     * Overwrites the list of associated <b>BankStatementItem</b> entities for the loaded navigation property
     * <b>BankStatementItemSet</b>.
     * <p>
     * If the navigation property <b>BankStatementItemSet</b> of a queried <b>BankReconciliationStatement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BankStatementItem</b> entities.
     */
    public void setBankStatementItemSet( @Nonnull final List<BankStatementItem> value )
    {
        if( toBankStatementItemSet == null ) {
            toBankStatementItemSet = Lists.newArrayList();
        }
        toBankStatementItemSet.clear();
        toBankStatementItemSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BankStatementItem</b> entities. This corresponds to the OData
     * navigation property <b>BankStatementItemSet</b>.
     * <p>
     * If the navigation property <b>BankStatementItemSet</b> of a queried <b>BankReconciliationStatement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BankStatementItem</b> entities.
     */
    public void addBankStatementItemSet( BankStatementItem... entity )
    {
        if( toBankStatementItemSet == null ) {
            toBankStatementItemSet = Lists.newArrayList();
        }
        toBankStatementItemSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BankReconciliationStatement instances.
     *
     */
    public final static class BankReconciliationStatementBuilder
    {

        private List<JournalEntryItem> toJournalEntryItemSet = Lists.newArrayList();
        private List<BankStatementItem> toBankStatementItemSet = Lists.newArrayList();

        private BankReconciliationStatement.BankReconciliationStatementBuilder toJournalEntryItemSet(
            final List<JournalEntryItem> value )
        {
            toJournalEntryItemSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>JournalEntryItemSet</b> for <b>BankReconciliationStatement</b> to multiple
         * <b>JournalEntryItem</b>.
         *
         * @param value
         *            The JournalEntryItems to build this BankReconciliationStatement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BankReconciliationStatement.BankReconciliationStatementBuilder journalEntryItemSet(
            JournalEntryItem... value )
        {
            return toJournalEntryItemSet(Lists.newArrayList(value));
        }

        private BankReconciliationStatement.BankReconciliationStatementBuilder toBankStatementItemSet(
            final List<BankStatementItem> value )
        {
            toBankStatementItemSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>BankStatementItemSet</b> for <b>BankReconciliationStatement</b> to multiple
         * <b>BankStatementItem</b>.
         *
         * @param value
         *            The BankStatementItems to build this BankReconciliationStatement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BankReconciliationStatement.BankReconciliationStatementBuilder bankStatementItemSet(
            BankStatementItem... value )
        {
            return toBankStatementItemSet(Lists.newArrayList(value));
        }

    }

}
