/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.BankStatementItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable.BankStatementItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Bank Statement Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BankStatementItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BankStatementItem extends VdmEntity<BankStatementItem>
{

    /**
     * Selector for all available fields of BankStatementItem.
     *
     */
    public final static BankStatementItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> COMPANY_CODE = new BankStatementItemField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank
     */
    @Key
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> HOUSE_BANK = new BankStatementItemField<String>("HouseBank");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return Account ID
     */
    @Key
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> HOUSE_BANK_ACCOUNT =
        new BankStatementItemField<String>("HouseBankAccount");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @return Reconciliation Date
     */
    @Key
    @SerializedName( "BankReconciliationDate" )
    @JsonProperty( "BankReconciliationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BankReconciliationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bankReconciliationDate;
    /**
     * Use with available fluent helpers to apply the <b>BankReconciliationDate</b> field to query operations.
     *
     */
    public final static BankStatementItemField<LocalDateTime> BANK_RECONCILIATION_DATE =
        new BankStatementItemField<LocalDateTime>("BankReconciliationDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementShortID</b>
     * </p>
     *
     * @return Short Key
     */
    @Key
    @SerializedName( "BankStatementShortID" )
    @JsonProperty( "BankStatementShortID" )
    @Nullable
    @ODataField( odataName = "BankStatementShortID" )
    private String bankStatementShortID;
    /**
     * Use with available fluent helpers to apply the <b>BankStatementShortID</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BANK_STATEMENT_SHORT_ID =
        new BankStatementItemField<String>("BankStatementShortID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementItem</b>
     * </p>
     *
     * @return Memo Record No.
     */
    @Key
    @SerializedName( "BankStatementItem" )
    @JsonProperty( "BankStatementItem" )
    @Nullable
    @ODataField( odataName = "BankStatementItem" )
    private String bankStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>BankStatementItem</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BANK_STATEMENT_ITEM =
        new BankStatementItemField<String>("BankStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationMatchType</b>
     * </p>
     *
     * @return Matched indicator
     */
    @SerializedName( "BankReconciliationMatchType" )
    @JsonProperty( "BankReconciliationMatchType" )
    @Nullable
    @ODataField( odataName = "BankReconciliationMatchType" )
    private String bankReconciliationMatchType;
    /**
     * Use with available fluent helpers to apply the <b>BankReconciliationMatchType</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BANK_RECONCILIATION_MATCH_TYPE =
        new BankStatementItemField<String>("BankReconciliationMatchType");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Note</b>
     * </p>
     *
     * @return Remark
     */
    @SerializedName( "Note" )
    @JsonProperty( "Note" )
    @Nullable
    @ODataField( odataName = "Note" )
    private String note;
    /**
     * Use with available fluent helpers to apply the <b>Note</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> NOTE = new BankStatementItemField<String>("Note");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatement</b>
     * </p>
     *
     * @return Bank Statement No.
     */
    @SerializedName( "BankStatement" )
    @JsonProperty( "BankStatement" )
    @Nullable
    @ODataField( odataName = "BankStatement" )
    private String bankStatement;
    /**
     * Use with available fluent helpers to apply the <b>BankStatement</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BANK_STATEMENT =
        new BankStatementItemField<String>("BankStatement");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "ValueDate" )
    @JsonProperty( "ValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valueDate;
    /**
     * Use with available fluent helpers to apply the <b>ValueDate</b> field to query operations.
     *
     */
    public final static BankStatementItemField<LocalDateTime> VALUE_DATE =
        new BankStatementItemField<LocalDateTime>("ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Acct Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> TRANSACTION_CURRENCY =
        new BankStatementItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "CreditAmountInTransCrcy" )
    @JsonProperty( "CreditAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInTransCrcy" )
    private BigDecimal creditAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static BankStatementItemField<BigDecimal> CREDIT_AMOUNT_IN_TRANS_CRCY =
        new BankStatementItemField<BigDecimal>("CreditAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "DebitAmountInTransCrcy" )
    @JsonProperty( "DebitAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInTransCrcy" )
    private BigDecimal debitAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static BankStatementItemField<BigDecimal> DEBIT_AMOUNT_IN_TRANS_CRCY =
        new BankStatementItemField<BigDecimal>("DebitAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine</b>
     * </p>
     *
     * @return Memo Line
     */
    @SerializedName( "MemoLine" )
    @JsonProperty( "MemoLine" )
    @Nullable
    @ODataField( odataName = "MemoLine" )
    private String memoLine;
    /**
     * Use with available fluent helpers to apply the <b>MemoLine</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> MEMO_LINE = new BankStatementItemField<String>("MemoLine");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> ASSIGNMENT_REFERENCE =
        new BankStatementItemField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerDocument</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "BankLedgerDocument" )
    @JsonProperty( "BankLedgerDocument" )
    @Nullable
    @ODataField( odataName = "BankLedgerDocument" )
    private String bankLedgerDocument;
    /**
     * Use with available fluent helpers to apply the <b>BankLedgerDocument</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BANK_LEDGER_DOCUMENT =
        new BankStatementItemField<String>("BankLedgerDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> FISCAL_YEAR = new BankStatementItemField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static BankStatementItemField<LocalDateTime> POSTING_DATE =
        new BankStatementItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTransaction</b>
     * </p>
     *
     * @return Bus trans code
     */
    @SerializedName( "PaymentTransaction" )
    @JsonProperty( "PaymentTransaction" )
    @Nullable
    @ODataField( odataName = "PaymentTransaction" )
    private String paymentTransaction;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTransaction</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> PAYMENT_TRANSACTION =
        new BankStatementItemField<String>("PaymentTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>PaymentExternalTransacType</b>
     * </p>
     *
     * @return External Trans
     */
    @SerializedName( "PaymentExternalTransacType" )
    @JsonProperty( "PaymentExternalTransacType" )
    @Nullable
    @ODataField( odataName = "PaymentExternalTransacType" )
    private String paymentExternalTransacType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentExternalTransacType</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> PAYMENT_EXTERNAL_TRANSAC_TYPE =
        new BankStatementItemField<String>("PaymentExternalTransacType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OriginalCurrency</b>
     * </p>
     *
     * @return Payment Currency
     */
    @SerializedName( "OriginalCurrency" )
    @JsonProperty( "OriginalCurrency" )
    @Nullable
    @ODataField( odataName = "OriginalCurrency" )
    private String originalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>OriginalCurrency</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> ORIGINAL_CURRENCY =
        new BankStatementItemField<String>("OriginalCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInOriginalCurrency</b>
     * </p>
     *
     * @return For. Crcy Amt
     */
    @SerializedName( "AmountInOriginalCurrency" )
    @JsonProperty( "AmountInOriginalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInOriginalCurrency" )
    private BigDecimal amountInOriginalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInOriginalCurrency</b> field to query operations.
     *
     */
    public final static BankStatementItemField<BigDecimal> AMOUNT_IN_ORIGINAL_CURRENCY =
        new BankStatementItemField<BigDecimal>("AmountInOriginalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> DOCUMENT_ITEM_TEXT =
        new BankStatementItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static BankStatementItemField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new BankStatementItemField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentManualTransacType</b>
     * </p>
     *
     * @return Transaction
     */
    @SerializedName( "PaymentManualTransacType" )
    @JsonProperty( "PaymentManualTransacType" )
    @Nullable
    @ODataField( odataName = "PaymentManualTransacType" )
    private String paymentManualTransacType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentManualTransacType</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> PAYMENT_MANUAL_TRANSAC_TYPE =
        new BankStatementItemField<String>("PaymentManualTransacType");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBank</b>
     * </p>
     *
     * @return Partner Bank Code
     */
    @SerializedName( "PartnerBank" )
    @JsonProperty( "PartnerBank" )
    @Nullable
    @ODataField( odataName = "PartnerBank" )
    private String partnerBank;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBank</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> PARTNER_BANK = new BankStatementItemField<String>("PartnerBank");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankAccount</b>
     * </p>
     *
     * @return Part. bank acct
     */
    @SerializedName( "PartnerBankAccount" )
    @JsonProperty( "PartnerBankAccount" )
    @Nullable
    @ODataField( odataName = "PartnerBankAccount" )
    private String partnerBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBankAccount</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> PARTNER_BANK_ACCOUNT =
        new BankStatementItemField<String>("PartnerBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @return Partner Name
     */
    @SerializedName( "BusinessPartnerName" )
    @JsonProperty( "BusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName" )
    private String businessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName</b> field to query operations.
     *
     */
    public final static BankStatementItemField<String> BUSINESS_PARTNER_NAME =
        new BankStatementItemField<String>("BusinessPartnerName");

    @Nonnull
    @Override
    public Class<BankStatementItem> getType()
    {
        return BankStatementItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            Account ID
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @param bankReconciliationDate
     *            Reconciliation Date
     */
    public void setBankReconciliationDate( @Nullable final LocalDateTime bankReconciliationDate )
    {
        rememberChangedField("BankReconciliationDate", this.bankReconciliationDate);
        this.bankReconciliationDate = bankReconciliationDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementShortID</b>
     * </p>
     *
     * @param bankStatementShortID
     *            Short Key
     */
    public void setBankStatementShortID( @Nullable final String bankStatementShortID )
    {
        rememberChangedField("BankStatementShortID", this.bankStatementShortID);
        this.bankStatementShortID = bankStatementShortID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementItem</b>
     * </p>
     *
     * @param bankStatementItem
     *            Memo Record No.
     */
    public void setBankStatementItem( @Nullable final String bankStatementItem )
    {
        rememberChangedField("BankStatementItem", this.bankStatementItem);
        this.bankStatementItem = bankStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationMatchType</b>
     * </p>
     *
     * @param bankReconciliationMatchType
     *            Matched indicator
     */
    public void setBankReconciliationMatchType( @Nullable final String bankReconciliationMatchType )
    {
        rememberChangedField("BankReconciliationMatchType", this.bankReconciliationMatchType);
        this.bankReconciliationMatchType = bankReconciliationMatchType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Note</b>
     * </p>
     *
     * @param note
     *            Remark
     */
    public void setNote( @Nullable final String note )
    {
        rememberChangedField("Note", this.note);
        this.note = note;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatement</b>
     * </p>
     *
     * @param bankStatement
     *            Bank Statement No.
     */
    public void setBankStatement( @Nullable final String bankStatement )
    {
        rememberChangedField("BankStatement", this.bankStatement);
        this.bankStatement = bankStatement;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDateTime valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Acct Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @param creditAmountInTransCrcy
     *            Amount
     */
    public void setCreditAmountInTransCrcy( @Nullable final BigDecimal creditAmountInTransCrcy )
    {
        rememberChangedField("CreditAmountInTransCrcy", this.creditAmountInTransCrcy);
        this.creditAmountInTransCrcy = creditAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @param debitAmountInTransCrcy
     *            Amount
     */
    public void setDebitAmountInTransCrcy( @Nullable final BigDecimal debitAmountInTransCrcy )
    {
        rememberChangedField("DebitAmountInTransCrcy", this.debitAmountInTransCrcy);
        this.debitAmountInTransCrcy = debitAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine</b>
     * </p>
     *
     * @param memoLine
     *            Memo Line
     */
    public void setMemoLine( @Nullable final String memoLine )
    {
        rememberChangedField("MemoLine", this.memoLine);
        this.memoLine = memoLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerDocument</b>
     * </p>
     *
     * @param bankLedgerDocument
     *            Document Number
     */
    public void setBankLedgerDocument( @Nullable final String bankLedgerDocument )
    {
        rememberChangedField("BankLedgerDocument", this.bankLedgerDocument);
        this.bankLedgerDocument = bankLedgerDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTransaction</b>
     * </p>
     *
     * @param paymentTransaction
     *            Bus trans code
     */
    public void setPaymentTransaction( @Nullable final String paymentTransaction )
    {
        rememberChangedField("PaymentTransaction", this.paymentTransaction);
        this.paymentTransaction = paymentTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>PaymentExternalTransacType</b>
     * </p>
     *
     * @param paymentExternalTransacType
     *            External Trans
     */
    public void setPaymentExternalTransacType( @Nullable final String paymentExternalTransacType )
    {
        rememberChangedField("PaymentExternalTransacType", this.paymentExternalTransacType);
        this.paymentExternalTransacType = paymentExternalTransacType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OriginalCurrency</b>
     * </p>
     *
     * @param originalCurrency
     *            Payment Currency
     */
    public void setOriginalCurrency( @Nullable final String originalCurrency )
    {
        rememberChangedField("OriginalCurrency", this.originalCurrency);
        this.originalCurrency = originalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInOriginalCurrency</b>
     * </p>
     *
     * @param amountInOriginalCurrency
     *            For. Crcy Amt
     */
    public void setAmountInOriginalCurrency( @Nullable final BigDecimal amountInOriginalCurrency )
    {
        rememberChangedField("AmountInOriginalCurrency", this.amountInOriginalCurrency);
        this.amountInOriginalCurrency = amountInOriginalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentManualTransacType</b>
     * </p>
     *
     * @param paymentManualTransacType
     *            Transaction
     */
    public void setPaymentManualTransacType( @Nullable final String paymentManualTransacType )
    {
        rememberChangedField("PaymentManualTransacType", this.paymentManualTransacType);
        this.paymentManualTransacType = paymentManualTransacType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBank</b>
     * </p>
     *
     * @param partnerBank
     *            Partner Bank Code
     */
    public void setPartnerBank( @Nullable final String partnerBank )
    {
        rememberChangedField("PartnerBank", this.partnerBank);
        this.partnerBank = partnerBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankAccount</b>
     * </p>
     *
     * @param partnerBankAccount
     *            Part. bank acct
     */
    public void setPartnerBankAccount( @Nullable final String partnerBankAccount )
    {
        rememberChangedField("PartnerBankAccount", this.partnerBankAccount);
        this.partnerBankAccount = partnerBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @param businessPartnerName
     *            Partner Name
     */
    public void setBusinessPartnerName( @Nullable final String businessPartnerName )
    {
        rememberChangedField("BusinessPartnerName", this.businessPartnerName);
        this.businessPartnerName = businessPartnerName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BankStatementItemSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("HouseBank", getHouseBank());
        result.put("HouseBankAccount", getHouseBankAccount());
        result.put("BankReconciliationDate", getBankReconciliationDate());
        result.put("BankStatementShortID", getBankStatementShortID());
        result.put("BankStatementItem", getBankStatementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("BankReconciliationDate", getBankReconciliationDate());
        values.put("BankStatementShortID", getBankStatementShortID());
        values.put("BankStatementItem", getBankStatementItem());
        values.put("BankReconciliationMatchType", getBankReconciliationMatchType());
        values.put("Note", getNote());
        values.put("BankStatement", getBankStatement());
        values.put("ValueDate", getValueDate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CreditAmountInTransCrcy", getCreditAmountInTransCrcy());
        values.put("DebitAmountInTransCrcy", getDebitAmountInTransCrcy());
        values.put("MemoLine", getMemoLine());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("BankLedgerDocument", getBankLedgerDocument());
        values.put("FiscalYear", getFiscalYear());
        values.put("PostingDate", getPostingDate());
        values.put("PaymentTransaction", getPaymentTransaction());
        values.put("PaymentExternalTransacType", getPaymentExternalTransacType());
        values.put("OriginalCurrency", getOriginalCurrency());
        values.put("AmountInOriginalCurrency", getAmountInOriginalCurrency());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("PaymentManualTransacType", getPaymentManualTransacType());
        values.put("PartnerBank", getPartnerBank());
        values.put("PartnerBankAccount", getPartnerBankAccount());
        values.put("BusinessPartnerName", getBusinessPartnerName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankReconciliationDate") ) {
                final Object value = values.remove("BankReconciliationDate");
                if( (value == null) || (!value.equals(getBankReconciliationDate())) ) {
                    setBankReconciliationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BankStatementShortID") ) {
                final Object value = values.remove("BankStatementShortID");
                if( (value == null) || (!value.equals(getBankStatementShortID())) ) {
                    setBankStatementShortID(((String) value));
                }
            }
            if( values.containsKey("BankStatementItem") ) {
                final Object value = values.remove("BankStatementItem");
                if( (value == null) || (!value.equals(getBankStatementItem())) ) {
                    setBankStatementItem(((String) value));
                }
            }
            if( values.containsKey("BankReconciliationMatchType") ) {
                final Object value = values.remove("BankReconciliationMatchType");
                if( (value == null) || (!value.equals(getBankReconciliationMatchType())) ) {
                    setBankReconciliationMatchType(((String) value));
                }
            }
            if( values.containsKey("Note") ) {
                final Object value = values.remove("Note");
                if( (value == null) || (!value.equals(getNote())) ) {
                    setNote(((String) value));
                }
            }
            if( values.containsKey("BankStatement") ) {
                final Object value = values.remove("BankStatement");
                if( (value == null) || (!value.equals(getBankStatement())) ) {
                    setBankStatement(((String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInTransCrcy") ) {
                final Object value = values.remove("CreditAmountInTransCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInTransCrcy())) ) {
                    setCreditAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInTransCrcy") ) {
                final Object value = values.remove("DebitAmountInTransCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInTransCrcy())) ) {
                    setDebitAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("MemoLine") ) {
                final Object value = values.remove("MemoLine");
                if( (value == null) || (!value.equals(getMemoLine())) ) {
                    setMemoLine(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("BankLedgerDocument") ) {
                final Object value = values.remove("BankLedgerDocument");
                if( (value == null) || (!value.equals(getBankLedgerDocument())) ) {
                    setBankLedgerDocument(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTransaction") ) {
                final Object value = values.remove("PaymentTransaction");
                if( (value == null) || (!value.equals(getPaymentTransaction())) ) {
                    setPaymentTransaction(((String) value));
                }
            }
            if( values.containsKey("PaymentExternalTransacType") ) {
                final Object value = values.remove("PaymentExternalTransacType");
                if( (value == null) || (!value.equals(getPaymentExternalTransacType())) ) {
                    setPaymentExternalTransacType(((String) value));
                }
            }
            if( values.containsKey("OriginalCurrency") ) {
                final Object value = values.remove("OriginalCurrency");
                if( (value == null) || (!value.equals(getOriginalCurrency())) ) {
                    setOriginalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInOriginalCurrency") ) {
                final Object value = values.remove("AmountInOriginalCurrency");
                if( (value == null) || (!value.equals(getAmountInOriginalCurrency())) ) {
                    setAmountInOriginalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentManualTransacType") ) {
                final Object value = values.remove("PaymentManualTransacType");
                if( (value == null) || (!value.equals(getPaymentManualTransacType())) ) {
                    setPaymentManualTransacType(((String) value));
                }
            }
            if( values.containsKey("PartnerBank") ) {
                final Object value = values.remove("PartnerBank");
                if( (value == null) || (!value.equals(getPartnerBank())) ) {
                    setPartnerBank(((String) value));
                }
            }
            if( values.containsKey("PartnerBankAccount") ) {
                final Object value = values.remove("PartnerBankAccount");
                if( (value == null) || (!value.equals(getPartnerBankAccount())) ) {
                    setPartnerBankAccount(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName") ) {
                final Object value = values.remove("BusinessPartnerName");
                if( (value == null) || (!value.equals(getBusinessPartnerName())) ) {
                    setBusinessPartnerName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BankStatementItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BankStatementItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BankStatementItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BankStatementItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService.DEFAULT_SERVICE_PATH);
    }

}
