/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.JournalEntryItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable.JournalEntryItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Journal Entry Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>JournalEntryItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JournalEntryItem extends VdmEntity<JournalEntryItem>
{

    /**
     * Selector for all available fields of JournalEntryItem.
     *
     */
    public final static JournalEntryItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> COMPANY_CODE = new JournalEntryItemField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank
     */
    @Key
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> HOUSE_BANK = new JournalEntryItemField<String>("HouseBank");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return Account ID
     */
    @Key
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> HOUSE_BANK_ACCOUNT =
        new JournalEntryItemField<String>("HouseBankAccount");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @return Reconciliation Date
     */
    @Key
    @SerializedName( "BankReconciliationDate" )
    @JsonProperty( "BankReconciliationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BankReconciliationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bankReconciliationDate;
    /**
     * Use with available fluent helpers to apply the <b>BankReconciliationDate</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<LocalDateTime> BANK_RECONCILIATION_DATE =
        new JournalEntryItemField<LocalDateTime>("BankReconciliationDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> FISCAL_YEAR = new JournalEntryItemField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> ACCOUNTING_DOCUMENT =
        new JournalEntryItemField<String>("AccountingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @return Item
     */
    @Key
    @SerializedName( "AccountingDocumentItem" )
    @JsonProperty( "AccountingDocumentItem" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItem" )
    private String accountingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItem</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> ACCOUNTING_DOCUMENT_ITEM =
        new JournalEntryItemField<String>("AccountingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationMatchType</b>
     * </p>
     *
     * @return Matched indicator
     */
    @SerializedName( "BankReconciliationMatchType" )
    @JsonProperty( "BankReconciliationMatchType" )
    @Nullable
    @ODataField( odataName = "BankReconciliationMatchType" )
    private String bankReconciliationMatchType;
    /**
     * Use with available fluent helpers to apply the <b>BankReconciliationMatchType</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> BANK_RECONCILIATION_MATCH_TYPE =
        new JournalEntryItemField<String>("BankReconciliationMatchType");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Note</b>
     * </p>
     *
     * @return Remark
     */
    @SerializedName( "Note" )
    @JsonProperty( "Note" )
    @Nullable
    @ODataField( odataName = "Note" )
    private String note;
    /**
     * Use with available fluent helpers to apply the <b>Note</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> NOTE = new JournalEntryItemField<String>("Note");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "HouseBankCurrency" )
    @JsonProperty( "HouseBankCurrency" )
    @Nullable
    @ODataField( odataName = "HouseBankCurrency" )
    private String houseBankCurrency;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankCurrency</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> HOUSE_BANK_CURRENCY =
        new JournalEntryItemField<String>("HouseBankCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @return The debitAmountInTransCrcy contained in this entity.
     */
    @SerializedName( "DebitAmountInTransCrcy" )
    @JsonProperty( "DebitAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInTransCrcy" )
    private BigDecimal debitAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<BigDecimal> DEBIT_AMOUNT_IN_TRANS_CRCY =
        new JournalEntryItemField<BigDecimal>("DebitAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @return The creditAmountInTransCrcy contained in this entity.
     */
    @SerializedName( "CreditAmountInTransCrcy" )
    @JsonProperty( "CreditAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInTransCrcy" )
    private BigDecimal creditAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<BigDecimal> CREDIT_AMOUNT_IN_TRANS_CRCY =
        new JournalEntryItemField<BigDecimal>("CreditAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> TRANSACTION_CURRENCY =
        new JournalEntryItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new JournalEntryItemField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> COMPANY_CODE_CURRENCY =
        new JournalEntryItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new JournalEntryItemField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<LocalDateTime> POSTING_DATE =
        new JournalEntryItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> DOCUMENT_ITEM_TEXT =
        new JournalEntryItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "ValueDate" )
    @JsonProperty( "ValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valueDate;
    /**
     * Use with available fluent helpers to apply the <b>ValueDate</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<LocalDateTime> VALUE_DATE =
        new JournalEntryItemField<LocalDateTime>("ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static JournalEntryItemField<String> ASSIGNMENT_REFERENCE =
        new JournalEntryItemField<String>("AssignmentReference");

    @Nonnull
    @Override
    public Class<JournalEntryItem> getType()
    {
        return JournalEntryItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            Account ID
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationDate</b>
     * </p>
     *
     * @param bankReconciliationDate
     *            Reconciliation Date
     */
    public void setBankReconciliationDate( @Nullable final LocalDateTime bankReconciliationDate )
    {
        rememberChangedField("BankReconciliationDate", this.bankReconciliationDate);
        this.bankReconciliationDate = bankReconciliationDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Document Number
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @param accountingDocumentItem
     *            Item
     */
    public void setAccountingDocumentItem( @Nullable final String accountingDocumentItem )
    {
        rememberChangedField("AccountingDocumentItem", this.accountingDocumentItem);
        this.accountingDocumentItem = accountingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankReconciliationMatchType</b>
     * </p>
     *
     * @param bankReconciliationMatchType
     *            Matched indicator
     */
    public void setBankReconciliationMatchType( @Nullable final String bankReconciliationMatchType )
    {
        rememberChangedField("BankReconciliationMatchType", this.bankReconciliationMatchType);
        this.bankReconciliationMatchType = bankReconciliationMatchType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Note</b>
     * </p>
     *
     * @param note
     *            Remark
     */
    public void setNote( @Nullable final String note )
    {
        rememberChangedField("Note", this.note);
        this.note = note;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankCurrency</b>
     * </p>
     *
     * @param houseBankCurrency
     *            Currency
     */
    public void setHouseBankCurrency( @Nullable final String houseBankCurrency )
    {
        rememberChangedField("HouseBankCurrency", this.houseBankCurrency);
        this.houseBankCurrency = houseBankCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @param debitAmountInTransCrcy
     *            The debitAmountInTransCrcy to set.
     */
    public void setDebitAmountInTransCrcy( @Nullable final BigDecimal debitAmountInTransCrcy )
    {
        rememberChangedField("DebitAmountInTransCrcy", this.debitAmountInTransCrcy);
        this.debitAmountInTransCrcy = debitAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @param creditAmountInTransCrcy
     *            The creditAmountInTransCrcy to set.
     */
    public void setCreditAmountInTransCrcy( @Nullable final BigDecimal creditAmountInTransCrcy )
    {
        rememberChangedField("CreditAmountInTransCrcy", this.creditAmountInTransCrcy);
        this.creditAmountInTransCrcy = creditAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDateTime valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    @Override
    protected String getEntityCollection()
    {
        return "JournalEntryItemSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("HouseBank", getHouseBank());
        result.put("HouseBankAccount", getHouseBankAccount());
        result.put("BankReconciliationDate", getBankReconciliationDate());
        result.put("FiscalYear", getFiscalYear());
        result.put("AccountingDocument", getAccountingDocument());
        result.put("AccountingDocumentItem", getAccountingDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("BankReconciliationDate", getBankReconciliationDate());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("AccountingDocumentItem", getAccountingDocumentItem());
        values.put("BankReconciliationMatchType", getBankReconciliationMatchType());
        values.put("Note", getNote());
        values.put("HouseBankCurrency", getHouseBankCurrency());
        values.put("DebitAmountInTransCrcy", getDebitAmountInTransCrcy());
        values.put("CreditAmountInTransCrcy", getCreditAmountInTransCrcy());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("ValueDate", getValueDate());
        values.put("AssignmentReference", getAssignmentReference());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankReconciliationDate") ) {
                final Object value = values.remove("BankReconciliationDate");
                if( (value == null) || (!value.equals(getBankReconciliationDate())) ) {
                    setBankReconciliationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItem") ) {
                final Object value = values.remove("AccountingDocumentItem");
                if( (value == null) || (!value.equals(getAccountingDocumentItem())) ) {
                    setAccountingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BankReconciliationMatchType") ) {
                final Object value = values.remove("BankReconciliationMatchType");
                if( (value == null) || (!value.equals(getBankReconciliationMatchType())) ) {
                    setBankReconciliationMatchType(((String) value));
                }
            }
            if( values.containsKey("Note") ) {
                final Object value = values.remove("Note");
                if( (value == null) || (!value.equals(getNote())) ) {
                    setNote(((String) value));
                }
            }
            if( values.containsKey("HouseBankCurrency") ) {
                final Object value = values.remove("HouseBankCurrency");
                if( (value == null) || (!value.equals(getHouseBankCurrency())) ) {
                    setHouseBankCurrency(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInTransCrcy") ) {
                final Object value = values.remove("DebitAmountInTransCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInTransCrcy())) ) {
                    setDebitAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInTransCrcy") ) {
                final Object value = values.remove("CreditAmountInTransCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInTransCrcy())) ) {
                    setCreditAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> JournalEntryItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JournalEntryItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JournalEntryItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JournalEntryItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService.DEFAULT_SERVICE_PATH);
    }

}
