/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BankReconciliationStatementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService
 * BankReconciliationStatementService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultBankReconciliationStatementServiceBatch
    extends
    BatchFluentHelperBasic<BankReconciliationStatementServiceBatch, BankReconciliationStatementServiceBatchChangeSet>
    implements
    BankReconciliationStatementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBankReconciliationStatementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBankReconciliationStatementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBankReconciliationStatementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBankReconciliationStatementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBankReconciliationStatementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BankReconciliationStatementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBankReconciliationStatementServiceBatchChangeSet(this, service);
    }

}
