/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BankReconciliationStatementServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService
 * BankReconciliationStatementService}.
 *
 */
public class DefaultBankReconciliationStatementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BankReconciliationStatementServiceBatch, BankReconciliationStatementServiceBatchChangeSet>
    implements
    BankReconciliationStatementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService service;

    @SuppressWarnings( "deprecation" )
    DefaultBankReconciliationStatementServiceBatchChangeSet(
        @Nonnull final DefaultBankReconciliationStatementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BankReconciliationStatementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBankReconciliationStatementServiceBatchChangeSet getThis()
    {
        return this;
    }

}
