/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem
 * BankReconciliationItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.BankReconciliationItemField
 * BankReconciliationItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.link.BankReconciliationItemLink
 * BankReconciliationItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_RECONCILIATION_DATE
 * BANK_RECONCILIATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#HOUSE_BANK_CURRENCY
 * HOUSE_BANK_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_ACCOUNT
 * BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_ACCOUNT_REFERENCE_TEXT
 * BANK_ACCOUNT_REFERENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_NAME
 * BANK_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#ADJUSTED_GL_ACCT_BALANCE_AMT
 * ADJUSTED_GL_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#ADJUSTED_BK_ACCT_BALANCE_AMT
 * ADJUSTED_BK_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_ACCT_BALANCE_AMT
 * BANK_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#GL_ACCT_BALANCE_AMT
 * GL_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#UNMATCHED_INCG_BK_STMNT_PAYT
 * UNMATCHED_INCG_BK_STMNT_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#UNMATCHED_OUTG_BK_STMNT_PAYT
 * UNMATCHED_OUTG_BK_STMNT_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#UNMATCHED_INCG_JRNL_ENTR_PAYT
 * UNMATCHED_INCG_JRNL_ENTR_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#UNMATCHED_OUTG_JRNL_ENTR_PAYT
 * UNMATCHED_OUTG_JRNL_ENTR_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#CREATION_USER_NAME
 * CREATION_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#HOUSE_BANK_ACCOUNT_DESCRIPTION
 * HOUSE_BANK_ACCOUNT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#BANK_RECONCILIATION_STATUS
 * BANK_RECONCILIATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem#LAST_BANK_RECONCILIATION_DATE
 * LAST_BANK_RECONCILIATION_DATE}</li>
 * </ul>
 *
 */
public interface BankReconciliationItemSelectable extends EntitySelectable<BankReconciliationItem>
{

}
