/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement
 * BankReconciliationStatement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.BankReconciliationStatementField
 * BankReconciliationStatementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.link.BankReconciliationStatementLink
 * BankReconciliationStatementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#BANK_RECONCILIATION_DATE
 * BANK_RECONCILIATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#HOUSE_BANK_CURRENCY
 * HOUSE_BANK_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#BANK_ACCOUNT
 * BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#BANK_ACCOUNT_REFERENCE_TEXT
 * BANK_ACCOUNT_REFERENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#BANK_NAME
 * BANK_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#ADJUSTED_GL_ACCT_BALANCE_AMT
 * ADJUSTED_GL_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#ADJUSTED_BK_ACCT_BALANCE_AMT
 * ADJUSTED_BK_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#BANK_ACCT_BALANCE_AMT
 * BANK_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#GL_ACCT_BALANCE_AMT
 * GL_ACCT_BALANCE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#UNMATCHED_INCG_BK_STMNT_PAYT
 * UNMATCHED_INCG_BK_STMNT_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#UNMATCHED_OUTG_BK_STMNT_PAYT
 * UNMATCHED_OUTG_BK_STMNT_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#UNMATCHED_INCG_JRNL_ENTR_PAYT
 * UNMATCHED_INCG_JRNL_ENTR_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#UNMATCHED_OUTG_JRNL_ENTR_PAYT
 * UNMATCHED_OUTG_JRNL_ENTR_PAYT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#CREATION_USER_NAME
 * CREATION_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#USER_DESCRIPTION
 * USER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#HOUSE_BANK_ACCOUNT_DESCRIPTION
 * HOUSE_BANK_ACCOUNT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#TO_JOURNAL_ENTRY_ITEM_SET
 * TO_JOURNAL_ENTRY_ITEM_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement#TO_BANK_STATEMENT_ITEM_SET
 * TO_BANK_STATEMENT_ITEM_SET}</li>
 * </ul>
 *
 */
public interface BankReconciliationStatementSelectable extends EntitySelectable<BankReconciliationStatement>
{

}
