/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem
 * BankStatementItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.BankStatementItemField
 * BankStatementItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.link.BankStatementItemLink
 * BankStatementItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_RECONCILIATION_DATE
 * BANK_RECONCILIATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_STATEMENT_SHORT_ID
 * BANK_STATEMENT_SHORT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_STATEMENT_ITEM
 * BANK_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_RECONCILIATION_MATCH_TYPE
 * BANK_RECONCILIATION_MATCH_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#NOTE
 * NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_STATEMENT
 * BANK_STATEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#VALUE_DATE
 * VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#CREDIT_AMOUNT_IN_TRANS_CRCY
 * CREDIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#DEBIT_AMOUNT_IN_TRANS_CRCY
 * DEBIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#MEMO_LINE
 * MEMO_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BANK_LEDGER_DOCUMENT
 * BANK_LEDGER_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#PAYMENT_TRANSACTION
 * PAYMENT_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#PAYMENT_EXTERNAL_TRANSAC_TYPE
 * PAYMENT_EXTERNAL_TRANSAC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#ORIGINAL_CURRENCY
 * ORIGINAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#AMOUNT_IN_ORIGINAL_CURRENCY
 * AMOUNT_IN_ORIGINAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#PAYMENT_MANUAL_TRANSAC_TYPE
 * PAYMENT_MANUAL_TRANSAC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#PARTNER_BANK
 * PARTNER_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#PARTNER_BANK_ACCOUNT
 * PARTNER_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem#BUSINESS_PARTNER_NAME
 * BUSINESS_PARTNER_NAME}</li>
 * </ul>
 *
 */
public interface BankStatementItemSelectable extends EntitySelectable<BankStatementItem>
{

}
