/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem
 * JournalEntryItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.field.JournalEntryItemField
 * JournalEntryItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.link.JournalEntryItemLink
 * JournalEntryItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#BANK_RECONCILIATION_DATE
 * BANK_RECONCILIATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#ACCOUNTING_DOCUMENT_ITEM
 * ACCOUNTING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#BANK_RECONCILIATION_MATCH_TYPE
 * BANK_RECONCILIATION_MATCH_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#NOTE
 * NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#HOUSE_BANK_CURRENCY
 * HOUSE_BANK_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#DEBIT_AMOUNT_IN_TRANS_CRCY
 * DEBIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#CREDIT_AMOUNT_IN_TRANS_CRCY
 * CREDIT_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#VALUE_DATE
 * VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * </ul>
 *
 */
public interface JournalEntryItemSelectable extends EntitySelectable<JournalEntryItem>
{

}
