/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AvailabilityRecord</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AvailabilityRecord extends VdmComplex<AvailabilityRecord>
{

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PeriodStartUTCDateTime</b>
     * </p>
     *
     * @param periodStartUTCDateTime
     *
     * @return Perd Start Date Time
     */
    @SerializedName( "PeriodStartUTCDateTime" )
    @JsonProperty( "PeriodStartUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PeriodStartUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime periodStartUTCDateTime;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PeriodStartTimeZone</b>
     * </p>
     *
     * @param periodStartTimeZone
     *
     * @return Perd Start Time Zone
     */
    @SerializedName( "PeriodStartTimeZone" )
    @JsonProperty( "PeriodStartTimeZone" )
    @Nullable
    @ODataField( odataName = "PeriodStartTimeZone" )
    private String periodStartTimeZone;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PeriodEndUTCDateTime</b>
     * </p>
     *
     * @param periodEndUTCDateTime
     *
     * @return Perd End Date Time
     */
    @SerializedName( "PeriodEndUTCDateTime" )
    @JsonProperty( "PeriodEndUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PeriodEndUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime periodEndUTCDateTime;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PeriodEndTimeZone</b>
     * </p>
     *
     * @param periodEndTimeZone
     *
     * @return Perd End Time Zone
     */
    @SerializedName( "PeriodEndTimeZone" )
    @JsonProperty( "PeriodEndTimeZone" )
    @Nullable
    @ODataField( odataName = "PeriodEndTimeZone" )
    private String periodEndTimeZone;
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>AvailableQuantityInBaseUnit</b>
     * </p>
     *
     * @param availableQuantityInBaseUnit
     *
     * @return Available Quantity
     */
    @SerializedName( "AvailableQuantityInBaseUnit" )
    @JsonProperty( "AvailableQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "AvailableQuantityInBaseUnit" )
    private BigDecimal availableQuantityInBaseUnit;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *
     * @return Unit
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;

    @Nonnull
    @Override
    public Class<AvailabilityRecord> getType()
    {
        return AvailabilityRecord.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PeriodStartUTCDateTime", getPeriodStartUTCDateTime());
        values.put("PeriodStartTimeZone", getPeriodStartTimeZone());
        values.put("PeriodEndUTCDateTime", getPeriodEndUTCDateTime());
        values.put("PeriodEndTimeZone", getPeriodEndTimeZone());
        values.put("AvailableQuantityInBaseUnit", getAvailableQuantityInBaseUnit());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PeriodStartUTCDateTime") ) {
                final Object value = values.remove("PeriodStartUTCDateTime");
                if( (value == null) || (!value.equals(getPeriodStartUTCDateTime())) ) {
                    setPeriodStartUTCDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PeriodStartTimeZone") ) {
                final Object value = values.remove("PeriodStartTimeZone");
                if( (value == null) || (!value.equals(getPeriodStartTimeZone())) ) {
                    setPeriodStartTimeZone(((String) value));
                }
            }
            if( values.containsKey("PeriodEndUTCDateTime") ) {
                final Object value = values.remove("PeriodEndUTCDateTime");
                if( (value == null) || (!value.equals(getPeriodEndUTCDateTime())) ) {
                    setPeriodEndUTCDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PeriodEndTimeZone") ) {
                final Object value = values.remove("PeriodEndTimeZone");
                if( (value == null) || (!value.equals(getPeriodEndTimeZone())) ) {
                    setPeriodEndTimeZone(((String) value));
                }
            }
            if( values.containsKey("AvailableQuantityInBaseUnit") ) {
                final Object value = values.remove("AvailableQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getAvailableQuantityInBaseUnit())) ) {
                    setAvailableQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PeriodStartUTCDateTime</b>
     * </p>
     *
     * @param periodStartUTCDateTime
     *            Perd Start Date Time
     */
    public void setPeriodStartUTCDateTime( @Nullable final LocalDateTime periodStartUTCDateTime )
    {
        rememberChangedField("PeriodStartUTCDateTime", this.periodStartUTCDateTime);
        this.periodStartUTCDateTime = periodStartUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PeriodStartTimeZone</b>
     * </p>
     *
     * @param periodStartTimeZone
     *            Perd Start Time Zone
     */
    public void setPeriodStartTimeZone( @Nullable final String periodStartTimeZone )
    {
        rememberChangedField("PeriodStartTimeZone", this.periodStartTimeZone);
        this.periodStartTimeZone = periodStartTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PeriodEndUTCDateTime</b>
     * </p>
     *
     * @param periodEndUTCDateTime
     *            Perd End Date Time
     */
    public void setPeriodEndUTCDateTime( @Nullable final LocalDateTime periodEndUTCDateTime )
    {
        rememberChangedField("PeriodEndUTCDateTime", this.periodEndUTCDateTime);
        this.periodEndUTCDateTime = periodEndUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PeriodEndTimeZone</b>
     * </p>
     *
     * @param periodEndTimeZone
     *            Perd End Time Zone
     */
    public void setPeriodEndTimeZone( @Nullable final String periodEndTimeZone )
    {
        rememberChangedField("PeriodEndTimeZone", this.periodEndTimeZone);
        this.periodEndTimeZone = periodEndTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>AvailableQuantityInBaseUnit</b>
     * </p>
     *
     * @param availableQuantityInBaseUnit
     *            Available Quantity
     */
    public void setAvailableQuantityInBaseUnit( @Nullable final BigDecimal availableQuantityInBaseUnit )
    {
        rememberChangedField("AvailableQuantityInBaseUnit", this.availableQuantityInBaseUnit);
        this.availableQuantityInBaseUnit = availableQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Unit
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

}
