/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>CalculateAvailabilityTimeseries</b> OData function import.
 *
 */
public class CalculateAvailabilityTimeseriesFluentHelper
    extends
    CollectionValuedFluentHelperFunction<CalculateAvailabilityTimeseriesFluentHelper, AvailabilityRecord, List<AvailabilityRecord>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>CalculateAvailabilityTimeseries</b> OData function import
     * with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param aTPCheckingRule
     *            Checking rule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ATPCheckingRule</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param supplyingPlant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplyingPlant</b>
     *            </p>
     */
    public CalculateAvailabilityTimeseriesFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String aTPCheckingRule,
        @Nonnull final String material,
        @Nonnull final String supplyingPlant )
    {
        super(servicePath);
        values.put("ATPCheckingRule", aTPCheckingRule);
        values.put("Material", material);
        values.put("SupplyingPlant", supplyingPlant);
    }

    @Override
    @Nonnull
    protected Class<AvailabilityRecord> getEntityClass()
    {
        return AvailabilityRecord.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "CalculateAvailabilityTimeseries";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpGet(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<AvailabilityRecord> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
