/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BasicProductAvailabilityInformationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService
 * BasicProductAvailabilityInformationService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultBasicProductAvailabilityInformationServiceBatch
    extends
    BatchFluentHelperBasic<BasicProductAvailabilityInformationServiceBatch, BasicProductAvailabilityInformationServiceBatchChangeSet>
    implements
    BasicProductAvailabilityInformationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBasicProductAvailabilityInformationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBasicProductAvailabilityInformationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBasicProductAvailabilityInformationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBasicProductAvailabilityInformationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBasicProductAvailabilityInformationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BasicProductAvailabilityInformationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBasicProductAvailabilityInformationServiceBatchChangeSet(this, service);
    }

}
