/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BasicProductAvailabilityInformationServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService
 * BasicProductAvailabilityInformationService}.
 *
 */
public class DefaultBasicProductAvailabilityInformationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BasicProductAvailabilityInformationServiceBatch, BasicProductAvailabilityInformationServiceBatchChangeSet>
    implements
    BasicProductAvailabilityInformationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService service;

    @SuppressWarnings( "deprecation" )
    DefaultBasicProductAvailabilityInformationServiceBatchChangeSet(
        @Nonnull final DefaultBasicProductAvailabilityInformationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BasicProductAvailabilityInformationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBasicProductAvailabilityInformationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
