/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable.BatchSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Batches
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BatchType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Batch extends VdmEntity<Batch>
{

    /**
     * Selector for all available fields of Batch.
     *
     */
    public final static BatchSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BatchField<String> MATERIAL = new BatchField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "BatchIdentifyingPlant" )
    @JsonProperty( "BatchIdentifyingPlant" )
    @Nullable
    @ODataField( odataName = "BatchIdentifyingPlant" )
    private String batchIdentifyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>BatchIdentifyingPlant</b> field to query operations.
     *
     */
    public final static BatchField<String> BATCH_IDENTIFYING_PLANT = new BatchField<String>("BatchIdentifyingPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static BatchField<String> BATCH = new BatchField<String>("Batch");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchIsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Flag for All Data in a Batch
     */
    @SerializedName( "BatchIsMarkedForDeletion" )
    @JsonProperty( "BatchIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BatchIsMarkedForDeletion" )
    private Boolean batchIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>BatchIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static BatchField<Boolean> BATCH_IS_MARKED_FOR_DELETION =
        new BatchField<Boolean>("BatchIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchIsInRstrcdUseStock</b>
     * </p>
     *
     * @return Batch in Restricted-Use Stock
     */
    @SerializedName( "MatlBatchIsInRstrcdUseStock" )
    @JsonProperty( "MatlBatchIsInRstrcdUseStock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlBatchIsInRstrcdUseStock" )
    private Boolean matlBatchIsInRstrcdUseStock;
    /**
     * Use with available fluent helpers to apply the <b>MatlBatchIsInRstrcdUseStock</b> field to query operations.
     *
     */
    public final static BatchField<Boolean> MATL_BATCH_IS_IN_RSTRCD_USE_STOCK =
        new BatchField<Boolean>("MatlBatchIsInRstrcdUseStock");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static BatchField<String> SUPPLIER = new BatchField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @return Supplier Batch Number
     */
    @SerializedName( "BatchBySupplier" )
    @JsonProperty( "BatchBySupplier" )
    @Nullable
    @ODataField( odataName = "BatchBySupplier" )
    private String batchBySupplier;
    /**
     * Use with available fluent helpers to apply the <b>BatchBySupplier</b> field to query operations.
     *
     */
    public final static BatchField<String> BATCH_BY_SUPPLIER = new BatchField<String>("BatchBySupplier");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static BatchField<String> COUNTRY_OF_ORIGIN = new BatchField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @return Region of Origin of Material (Non-Preferential Origin)
     */
    @SerializedName( "RegionOfOrigin" )
    @JsonProperty( "RegionOfOrigin" )
    @Nullable
    @ODataField( odataName = "RegionOfOrigin" )
    private String regionOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>RegionOfOrigin</b> field to query operations.
     *
     */
    public final static BatchField<String> REGION_OF_ORIGIN = new BatchField<String>("RegionOfOrigin");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchAvailabilityDate</b>
     * </p>
     *
     * @return Availability date
     */
    @SerializedName( "MatlBatchAvailabilityDate" )
    @JsonProperty( "MatlBatchAvailabilityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlBatchAvailabilityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlBatchAvailabilityDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlBatchAvailabilityDate</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> MATL_BATCH_AVAILABILITY_DATE =
        new BatchField<LocalDateTime>("MatlBatchAvailabilityDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return Shelf Life Expiration or Best-Before Date
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new BatchField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @return Date of Manufacture
     */
    @SerializedName( "ManufactureDate" )
    @JsonProperty( "ManufactureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufactureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufactureDate;
    /**
     * Use with available fluent helpers to apply the <b>ManufactureDate</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> MANUFACTURE_DATE = new BatchField<LocalDateTime>("ManufactureDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate1</b>
     * </p>
     *
     * @return Date for Free Use 1
     */
    @SerializedName( "FreeDefinedDate1" )
    @JsonProperty( "FreeDefinedDate1" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate1",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate1</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE1 =
        new BatchField<LocalDateTime>("FreeDefinedDate1");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate2</b>
     * </p>
     *
     * @return Date for Free Use 2
     */
    @SerializedName( "FreeDefinedDate2" )
    @JsonProperty( "FreeDefinedDate2" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate2",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate2</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE2 =
        new BatchField<LocalDateTime>("FreeDefinedDate2");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate3</b>
     * </p>
     *
     * @return Date for Free Use 3
     */
    @SerializedName( "FreeDefinedDate3" )
    @JsonProperty( "FreeDefinedDate3" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate3",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate3</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE3 =
        new BatchField<LocalDateTime>("FreeDefinedDate3");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate4</b>
     * </p>
     *
     * @return Date for Free Use 4
     */
    @SerializedName( "FreeDefinedDate4" )
    @JsonProperty( "FreeDefinedDate4" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate4",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate4</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE4 =
        new BatchField<LocalDateTime>("FreeDefinedDate4");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate5</b>
     * </p>
     *
     * @return Date for Free Use 5
     */
    @SerializedName( "FreeDefinedDate5" )
    @JsonProperty( "FreeDefinedDate5" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate5",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate5</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE5 =
        new BatchField<LocalDateTime>("FreeDefinedDate5");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate6</b>
     * </p>
     *
     * @return Date for Free Use 6
     */
    @SerializedName( "FreeDefinedDate6" )
    @JsonProperty( "FreeDefinedDate6" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate6",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate6</b> field to query operations.
     *
     */
    public final static BatchField<LocalDateTime> FREE_DEFINED_DATE6 =
        new BatchField<LocalDateTime>("FreeDefinedDate6");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created On Timestamp
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static BatchField<ZonedDateTime> CREATION_DATE_TIME =
        new BatchField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BatchField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BatchField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchExtWhseMgmtInternalId</b>
     * </p>
     *
     * @return Batch ID
     */
    @SerializedName( "BatchExtWhseMgmtInternalId" )
    @JsonProperty( "BatchExtWhseMgmtInternalId" )
    @Nullable
    @ODataField( odataName = "BatchExtWhseMgmtInternalId" )
    private UUID batchExtWhseMgmtInternalId;
    /**
     * Use with available fluent helpers to apply the <b>BatchExtWhseMgmtInternalId</b> field to query operations.
     *
     */
    public final static BatchField<UUID> BATCH_EXT_WHSE_MGMT_INTERNAL_ID =
        new BatchField<UUID>("BatchExtWhseMgmtInternalId");
    /**
     * Navigation property <b>to_BatchCharc</b> for <b>Batch</b> to multiple <b>BatchCharc</b>.
     *
     */
    @SerializedName( "to_BatchCharc" )
    @JsonProperty( "to_BatchCharc" )
    @ODataField( odataName = "to_BatchCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BatchCharc> toBatchCharc;
    /**
     * Navigation property <b>to_BatchClass</b> for <b>Batch</b> to single <b>BatchClass</b>.
     *
     */
    @SerializedName( "to_BatchClass" )
    @JsonProperty( "to_BatchClass" )
    @ODataField( odataName = "to_BatchClass" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BatchClass toBatchClass;
    /**
     * Navigation property <b>to_BatchPlant</b> for <b>Batch</b> to multiple <b>BatchPlant</b>.
     *
     */
    @SerializedName( "to_BatchPlant" )
    @JsonProperty( "to_BatchPlant" )
    @ODataField( odataName = "to_BatchPlant" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BatchPlant> toBatchPlant;
    /**
     * Navigation property <b>to_BatchText</b> for <b>Batch</b> to multiple <b>BatchText</b>.
     *
     */
    @SerializedName( "to_BatchText" )
    @JsonProperty( "to_BatchText" )
    @ODataField( odataName = "to_BatchText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BatchText> toBatchText;
    /**
     * Use with available fluent helpers to apply the <b>to_BatchCharc</b> navigation property to query operations.
     *
     */
    public final static BatchLink<BatchCharc> TO_BATCH_CHARC = new BatchLink<BatchCharc>("to_BatchCharc");
    /**
     * Use with available fluent helpers to apply the <b>to_BatchClass</b> navigation property to query operations.
     *
     */
    public final static BatchOneToOneLink<BatchClass> TO_BATCH_CLASS =
        new BatchOneToOneLink<BatchClass>("to_BatchClass");
    /**
     * Use with available fluent helpers to apply the <b>to_BatchPlant</b> navigation property to query operations.
     *
     */
    public final static BatchLink<BatchPlant> TO_BATCH_PLANT = new BatchLink<BatchPlant>("to_BatchPlant");
    /**
     * Use with available fluent helpers to apply the <b>to_BatchText</b> navigation property to query operations.
     *
     */
    public final static BatchLink<BatchText> TO_BATCH_TEXT = new BatchLink<BatchText>("to_BatchText");

    @Nonnull
    @Override
    public Class<Batch> getType()
    {
        return Batch.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @param batchIdentifyingPlant
     *            Plant
     */
    public void setBatchIdentifyingPlant( @Nullable final String batchIdentifyingPlant )
    {
        rememberChangedField("BatchIdentifyingPlant", this.batchIdentifyingPlant);
        this.batchIdentifyingPlant = batchIdentifyingPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchIsMarkedForDeletion</b>
     * </p>
     *
     * @param batchIsMarkedForDeletion
     *            Deletion Flag for All Data in a Batch
     */
    public void setBatchIsMarkedForDeletion( @Nullable final Boolean batchIsMarkedForDeletion )
    {
        rememberChangedField("BatchIsMarkedForDeletion", this.batchIsMarkedForDeletion);
        this.batchIsMarkedForDeletion = batchIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchIsInRstrcdUseStock</b>
     * </p>
     *
     * @param matlBatchIsInRstrcdUseStock
     *            Batch in Restricted-Use Stock
     */
    public void setMatlBatchIsInRstrcdUseStock( @Nullable final Boolean matlBatchIsInRstrcdUseStock )
    {
        rememberChangedField("MatlBatchIsInRstrcdUseStock", this.matlBatchIsInRstrcdUseStock);
        this.matlBatchIsInRstrcdUseStock = matlBatchIsInRstrcdUseStock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @param batchBySupplier
     *            Supplier Batch Number
     */
    public void setBatchBySupplier( @Nullable final String batchBySupplier )
    {
        rememberChangedField("BatchBySupplier", this.batchBySupplier);
        this.batchBySupplier = batchBySupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @param regionOfOrigin
     *            Region of Origin of Material (Non-Preferential Origin)
     */
    public void setRegionOfOrigin( @Nullable final String regionOfOrigin )
    {
        rememberChangedField("RegionOfOrigin", this.regionOfOrigin);
        this.regionOfOrigin = regionOfOrigin;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlBatchAvailabilityDate</b>
     * </p>
     *
     * @param matlBatchAvailabilityDate
     *            Availability date
     */
    public void setMatlBatchAvailabilityDate( @Nullable final LocalDateTime matlBatchAvailabilityDate )
    {
        rememberChangedField("MatlBatchAvailabilityDate", this.matlBatchAvailabilityDate);
        this.matlBatchAvailabilityDate = matlBatchAvailabilityDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Shelf Life Expiration or Best-Before Date
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *            Date of Manufacture
     */
    public void setManufactureDate( @Nullable final LocalDateTime manufactureDate )
    {
        rememberChangedField("ManufactureDate", this.manufactureDate);
        this.manufactureDate = manufactureDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate1</b>
     * </p>
     *
     * @param freeDefinedDate1
     *            Date for Free Use 1
     */
    public void setFreeDefinedDate1( @Nullable final LocalDateTime freeDefinedDate1 )
    {
        rememberChangedField("FreeDefinedDate1", this.freeDefinedDate1);
        this.freeDefinedDate1 = freeDefinedDate1;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate2</b>
     * </p>
     *
     * @param freeDefinedDate2
     *            Date for Free Use 2
     */
    public void setFreeDefinedDate2( @Nullable final LocalDateTime freeDefinedDate2 )
    {
        rememberChangedField("FreeDefinedDate2", this.freeDefinedDate2);
        this.freeDefinedDate2 = freeDefinedDate2;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate3</b>
     * </p>
     *
     * @param freeDefinedDate3
     *            Date for Free Use 3
     */
    public void setFreeDefinedDate3( @Nullable final LocalDateTime freeDefinedDate3 )
    {
        rememberChangedField("FreeDefinedDate3", this.freeDefinedDate3);
        this.freeDefinedDate3 = freeDefinedDate3;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate4</b>
     * </p>
     *
     * @param freeDefinedDate4
     *            Date for Free Use 4
     */
    public void setFreeDefinedDate4( @Nullable final LocalDateTime freeDefinedDate4 )
    {
        rememberChangedField("FreeDefinedDate4", this.freeDefinedDate4);
        this.freeDefinedDate4 = freeDefinedDate4;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate5</b>
     * </p>
     *
     * @param freeDefinedDate5
     *            Date for Free Use 5
     */
    public void setFreeDefinedDate5( @Nullable final LocalDateTime freeDefinedDate5 )
    {
        rememberChangedField("FreeDefinedDate5", this.freeDefinedDate5);
        this.freeDefinedDate5 = freeDefinedDate5;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate6</b>
     * </p>
     *
     * @param freeDefinedDate6
     *            Date for Free Use 6
     */
    public void setFreeDefinedDate6( @Nullable final LocalDateTime freeDefinedDate6 )
    {
        rememberChangedField("FreeDefinedDate6", this.freeDefinedDate6);
        this.freeDefinedDate6 = freeDefinedDate6;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created On Timestamp
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchExtWhseMgmtInternalId</b>
     * </p>
     *
     * @param batchExtWhseMgmtInternalId
     *            Batch ID
     */
    public void setBatchExtWhseMgmtInternalId( @Nullable final UUID batchExtWhseMgmtInternalId )
    {
        rememberChangedField("BatchExtWhseMgmtInternalId", this.batchExtWhseMgmtInternalId);
        this.batchExtWhseMgmtInternalId = batchExtWhseMgmtInternalId;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Batch";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        result.put("Batch", getBatch());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        values.put("Batch", getBatch());
        values.put("BatchIsMarkedForDeletion", getBatchIsMarkedForDeletion());
        values.put("MatlBatchIsInRstrcdUseStock", getMatlBatchIsInRstrcdUseStock());
        values.put("Supplier", getSupplier());
        values.put("BatchBySupplier", getBatchBySupplier());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("RegionOfOrigin", getRegionOfOrigin());
        values.put("MatlBatchAvailabilityDate", getMatlBatchAvailabilityDate());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("ManufactureDate", getManufactureDate());
        values.put("FreeDefinedDate1", getFreeDefinedDate1());
        values.put("FreeDefinedDate2", getFreeDefinedDate2());
        values.put("FreeDefinedDate3", getFreeDefinedDate3());
        values.put("FreeDefinedDate4", getFreeDefinedDate4());
        values.put("FreeDefinedDate5", getFreeDefinedDate5());
        values.put("FreeDefinedDate6", getFreeDefinedDate6());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("BatchExtWhseMgmtInternalId", getBatchExtWhseMgmtInternalId());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("BatchIdentifyingPlant") ) {
                final Object value = values.remove("BatchIdentifyingPlant");
                if( (value == null) || (!value.equals(getBatchIdentifyingPlant())) ) {
                    setBatchIdentifyingPlant(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchIsMarkedForDeletion") ) {
                final Object value = values.remove("BatchIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getBatchIsMarkedForDeletion())) ) {
                    setBatchIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("MatlBatchIsInRstrcdUseStock") ) {
                final Object value = values.remove("MatlBatchIsInRstrcdUseStock");
                if( (value == null) || (!value.equals(getMatlBatchIsInRstrcdUseStock())) ) {
                    setMatlBatchIsInRstrcdUseStock(((Boolean) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("BatchBySupplier") ) {
                final Object value = values.remove("BatchBySupplier");
                if( (value == null) || (!value.equals(getBatchBySupplier())) ) {
                    setBatchBySupplier(((String) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("RegionOfOrigin") ) {
                final Object value = values.remove("RegionOfOrigin");
                if( (value == null) || (!value.equals(getRegionOfOrigin())) ) {
                    setRegionOfOrigin(((String) value));
                }
            }
            if( values.containsKey("MatlBatchAvailabilityDate") ) {
                final Object value = values.remove("MatlBatchAvailabilityDate");
                if( (value == null) || (!value.equals(getMatlBatchAvailabilityDate())) ) {
                    setMatlBatchAvailabilityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ManufactureDate") ) {
                final Object value = values.remove("ManufactureDate");
                if( (value == null) || (!value.equals(getManufactureDate())) ) {
                    setManufactureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate1") ) {
                final Object value = values.remove("FreeDefinedDate1");
                if( (value == null) || (!value.equals(getFreeDefinedDate1())) ) {
                    setFreeDefinedDate1(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate2") ) {
                final Object value = values.remove("FreeDefinedDate2");
                if( (value == null) || (!value.equals(getFreeDefinedDate2())) ) {
                    setFreeDefinedDate2(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate3") ) {
                final Object value = values.remove("FreeDefinedDate3");
                if( (value == null) || (!value.equals(getFreeDefinedDate3())) ) {
                    setFreeDefinedDate3(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate4") ) {
                final Object value = values.remove("FreeDefinedDate4");
                if( (value == null) || (!value.equals(getFreeDefinedDate4())) ) {
                    setFreeDefinedDate4(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate5") ) {
                final Object value = values.remove("FreeDefinedDate5");
                if( (value == null) || (!value.equals(getFreeDefinedDate5())) ) {
                    setFreeDefinedDate5(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate6") ) {
                final Object value = values.remove("FreeDefinedDate6");
                if( (value == null) || (!value.equals(getFreeDefinedDate6())) ) {
                    setFreeDefinedDate6(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BatchExtWhseMgmtInternalId") ) {
                final Object value = values.remove("BatchExtWhseMgmtInternalId");
                if( (value == null) || (!value.equals(getBatchExtWhseMgmtInternalId())) ) {
                    setBatchExtWhseMgmtInternalId(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BatchCharc") ) {
                final Object value = (values).remove("to_BatchCharc");
                if( value instanceof Iterable ) {
                    if( toBatchCharc == null ) {
                        toBatchCharc = Lists.newArrayList();
                    } else {
                        toBatchCharc = Lists.newArrayList(toBatchCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BatchCharc entity;
                        if( toBatchCharc.size() > i ) {
                            entity = toBatchCharc.get(i);
                        } else {
                            entity = new BatchCharc();
                            toBatchCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BatchClass") ) {
                final Object value = (values).remove("to_BatchClass");
                if( value instanceof Map ) {
                    if( toBatchClass == null ) {
                        toBatchClass = new BatchClass();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBatchClass.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BatchPlant") ) {
                final Object value = (values).remove("to_BatchPlant");
                if( value instanceof Iterable ) {
                    if( toBatchPlant == null ) {
                        toBatchPlant = Lists.newArrayList();
                    } else {
                        toBatchPlant = Lists.newArrayList(toBatchPlant);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BatchPlant entity;
                        if( toBatchPlant.size() > i ) {
                            entity = toBatchPlant.get(i);
                        } else {
                            entity = new BatchPlant();
                            toBatchPlant.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BatchText") ) {
                final Object value = (values).remove("to_BatchText");
                if( value instanceof Iterable ) {
                    if( toBatchText == null ) {
                        toBatchText = Lists.newArrayList();
                    } else {
                        toBatchText = Lists.newArrayList(toBatchText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BatchText entity;
                        if( toBatchText.size() > i ) {
                            entity = toBatchText.get(i);
                        } else {
                            entity = new BatchText();
                            toBatchText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BatchField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BatchField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BatchField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BatchField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBatchCharc != null ) {
            (values).put("to_BatchCharc", toBatchCharc);
        }
        if( toBatchClass != null ) {
            (values).put("to_BatchClass", toBatchClass);
        }
        if( toBatchPlant != null ) {
            (values).put("to_BatchPlant", toBatchPlant);
        }
        if( toBatchText != null ) {
            (values).put("to_BatchText", toBatchText);
        }
        return values;
    }

    /**
     * Fetches the <b>BatchCharc</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BatchCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BatchCharc</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchCharc> fetchBatchCharc()
    {
        return fetchFieldAsList("to_BatchCharc", BatchCharc.class);
    }

    /**
     * Retrieval of associated <b>BatchCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property <b>to_BatchCharc</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BatchCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchCharc> getBatchCharcOrFetch()
    {
        if( toBatchCharc == null ) {
            toBatchCharc = fetchBatchCharc();
        }
        return toBatchCharc;
    }

    /**
     * Retrieval of associated <b>BatchCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property for an entity <b>Batch</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchCharc</b> is already loaded, the result will
     *         contain the <b>BatchCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BatchCharc>> getBatchCharcIfPresent()
    {
        return Option.of(toBatchCharc);
    }

    /**
     * Overwrites the list of associated <b>BatchCharc</b> entities for the loaded navigation property
     * <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property <b>to_BatchCharc</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BatchCharc</b> entities.
     */
    public void setBatchCharc( @Nonnull final List<BatchCharc> value )
    {
        if( toBatchCharc == null ) {
            toBatchCharc = Lists.newArrayList();
        }
        toBatchCharc.clear();
        toBatchCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BatchCharc</b> entities. This corresponds to the OData navigation
     * property <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property <b>to_BatchCharc</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BatchCharc</b> entities.
     */
    public void addBatchCharc( BatchCharc... entity )
    {
        if( toBatchCharc == null ) {
            toBatchCharc = Lists.newArrayList();
        }
        toBatchCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BatchClass</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BatchClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BatchClass</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BatchClass fetchBatchClass()
    {
        return fetchFieldAsSingle("to_BatchClass", BatchClass.class);
    }

    /**
     * Retrieval of associated <b>BatchClass</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BatchClass</b>.
     * <p>
     * If the navigation property <b>to_BatchClass</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BatchClass</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BatchClass getBatchClassOrFetch()
    {
        if( toBatchClass == null ) {
            toBatchClass = fetchBatchClass();
        }
        return toBatchClass;
    }

    /**
     * Retrieval of associated <b>BatchClass</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BatchClass</b>.
     * <p>
     * If the navigation property for an entity <b>Batch</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchClass</b> is already loaded, the result will
     *         contain the <b>BatchClass</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<BatchClass> getBatchClassIfPresent()
    {
        return Option.of(toBatchClass);
    }

    /**
     * Overwrites the associated <b>BatchClass</b> entity for the loaded navigation property <b>to_BatchClass</b>.
     *
     * @param value
     *            New <b>BatchClass</b> entity.
     */
    public void setBatchClass( final BatchClass value )
    {
        toBatchClass = value;
    }

    /**
     * Fetches the <b>BatchPlant</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BatchPlant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BatchPlant</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchPlant> fetchBatchPlant()
    {
        return fetchFieldAsList("to_BatchPlant", BatchPlant.class);
    }

    /**
     * Retrieval of associated <b>BatchPlant</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchPlant</b>.
     * <p>
     * If the navigation property <b>to_BatchPlant</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BatchPlant</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchPlant> getBatchPlantOrFetch()
    {
        if( toBatchPlant == null ) {
            toBatchPlant = fetchBatchPlant();
        }
        return toBatchPlant;
    }

    /**
     * Retrieval of associated <b>BatchPlant</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchPlant</b>.
     * <p>
     * If the navigation property for an entity <b>Batch</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchPlant</b> is already loaded, the result will
     *         contain the <b>BatchPlant</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BatchPlant>> getBatchPlantIfPresent()
    {
        return Option.of(toBatchPlant);
    }

    /**
     * Overwrites the list of associated <b>BatchPlant</b> entities for the loaded navigation property
     * <b>to_BatchPlant</b>.
     * <p>
     * If the navigation property <b>to_BatchPlant</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BatchPlant</b> entities.
     */
    public void setBatchPlant( @Nonnull final List<BatchPlant> value )
    {
        if( toBatchPlant == null ) {
            toBatchPlant = Lists.newArrayList();
        }
        toBatchPlant.clear();
        toBatchPlant.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BatchPlant</b> entities. This corresponds to the OData navigation
     * property <b>to_BatchPlant</b>.
     * <p>
     * If the navigation property <b>to_BatchPlant</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BatchPlant</b> entities.
     */
    public void addBatchPlant( BatchPlant... entity )
    {
        if( toBatchPlant == null ) {
            toBatchPlant = Lists.newArrayList();
        }
        toBatchPlant.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BatchText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BatchText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BatchText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchText> fetchBatchText()
    {
        return fetchFieldAsList("to_BatchText", BatchText.class);
    }

    /**
     * Retrieval of associated <b>BatchText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchText</b>.
     * <p>
     * If the navigation property <b>to_BatchText</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BatchText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BatchText> getBatchTextOrFetch()
    {
        if( toBatchText == null ) {
            toBatchText = fetchBatchText();
        }
        return toBatchText;
    }

    /**
     * Retrieval of associated <b>BatchText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BatchText</b>.
     * <p>
     * If the navigation property for an entity <b>Batch</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchText</b> is already loaded, the result will contain
     *         the <b>BatchText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<BatchText>> getBatchTextIfPresent()
    {
        return Option.of(toBatchText);
    }

    /**
     * Overwrites the list of associated <b>BatchText</b> entities for the loaded navigation property
     * <b>to_BatchText</b>.
     * <p>
     * If the navigation property <b>to_BatchText</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BatchText</b> entities.
     */
    public void setBatchText( @Nonnull final List<BatchText> value )
    {
        if( toBatchText == null ) {
            toBatchText = Lists.newArrayList();
        }
        toBatchText.clear();
        toBatchText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BatchText</b> entities. This corresponds to the OData navigation
     * property <b>to_BatchText</b>.
     * <p>
     * If the navigation property <b>to_BatchText</b> of a queried <b>Batch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BatchText</b> entities.
     */
    public void addBatchText( BatchText... entity )
    {
        if( toBatchText == null ) {
            toBatchText = Lists.newArrayList();
        }
        toBatchText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Batch instances.
     *
     */
    public final static class BatchBuilder
    {

        private List<BatchCharc> toBatchCharc = Lists.newArrayList();
        private BatchClass toBatchClass;
        private List<BatchPlant> toBatchPlant = Lists.newArrayList();
        private List<BatchText> toBatchText = Lists.newArrayList();

        private Batch.BatchBuilder toBatchCharc( final List<BatchCharc> value )
        {
            toBatchCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BatchCharc</b> for <b>Batch</b> to multiple <b>BatchCharc</b>.
         *
         * @param value
         *            The BatchCharcs to build this Batch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Batch.BatchBuilder batchCharc( BatchCharc... value )
        {
            return toBatchCharc(Lists.newArrayList(value));
        }

        private Batch.BatchBuilder toBatchClass( final BatchClass value )
        {
            toBatchClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_BatchClass</b> for <b>Batch</b> to single <b>BatchClass</b>.
         *
         * @param value
         *            The BatchClass to build this Batch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Batch.BatchBuilder batchClass( final BatchClass value )
        {
            return toBatchClass(value);
        }

        private Batch.BatchBuilder toBatchPlant( final List<BatchPlant> value )
        {
            toBatchPlant.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BatchPlant</b> for <b>Batch</b> to multiple <b>BatchPlant</b>.
         *
         * @param value
         *            The BatchPlants to build this Batch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Batch.BatchBuilder batchPlant( BatchPlant... value )
        {
            return toBatchPlant(Lists.newArrayList(value));
        }

        private Batch.BatchBuilder toBatchText( final List<BatchText> value )
        {
            toBatchText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BatchText</b> for <b>Batch</b> to multiple <b>BatchText</b>.
         *
         * @param value
         *            The BatchTexts to build this Batch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Batch.BatchBuilder batchText( BatchText... value )
        {
            return toBatchText(Lists.newArrayList(value));
        }

    }

}
