/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchCharcValueField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchCharcValueOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable.BatchCharcValueSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Batch Characteristics Valuation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BatchCharcValueType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BatchCharcValue extends VdmEntity<BatchCharcValue>
{

    /**
     * Selector for all available fields of BatchCharcValue.
     *
     */
    public final static BatchCharcValueSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> MATERIAL = new BatchCharcValueField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "BatchIdentifyingPlant" )
    @JsonProperty( "BatchIdentifyingPlant" )
    @Nullable
    @ODataField( odataName = "BatchIdentifyingPlant" )
    private String batchIdentifyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>BatchIdentifyingPlant</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> BATCH_IDENTIFYING_PLANT =
        new BatchCharcValueField<String>("BatchIdentifyingPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> BATCH = new BatchCharcValueField<String>("Batch");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_INTERNAL_ID =
        new BatchCharcValueField<String>("CharcInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @return Characteristic value counter
     */
    @Key
    @SerializedName( "CharcValuePositionNumber" )
    @JsonProperty( "CharcValuePositionNumber" )
    @Nullable
    @ODataField( odataName = "CharcValuePositionNumber" )
    private String charcValuePositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CharcValuePositionNumber</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_VALUE_POSITION_NUMBER =
        new BatchCharcValueField<String>("CharcValuePositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @return Code for value dependency
     */
    @SerializedName( "CharcValueDependency" )
    @JsonProperty( "CharcValueDependency" )
    @Nullable
    @ODataField( odataName = "CharcValueDependency" )
    private String charcValueDependency;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueDependency</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_VALUE_DEPENDENCY =
        new BatchCharcValueField<String>("CharcValueDependency");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_VALUE = new BatchCharcValueField<String>("CharcValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @return Internal floating point from
     */
    @SerializedName( "CharcFromNumericValue" )
    @JsonProperty( "CharcFromNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValue" )
    private Double charcFromNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValue</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<Double> CHARC_FROM_NUMERIC_VALUE =
        new BatchCharcValueField<Double>("CharcFromNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcFromNumericValueUnit" )
    @JsonProperty( "CharcFromNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValueUnit" )
    private String charcFromNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValueUnit</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_FROM_NUMERIC_VALUE_UNIT =
        new BatchCharcValueField<String>("CharcFromNumericValueUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @return Internal floating point value to
     */
    @SerializedName( "CharcToNumericValue" )
    @JsonProperty( "CharcToNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValue" )
    private Double charcToNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValue</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<Double> CHARC_TO_NUMERIC_VALUE =
        new BatchCharcValueField<Double>("CharcToNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcToNumericValueUnit" )
    @JsonProperty( "CharcToNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValueUnit" )
    private String charcToNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValueUnit</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARC_TO_NUMERIC_VALUE_UNIT =
        new BatchCharcValueField<String>("CharcToNumericValueUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @return Lower Boundary for Numeric Field
     */
    @SerializedName( "CharcFromDecimalValue" )
    @JsonProperty( "CharcFromDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcFromDecimalValue" )
    private BigDecimal charcFromDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDecimalValue</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<BigDecimal> CHARC_FROM_DECIMAL_VALUE =
        new BatchCharcValueField<BigDecimal>("CharcFromDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @return Upper Boundary for Numeric Field
     */
    @SerializedName( "CharcToDecimalValue" )
    @JsonProperty( "CharcToDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcToDecimalValue" )
    private BigDecimal charcToDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDecimalValue</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<BigDecimal> CHARC_TO_DECIMAL_VALUE =
        new BatchCharcValueField<BigDecimal>("CharcToDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @return Lower Boundary for Currency Field
     */
    @SerializedName( "CharcFromAmount" )
    @JsonProperty( "CharcFromAmount" )
    @Nullable
    @ODataField( odataName = "CharcFromAmount" )
    private BigDecimal charcFromAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromAmount</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<BigDecimal> CHARC_FROM_AMOUNT =
        new BatchCharcValueField<BigDecimal>("CharcFromAmount");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @return Upper Boundary for Currency Field
     */
    @SerializedName( "CharcToAmount" )
    @JsonProperty( "CharcToAmount" )
    @Nullable
    @ODataField( odataName = "CharcToAmount" )
    private BigDecimal charcToAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcToAmount</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<BigDecimal> CHARC_TO_AMOUNT =
        new BatchCharcValueField<BigDecimal>("CharcToAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CURRENCY = new BatchCharcValueField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @return Lower Boundary for Date-Interval
     */
    @SerializedName( "CharcFromDate" )
    @JsonProperty( "CharcFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcFromDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDate</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<LocalDateTime> CHARC_FROM_DATE =
        new BatchCharcValueField<LocalDateTime>("CharcFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @return Upper Boundary for Date-Interval
     */
    @SerializedName( "CharcToDate" )
    @JsonProperty( "CharcToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcToDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDate</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<LocalDateTime> CHARC_TO_DATE =
        new BatchCharcValueField<LocalDateTime>("CharcToDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @return Lower Boundary for Time-Interval
     */
    @SerializedName( "CharcFromTime" )
    @JsonProperty( "CharcFromTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcFromTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromTime</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<LocalTime> CHARC_FROM_TIME =
        new BatchCharcValueField<LocalTime>("CharcFromTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @return Upper Boundary for Time-Interval
     */
    @SerializedName( "CharcToTime" )
    @JsonProperty( "CharcToTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcToTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcToTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcToTime</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<LocalTime> CHARC_TO_TIME =
        new BatchCharcValueField<LocalTime>("CharcToTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAuthor</b>
     * </p>
     *
     * @return Classification: Author
     */
    @SerializedName( "CharacteristicAuthor" )
    @JsonProperty( "CharacteristicAuthor" )
    @Nullable
    @ODataField( odataName = "CharacteristicAuthor" )
    private String characteristicAuthor;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAuthor</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<String> CHARACTERISTIC_AUTHOR =
        new BatchCharcValueField<String>("CharacteristicAuthor");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BatchCharcValueField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BatchCharcValueField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_BatchCharc</b> for <b>BatchCharcValue</b> to single <b>BatchCharc</b>.
     *
     */
    @SerializedName( "to_BatchCharc" )
    @JsonProperty( "to_BatchCharc" )
    @ODataField( odataName = "to_BatchCharc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BatchCharc toBatchCharc;
    /**
     * Use with available fluent helpers to apply the <b>to_BatchCharc</b> navigation property to query operations.
     *
     */
    public final static BatchCharcValueOneToOneLink<BatchCharc> TO_BATCH_CHARC =
        new BatchCharcValueOneToOneLink<BatchCharc>("to_BatchCharc");

    @Nonnull
    @Override
    public Class<BatchCharcValue> getType()
    {
        return BatchCharcValue.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @param batchIdentifyingPlant
     *            Plant
     */
    public void setBatchIdentifyingPlant( @Nullable final String batchIdentifyingPlant )
    {
        rememberChangedField("BatchIdentifyingPlant", this.batchIdentifyingPlant);
        this.batchIdentifyingPlant = batchIdentifyingPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     */
    public void setCharcValuePositionNumber( @Nullable final String charcValuePositionNumber )
    {
        rememberChangedField("CharcValuePositionNumber", this.charcValuePositionNumber);
        this.charcValuePositionNumber = charcValuePositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @param charcValueDependency
     *            Code for value dependency
     */
    public void setCharcValueDependency( @Nullable final String charcValueDependency )
    {
        rememberChangedField("CharcValueDependency", this.charcValueDependency);
        this.charcValueDependency = charcValueDependency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @param charcFromNumericValue
     *            Internal floating point from
     */
    public void setCharcFromNumericValue( @Nullable final Double charcFromNumericValue )
    {
        rememberChangedField("CharcFromNumericValue", this.charcFromNumericValue);
        this.charcFromNumericValue = charcFromNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @param charcFromNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcFromNumericValueUnit( @Nullable final String charcFromNumericValueUnit )
    {
        rememberChangedField("CharcFromNumericValueUnit", this.charcFromNumericValueUnit);
        this.charcFromNumericValueUnit = charcFromNumericValueUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @param charcToNumericValue
     *            Internal floating point value to
     */
    public void setCharcToNumericValue( @Nullable final Double charcToNumericValue )
    {
        rememberChangedField("CharcToNumericValue", this.charcToNumericValue);
        this.charcToNumericValue = charcToNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @param charcToNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcToNumericValueUnit( @Nullable final String charcToNumericValueUnit )
    {
        rememberChangedField("CharcToNumericValueUnit", this.charcToNumericValueUnit);
        this.charcToNumericValueUnit = charcToNumericValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @param charcFromDecimalValue
     *            Lower Boundary for Numeric Field
     */
    public void setCharcFromDecimalValue( @Nullable final BigDecimal charcFromDecimalValue )
    {
        rememberChangedField("CharcFromDecimalValue", this.charcFromDecimalValue);
        this.charcFromDecimalValue = charcFromDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @param charcToDecimalValue
     *            Upper Boundary for Numeric Field
     */
    public void setCharcToDecimalValue( @Nullable final BigDecimal charcToDecimalValue )
    {
        rememberChangedField("CharcToDecimalValue", this.charcToDecimalValue);
        this.charcToDecimalValue = charcToDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @param charcFromAmount
     *            Lower Boundary for Currency Field
     */
    public void setCharcFromAmount( @Nullable final BigDecimal charcFromAmount )
    {
        rememberChangedField("CharcFromAmount", this.charcFromAmount);
        this.charcFromAmount = charcFromAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @param charcToAmount
     *            Upper Boundary for Currency Field
     */
    public void setCharcToAmount( @Nullable final BigDecimal charcToAmount )
    {
        rememberChangedField("CharcToAmount", this.charcToAmount);
        this.charcToAmount = charcToAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @param charcFromDate
     *            Lower Boundary for Date-Interval
     */
    public void setCharcFromDate( @Nullable final LocalDateTime charcFromDate )
    {
        rememberChangedField("CharcFromDate", this.charcFromDate);
        this.charcFromDate = charcFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @param charcToDate
     *            Upper Boundary for Date-Interval
     */
    public void setCharcToDate( @Nullable final LocalDateTime charcToDate )
    {
        rememberChangedField("CharcToDate", this.charcToDate);
        this.charcToDate = charcToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @param charcFromTime
     *            Lower Boundary for Time-Interval
     */
    public void setCharcFromTime( @Nullable final LocalTime charcFromTime )
    {
        rememberChangedField("CharcFromTime", this.charcFromTime);
        this.charcFromTime = charcFromTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @param charcToTime
     *            Upper Boundary for Time-Interval
     */
    public void setCharcToTime( @Nullable final LocalTime charcToTime )
    {
        rememberChangedField("CharcToTime", this.charcToTime);
        this.charcToTime = charcToTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAuthor</b>
     * </p>
     *
     * @param characteristicAuthor
     *            Classification: Author
     */
    public void setCharacteristicAuthor( @Nullable final String characteristicAuthor )
    {
        rememberChangedField("CharacteristicAuthor", this.characteristicAuthor);
        this.characteristicAuthor = characteristicAuthor;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BatchCharcValue";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        result.put("Batch", getBatch());
        result.put("CharcInternalID", getCharcInternalID());
        result.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        values.put("Batch", getBatch());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        values.put("CharcValueDependency", getCharcValueDependency());
        values.put("CharcValue", getCharcValue());
        values.put("CharcFromNumericValue", getCharcFromNumericValue());
        values.put("CharcFromNumericValueUnit", getCharcFromNumericValueUnit());
        values.put("CharcToNumericValue", getCharcToNumericValue());
        values.put("CharcToNumericValueUnit", getCharcToNumericValueUnit());
        values.put("CharcFromDecimalValue", getCharcFromDecimalValue());
        values.put("CharcToDecimalValue", getCharcToDecimalValue());
        values.put("CharcFromAmount", getCharcFromAmount());
        values.put("CharcToAmount", getCharcToAmount());
        values.put("Currency", getCurrency());
        values.put("CharcFromDate", getCharcFromDate());
        values.put("CharcToDate", getCharcToDate());
        values.put("CharcFromTime", getCharcFromTime());
        values.put("CharcToTime", getCharcToTime());
        values.put("CharacteristicAuthor", getCharacteristicAuthor());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("BatchIdentifyingPlant") ) {
                final Object value = values.remove("BatchIdentifyingPlant");
                if( (value == null) || (!value.equals(getBatchIdentifyingPlant())) ) {
                    setBatchIdentifyingPlant(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcValuePositionNumber") ) {
                final Object value = values.remove("CharcValuePositionNumber");
                if( (value == null) || (!value.equals(getCharcValuePositionNumber())) ) {
                    setCharcValuePositionNumber(((String) value));
                }
            }
            if( values.containsKey("CharcValueDependency") ) {
                final Object value = values.remove("CharcValueDependency");
                if( (value == null) || (!value.equals(getCharcValueDependency())) ) {
                    setCharcValueDependency(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
            if( values.containsKey("CharcFromNumericValue") ) {
                final Object value = values.remove("CharcFromNumericValue");
                if( (value == null) || (!value.equals(getCharcFromNumericValue())) ) {
                    setCharcFromNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcFromNumericValueUnit") ) {
                final Object value = values.remove("CharcFromNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcFromNumericValueUnit())) ) {
                    setCharcFromNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcToNumericValue") ) {
                final Object value = values.remove("CharcToNumericValue");
                if( (value == null) || (!value.equals(getCharcToNumericValue())) ) {
                    setCharcToNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcToNumericValueUnit") ) {
                final Object value = values.remove("CharcToNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcToNumericValueUnit())) ) {
                    setCharcToNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcFromDecimalValue") ) {
                final Object value = values.remove("CharcFromDecimalValue");
                if( (value == null) || (!value.equals(getCharcFromDecimalValue())) ) {
                    setCharcFromDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToDecimalValue") ) {
                final Object value = values.remove("CharcToDecimalValue");
                if( (value == null) || (!value.equals(getCharcToDecimalValue())) ) {
                    setCharcToDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcFromAmount") ) {
                final Object value = values.remove("CharcFromAmount");
                if( (value == null) || (!value.equals(getCharcFromAmount())) ) {
                    setCharcFromAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToAmount") ) {
                final Object value = values.remove("CharcToAmount");
                if( (value == null) || (!value.equals(getCharcToAmount())) ) {
                    setCharcToAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("CharcFromDate") ) {
                final Object value = values.remove("CharcFromDate");
                if( (value == null) || (!value.equals(getCharcFromDate())) ) {
                    setCharcFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcToDate") ) {
                final Object value = values.remove("CharcToDate");
                if( (value == null) || (!value.equals(getCharcToDate())) ) {
                    setCharcToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcFromTime") ) {
                final Object value = values.remove("CharcFromTime");
                if( (value == null) || (!value.equals(getCharcFromTime())) ) {
                    setCharcFromTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharcToTime") ) {
                final Object value = values.remove("CharcToTime");
                if( (value == null) || (!value.equals(getCharcToTime())) ) {
                    setCharcToTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharacteristicAuthor") ) {
                final Object value = values.remove("CharacteristicAuthor");
                if( (value == null) || (!value.equals(getCharacteristicAuthor())) ) {
                    setCharacteristicAuthor(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BatchCharc") ) {
                final Object value = (values).remove("to_BatchCharc");
                if( value instanceof Map ) {
                    if( toBatchCharc == null ) {
                        toBatchCharc = new BatchCharc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBatchCharc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BatchCharcValueField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BatchCharcValueField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BatchCharcValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BatchCharcValueField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBatchCharc != null ) {
            (values).put("to_BatchCharc", toBatchCharc);
        }
        return values;
    }

    /**
     * Fetches the <b>BatchCharc</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BatchCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BatchCharc</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BatchCharc fetchBatchCharc()
    {
        return fetchFieldAsSingle("to_BatchCharc", BatchCharc.class);
    }

    /**
     * Retrieval of associated <b>BatchCharc</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property <b>to_BatchCharc</b> of a queried <b>BatchCharcValue</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BatchCharc</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BatchCharc getBatchCharcOrFetch()
    {
        if( toBatchCharc == null ) {
            toBatchCharc = fetchBatchCharc();
        }
        return toBatchCharc;
    }

    /**
     * Retrieval of associated <b>BatchCharc</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BatchCharc</b>.
     * <p>
     * If the navigation property for an entity <b>BatchCharcValue</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchCharc</b> is already loaded, the result will
     *         contain the <b>BatchCharc</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<BatchCharc> getBatchCharcIfPresent()
    {
        return Option.of(toBatchCharc);
    }

    /**
     * Overwrites the associated <b>BatchCharc</b> entity for the loaded navigation property <b>to_BatchCharc</b>.
     *
     * @param value
     *            New <b>BatchCharc</b> entity.
     */
    public void setBatchCharc( final BatchCharc value )
    {
        toBatchCharc = value;
    }

    /**
     * Helper class to allow for fluent creation of BatchCharcValue instances.
     *
     */
    public final static class BatchCharcValueBuilder
    {

        private BatchCharc toBatchCharc;

        private BatchCharcValue.BatchCharcValueBuilder toBatchCharc( final BatchCharc value )
        {
            toBatchCharc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BatchCharc</b> for <b>BatchCharcValue</b> to single <b>BatchCharc</b>.
         *
         * @param value
         *            The BatchCharc to build this BatchCharcValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BatchCharcValue.BatchCharcValueBuilder batchCharc( final BatchCharc value )
        {
            return toBatchCharc(value);
        }

    }

}
