/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchClassOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable.BatchClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Batch Class Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BatchClassType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BatchClass extends VdmEntity<BatchClass>
{

    /**
     * Selector for all available fields of BatchClass.
     *
     */
    public final static BatchClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BatchClassField<String> MATERIAL = new BatchClassField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "BatchIdentifyingPlant" )
    @JsonProperty( "BatchIdentifyingPlant" )
    @Nullable
    @ODataField( odataName = "BatchIdentifyingPlant" )
    private String batchIdentifyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>BatchIdentifyingPlant</b> field to query operations.
     *
     */
    public final static BatchClassField<String> BATCH_IDENTIFYING_PLANT =
        new BatchClassField<String>("BatchIdentifyingPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static BatchClassField<String> BATCH = new BatchClassField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static BatchClassField<String> CLASS_INTERNAL_ID = new BatchClassField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BatchClassField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BatchClassField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Batch</b> for <b>BatchClass</b> to single <b>Batch</b>.
     *
     */
    @SerializedName( "to_Batch" )
    @JsonProperty( "to_Batch" )
    @ODataField( odataName = "to_Batch" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Batch toBatch;
    /**
     * Use with available fluent helpers to apply the <b>to_Batch</b> navigation property to query operations.
     *
     */
    public final static BatchClassOneToOneLink<Batch> TO_BATCH = new BatchClassOneToOneLink<Batch>("to_Batch");

    @Nonnull
    @Override
    public Class<BatchClass> getType()
    {
        return BatchClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchIdentifyingPlant</b>
     * </p>
     *
     * @param batchIdentifyingPlant
     *            Plant
     */
    public void setBatchIdentifyingPlant( @Nullable final String batchIdentifyingPlant )
    {
        rememberChangedField("BatchIdentifyingPlant", this.batchIdentifyingPlant);
        this.batchIdentifyingPlant = batchIdentifyingPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BatchClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        result.put("Batch", getBatch());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("BatchIdentifyingPlant", getBatchIdentifyingPlant());
        values.put("Batch", getBatch());
        values.put("ClassInternalID", getClassInternalID());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("BatchIdentifyingPlant") ) {
                final Object value = values.remove("BatchIdentifyingPlant");
                if( (value == null) || (!value.equals(getBatchIdentifyingPlant())) ) {
                    setBatchIdentifyingPlant(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Batch") ) {
                final Object value = (values).remove("to_Batch");
                if( value instanceof Map ) {
                    if( toBatch == null ) {
                        toBatch = new Batch();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBatch.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BatchClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BatchClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BatchClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BatchClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBatch != null ) {
            (values).put("to_Batch", toBatch);
        }
        return values;
    }

    /**
     * Fetches the <b>Batch</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Batch</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Batch</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Batch fetchBatch()
    {
        return fetchFieldAsSingle("to_Batch", Batch.class);
    }

    /**
     * Retrieval of associated <b>Batch</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Batch</b>.
     * <p>
     * If the navigation property <b>to_Batch</b> of a queried <b>BatchClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Batch</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Batch getBatchOrFetch()
    {
        if( toBatch == null ) {
            toBatch = fetchBatch();
        }
        return toBatch;
    }

    /**
     * Retrieval of associated <b>Batch</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Batch</b>.
     * <p>
     * If the navigation property for an entity <b>BatchClass</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Batch</b> is already loaded, the result will contain the
     *         <b>Batch</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<Batch> getBatchIfPresent()
    {
        return Option.of(toBatch);
    }

    /**
     * Overwrites the associated <b>Batch</b> entity for the loaded navigation property <b>to_Batch</b>.
     *
     * @param value
     *            New <b>Batch</b> entity.
     */
    public void setBatch( final Batch value )
    {
        toBatch = value;
    }

    /**
     * Helper class to allow for fluent creation of BatchClass instances.
     *
     */
    public final static class BatchClassBuilder
    {

        private Batch toBatch;
        private String batch = null;

        private BatchClass.BatchClassBuilder toBatch( final Batch value )
        {
            toBatch = value;
            return this;
        }

        /**
         * Navigation property <b>to_Batch</b> for <b>BatchClass</b> to single <b>Batch</b>.
         *
         * @param value
         *            The Batch to build this BatchClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BatchClass.BatchClassBuilder batch( final Batch value )
        {
            return toBatch(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>Batch</b>
         * </p>
         *
         * @param value
         *            The batch to build this BatchClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BatchClass.BatchClassBuilder batch( final String value )
        {
            batch = value;
            return this;
        }

    }

}
