/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService BatchService}.
 *
 */
public interface BatchServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BatchServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BatchServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity and save it to
     * the S/4HANA system.
     *
     * @param batch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity object that will
     *            be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet createBatch( @Nonnull final Batch batch );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity and save
     * it to the S/4HANA system.
     *
     * @param batch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity object that will
     *            be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet updateBatch( @Nonnull final Batch batch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity and
     * save it to the S/4HANA system.
     *
     * @param batchCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity object
     *            that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet createBatchCharc( @Nonnull final BatchCharc batchCharc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     * entity and save it to the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet createBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue
     * BatchCharcValue} entity and save it to the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet updateBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue
     * BatchCharcValue} entity in the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet deleteBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity and
     * save it to the S/4HANA system.
     *
     * @param batchClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity object
     *            that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet createBatchClass( @Nonnull final BatchClass batchClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass}
     * entity in the S/4HANA system.
     *
     * @param batchClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity object
     *            that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet deleteBatchClass( @Nonnull final BatchClass batchClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity
     * and save it to the S/4HANA system.
     *
     * @param batchPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity object
     *            that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet updateBatchPlant( @Nonnull final BatchPlant batchPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity
     * and save it to the S/4HANA system.
     *
     * @param batchText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity object
     *            that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet updateBatchText( @Nonnull final BatchText batchText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity
     * in the S/4HANA system.
     *
     * @param batchText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity object
     *            that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BatchServiceBatchChangeSet deleteBatchText( @Nonnull final BatchText batchText );

}
