/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BatchServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService BatchService}, allowing you to create multiple
 * changesets and finally execute the batch request.
 *
 */
public class DefaultBatchServiceBatch extends BatchFluentHelperBasic<BatchServiceBatch, BatchServiceBatchChangeSet>
    implements
    BatchServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBatchServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBatchServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBatchServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBatchServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBatchServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBatchServiceBatchChangeSet(this, service);
    }

}
