/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText;

/**
 * Implementation of the {@link BatchServiceBatchChangeSet} interface, enabling you to combine multiple operations into
 * one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService BatchService}.
 *
 */
public class DefaultBatchServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BatchServiceBatch, BatchServiceBatchChangeSet>
    implements
    BatchServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService service;

    @SuppressWarnings( "deprecation" )
    DefaultBatchServiceBatchChangeSet(
        @Nonnull final DefaultBatchServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BatchService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBatchServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet createBatch( @Nonnull final Batch batch )
    {
        return addRequestCreate(service::createBatch, batch);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet updateBatch( @Nonnull final Batch batch )
    {
        return addRequestUpdate(service::updateBatch, batch);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet createBatchCharc( @Nonnull final BatchCharc batchCharc )
    {
        return addRequestCreate(service::createBatchCharc, batchCharc);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet createBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return addRequestCreate(service::createBatchCharcValue, batchCharcValue);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet updateBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return addRequestUpdate(service::updateBatchCharcValue, batchCharcValue);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet deleteBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return addRequestDelete(service::deleteBatchCharcValue, batchCharcValue);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet createBatchClass( @Nonnull final BatchClass batchClass )
    {
        return addRequestCreate(service::createBatchClass, batchClass);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet deleteBatchClass( @Nonnull final BatchClass batchClass )
    {
        return addRequestDelete(service::deleteBatchClass, batchClass);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet updateBatchPlant( @Nonnull final BatchPlant batchPlant )
    {
        return addRequestUpdate(service::updateBatchPlant, batchPlant);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet updateBatchText( @Nonnull final BatchText batchText )
    {
        return addRequestUpdate(service::updateBatchText, batchText);
    }

    @Nonnull
    @Override
    public BatchServiceBatchChangeSet deleteBatchText( @Nonnull final BatchText batchText )
    {
        return addRequestDelete(service::deleteBatchText, batchText);
    }

}
