/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchCharcField BatchCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchCharcLink BatchCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#BATCH_IDENTIFYING_PLANT
 * BATCH_IDENTIFYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#TO_BATCH TO_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc#TO_BATCH_CHARC_VALUE
 * TO_BATCH_CHARC_VALUE}</li>
 * </ul>
 *
 */
public interface BatchCharcSelectable extends EntitySelectable<BatchCharc>
{

}
