/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchCharcValueField
 * BatchCharcValueField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchCharcValueLink
 * BatchCharcValueLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#BATCH_IDENTIFYING_PLANT
 * BATCH_IDENTIFYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_VALUE_POSITION_NUMBER
 * CHARC_VALUE_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_VALUE_DEPENDENCY
 * CHARC_VALUE_DEPENDENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_VALUE CHARC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_NUMERIC_VALUE
 * CHARC_FROM_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_NUMERIC_VALUE_UNIT
 * CHARC_FROM_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_NUMERIC_VALUE
 * CHARC_TO_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_NUMERIC_VALUE_UNIT
 * CHARC_TO_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_DECIMAL_VALUE
 * CHARC_FROM_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_DECIMAL_VALUE
 * CHARC_TO_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_AMOUNT
 * CHARC_FROM_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_AMOUNT
 * CHARC_TO_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_DATE
 * CHARC_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_DATE
 * CHARC_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_FROM_TIME
 * CHARC_FROM_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARC_TO_TIME
 * CHARC_TO_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#CHARACTERISTIC_AUTHOR
 * CHARACTERISTIC_AUTHOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue#TO_BATCH_CHARC
 * TO_BATCH_CHARC}</li>
 * </ul>
 *
 */
public interface BatchCharcValueSelectable extends EntitySelectable<BatchCharcValue>
{

}
