/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchPlantField BatchPlantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchPlantLink BatchPlantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#BATCH_IDENTIFYING_PLANT
 * BATCH_IDENTIFYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant#TO_BATCH TO_BATCH}</li>
 * </ul>
 *
 */
public interface BatchPlantSelectable extends EntitySelectable<BatchPlant>
{

}
