/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch;

/**
 * Interface to enable OData entity selectors for {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch
 * Batch}. This interface is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.field.BatchField
 * BatchField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.link.BatchLink BatchLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#BATCH_IDENTIFYING_PLANT
 * BATCH_IDENTIFYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#BATCH_IS_MARKED_FOR_DELETION
 * BATCH_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#MATL_BATCH_IS_IN_RSTRCD_USE_STOCK
 * MATL_BATCH_IS_IN_RSTRCD_USE_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#SUPPLIER SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#BATCH_BY_SUPPLIER BATCH_BY_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#COUNTRY_OF_ORIGIN COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#REGION_OF_ORIGIN REGION_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#MATL_BATCH_AVAILABILITY_DATE
 * MATL_BATCH_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#MANUFACTURE_DATE MANUFACTURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE1
 * FREE_DEFINED_DATE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE2
 * FREE_DEFINED_DATE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE3
 * FREE_DEFINED_DATE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE4
 * FREE_DEFINED_DATE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE5
 * FREE_DEFINED_DATE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#FREE_DEFINED_DATE6
 * FREE_DEFINED_DATE6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#BATCH_EXT_WHSE_MGMT_INTERNAL_ID
 * BATCH_EXT_WHSE_MGMT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#TO_BATCH_CHARC TO_BATCH_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#TO_BATCH_CLASS TO_BATCH_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#TO_BATCH_PLANT TO_BATCH_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch#TO_BATCH_TEXT TO_BATCH_TEXT}</li>
 * </ul>
 *
 */
public interface BatchSelectable extends EntitySelectable<Batch>
{

}
