/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable.BillingDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Billing Document Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocument extends VdmEntity<BillingDocument>
{

    /**
     * Selector for all available fields of BillingDocument.
     *
     */
    public final static BillingDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @Key
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_DOCUMENT =
        new BillingDocumentField<String>("BillingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return SD Document Category
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SD_DOCUMENT_CATEGORY =
        new BillingDocumentField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentCategory</b>
     * </p>
     *
     * @return Billing Category
     */
    @SerializedName( "BillingDocumentCategory" )
    @JsonProperty( "BillingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "BillingDocumentCategory" )
    private String billingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_DOCUMENT_CATEGORY =
        new BillingDocumentField<String>("BillingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Type
     */
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_DOCUMENT_TYPE =
        new BillingDocumentField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> CREATION_DATE =
        new BillingDocumentField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalTime> CREATION_TIME =
        new BillingDocumentField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> LAST_CHANGE_DATE =
        new BillingDocumentField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BillingDocumentField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BillingDocumentField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> LOGICAL_SYSTEM = new BillingDocumentField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SALES_ORGANIZATION =
        new BillingDocumentField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DISTRIBUTION_CHANNEL =
        new BillingDocumentField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DIVISION = new BillingDocumentField<String>("Division");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingDocumentDate" )
    @JsonProperty( "BillingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> BILLING_DOCUMENT_DATE =
        new BillingDocumentField<LocalDateTime>("BillingDocumentDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentIsCancelled</b>
     * </p>
     *
     * @return Billing document is canceled
     */
    @SerializedName( "BillingDocumentIsCancelled" )
    @JsonProperty( "BillingDocumentIsCancelled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BillingDocumentIsCancelled" )
    private Boolean billingDocumentIsCancelled;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentIsCancelled</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> BILLING_DOCUMENT_IS_CANCELLED =
        new BillingDocumentField<Boolean>("BillingDocumentIsCancelled");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CancelledBillingDocument</b>
     * </p>
     *
     * @return Number of canceled billing document
     */
    @SerializedName( "CancelledBillingDocument" )
    @JsonProperty( "CancelledBillingDocument" )
    @Nullable
    @ODataField( odataName = "CancelledBillingDocument" )
    private String cancelledBillingDocument;
    /**
     * Use with available fluent helpers to apply the <b>CancelledBillingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CANCELLED_BILLING_DOCUMENT =
        new BillingDocumentField<String>("CancelledBillingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ForeignTrade</b>
     * </p>
     *
     * @return Number of foreign trade data in MM and SD documents
     */
    @SerializedName( "ForeignTrade" )
    @JsonProperty( "ForeignTrade" )
    @Nullable
    @ODataField( odataName = "ForeignTrade" )
    private String foreignTrade;
    /**
     * Use with available fluent helpers to apply the <b>ForeignTrade</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> FOREIGN_TRADE = new BillingDocumentField<String>("ForeignTrade");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsExportDelivery</b>
     * </p>
     *
     * @return Export indicator
     */
    @SerializedName( "IsExportDelivery" )
    @JsonProperty( "IsExportDelivery" )
    @Nullable
    @ODataField( odataName = "IsExportDelivery" )
    private String isExportDelivery;
    /**
     * Use with available fluent helpers to apply the <b>IsExportDelivery</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> IS_EXPORT_DELIVERY =
        new BillingDocumentField<String>("IsExportDelivery");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocCombinationCriteria</b>
     * </p>
     *
     * @return Combination criteria in the billing document
     */
    @SerializedName( "BillingDocCombinationCriteria" )
    @JsonProperty( "BillingDocCombinationCriteria" )
    @Nullable
    @ODataField( odataName = "BillingDocCombinationCriteria" )
    private String billingDocCombinationCriteria;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocCombinationCriteria</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_DOC_COMBINATION_CRITERIA =
        new BillingDocumentField<String>("BillingDocCombinationCriteria");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ManualInvoiceMaintIsRelevant</b>
     * </p>
     *
     * @return Manual Invoice Maintenance
     */
    @SerializedName( "ManualInvoiceMaintIsRelevant" )
    @JsonProperty( "ManualInvoiceMaintIsRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ManualInvoiceMaintIsRelevant" )
    private Boolean manualInvoiceMaintIsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>ManualInvoiceMaintIsRelevant</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> MANUAL_INVOICE_MAINT_IS_RELEVANT =
        new BillingDocumentField<Boolean>("ManualInvoiceMaintIsRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsIntrastatReportingRelevant</b>
     * </p>
     *
     * @return Relevant for Intrastat Reporting
     */
    @SerializedName( "IsIntrastatReportingRelevant" )
    @JsonProperty( "IsIntrastatReportingRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsIntrastatReportingRelevant" )
    private Boolean isIntrastatReportingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsIntrastatReportingRelevant</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> IS_INTRASTAT_REPORTING_RELEVANT =
        new BillingDocumentField<Boolean>("IsIntrastatReportingRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsIntrastatReportingExcluded</b>
     * </p>
     *
     * @return Exclude from Intrastat Reporting
     */
    @SerializedName( "IsIntrastatReportingExcluded" )
    @JsonProperty( "IsIntrastatReportingExcluded" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsIntrastatReportingExcluded" )
    private Boolean isIntrastatReportingExcluded;
    /**
     * Use with available fluent helpers to apply the <b>IsIntrastatReportingExcluded</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> IS_INTRASTAT_REPORTING_EXCLUDED =
        new BillingDocumentField<Boolean>("IsIntrastatReportingExcluded");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentField<BigDecimal> TOTAL_NET_AMOUNT =
        new BillingDocumentField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> TRANSACTION_CURRENCY =
        new BillingDocumentField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @return Statistics Currency
     */
    @SerializedName( "StatisticsCurrency" )
    @JsonProperty( "StatisticsCurrency" )
    @Nullable
    @ODataField( odataName = "StatisticsCurrency" )
    private String statisticsCurrency;
    /**
     * Use with available fluent helpers to apply the <b>StatisticsCurrency</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> STATISTICS_CURRENCY =
        new BillingDocumentField<String>("StatisticsCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentField<BigDecimal> TAX_AMOUNT = new BillingDocumentField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     *
     * @return The totalGrossAmount contained in this entity.
     */
    @SerializedName( "TotalGrossAmount" )
    @JsonProperty( "TotalGrossAmount" )
    @Nullable
    @ODataField( odataName = "TotalGrossAmount" )
    private BigDecimal totalGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalGrossAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentField<BigDecimal> TOTAL_GROSS_AMOUNT =
        new BillingDocumentField<BigDecimal>("TotalGrossAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @return Customer Price Group
     */
    @SerializedName( "CustomerPriceGroup" )
    @JsonProperty( "CustomerPriceGroup" )
    @Nullable
    @ODataField( odataName = "CustomerPriceGroup" )
    private String customerPriceGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPriceGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_PRICE_GROUP =
        new BillingDocumentField<String>("CustomerPriceGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @return Price List Type
     */
    @SerializedName( "PriceListType" )
    @JsonProperty( "PriceListType" )
    @Nullable
    @ODataField( odataName = "PriceListType" )
    private String priceListType;
    /**
     * Use with available fluent helpers to apply the <b>PriceListType</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PRICE_LIST_TYPE =
        new BillingDocumentField<String>("PriceListType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @return Tax Departure Country/Region
     */
    @SerializedName( "TaxDepartureCountry" )
    @JsonProperty( "TaxDepartureCountry" )
    @Nullable
    @ODataField( odataName = "TaxDepartureCountry" )
    private String taxDepartureCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxDepartureCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> TAX_DEPARTURE_COUNTRY =
        new BillingDocumentField<String>("TaxDepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "VATRegistration" )
    @JsonProperty( "VATRegistration" )
    @Nullable
    @ODataField( odataName = "VATRegistration" )
    private String vATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistration</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> VAT_REGISTRATION =
        new BillingDocumentField<String>("VATRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationOrigin</b>
     * </p>
     *
     * @return Origin of Sales Tax Number
     */
    @SerializedName( "VATRegistrationOrigin" )
    @JsonProperty( "VATRegistrationOrigin" )
    @Nullable
    @ODataField( odataName = "VATRegistrationOrigin" )
    private String vATRegistrationOrigin;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistrationOrigin</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> VAT_REGISTRATION_ORIGIN =
        new BillingDocumentField<String>("VATRegistrationOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @return Country/Region of Sales Tax ID Number
     */
    @SerializedName( "VATRegistrationCountry" )
    @JsonProperty( "VATRegistrationCountry" )
    @Nullable
    @ODataField( odataName = "VATRegistrationCountry" )
    private String vATRegistrationCountry;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistrationCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> VAT_REGISTRATION_COUNTRY =
        new BillingDocumentField<String>("VATRegistrationCountry");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyTypePricing</b>
     * </p>
     *
     * @return Hierarchy type for pricing
     */
    @SerializedName( "HierarchyTypePricing" )
    @JsonProperty( "HierarchyTypePricing" )
    @Nullable
    @ODataField( odataName = "HierarchyTypePricing" )
    private String hierarchyTypePricing;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyTypePricing</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> HIERARCHY_TYPE_PRICING =
        new BillingDocumentField<String>("HierarchyTypePricing");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification 1 for Customer
     */
    @SerializedName( "CustomerTaxClassification1" )
    @JsonProperty( "CustomerTaxClassification1" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification1" )
    private String customerTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification1</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION1 =
        new BillingDocumentField<String>("CustomerTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Customer
     */
    @SerializedName( "CustomerTaxClassification2" )
    @JsonProperty( "CustomerTaxClassification2" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification2" )
    private String customerTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification2</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION2 =
        new BillingDocumentField<String>("CustomerTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Customer
     */
    @SerializedName( "CustomerTaxClassification3" )
    @JsonProperty( "CustomerTaxClassification3" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification3" )
    private String customerTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification3</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION3 =
        new BillingDocumentField<String>("CustomerTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Customer
     */
    @SerializedName( "CustomerTaxClassification4" )
    @JsonProperty( "CustomerTaxClassification4" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification4" )
    private String customerTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification4</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION4 =
        new BillingDocumentField<String>("CustomerTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Customer
     */
    @SerializedName( "CustomerTaxClassification5" )
    @JsonProperty( "CustomerTaxClassification5" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification5" )
    private String customerTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification5</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION5 =
        new BillingDocumentField<String>("CustomerTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Customer
     */
    @SerializedName( "CustomerTaxClassification6" )
    @JsonProperty( "CustomerTaxClassification6" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification6" )
    private String customerTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification6</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION6 =
        new BillingDocumentField<String>("CustomerTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Customer
     */
    @SerializedName( "CustomerTaxClassification7" )
    @JsonProperty( "CustomerTaxClassification7" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification7" )
    private String customerTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification7</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION7 =
        new BillingDocumentField<String>("CustomerTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Customer
     */
    @SerializedName( "CustomerTaxClassification8" )
    @JsonProperty( "CustomerTaxClassification8" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification8" )
    private String customerTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification8</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION8 =
        new BillingDocumentField<String>("CustomerTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Customer
     */
    @SerializedName( "CustomerTaxClassification9" )
    @JsonProperty( "CustomerTaxClassification9" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification9" )
    private String customerTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification9</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_TAX_CLASSIFICATION9 =
        new BillingDocumentField<String>("CustomerTaxClassification9");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @return Indicator: Triangular Deal Within the EU
     */
    @SerializedName( "IsEUTriangularDeal" )
    @JsonProperty( "IsEUTriangularDeal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEUTriangularDeal" )
    private Boolean isEUTriangularDeal;
    /**
     * Use with available fluent helpers to apply the <b>IsEUTriangularDeal</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> IS_EU_TRIANGULAR_DEAL =
        new BillingDocumentField<Boolean>("IsEUTriangularDeal");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDPricingProcedure</b>
     * </p>
     *
     * @return Pricing Procedure in Pricing
     */
    @SerializedName( "SDPricingProcedure" )
    @JsonProperty( "SDPricingProcedure" )
    @Nullable
    @ODataField( odataName = "SDPricingProcedure" )
    private String sDPricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SDPricingProcedure</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SD_PRICING_PROCEDURE =
        new BillingDocumentField<String>("SDPricingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SHIPPING_CONDITION =
        new BillingDocumentField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INCOTERMS_VERSION =
        new BillingDocumentField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INCOTERMS_CLASSIFICATION =
        new BillingDocumentField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INCOTERMS_TRANSFER_LOCATION =
        new BillingDocumentField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INCOTERMS_LOCATION1 =
        new BillingDocumentField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INCOTERMS_LOCATION2 =
        new BillingDocumentField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PAYER_PARTY = new BillingDocumentField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @return Contract Account Number
     */
    @SerializedName( "ContractAccount" )
    @JsonProperty( "ContractAccount" )
    @Nullable
    @ODataField( odataName = "ContractAccount" )
    private String contractAccount;
    /**
     * Use with available fluent helpers to apply the <b>ContractAccount</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CONTRACT_ACCOUNT =
        new BillingDocumentField<String>("ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_PAYMENT_TERMS =
        new BillingDocumentField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PAYMENT_METHOD = new BillingDocumentField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PAYMENT_REFERENCE =
        new BillingDocumentField<String>("PaymentReference");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> FIXED_VALUE_DATE =
        new BillingDocumentField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> ADDITIONAL_VALUE_DAYS =
        new BillingDocumentField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate for each Payee
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SEPA_MANDATE = new BillingDocumentField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> COMPANY_CODE = new BillingDocumentField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> FISCAL_YEAR = new BillingDocumentField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> ACCOUNTING_DOCUMENT =
        new BillingDocumentField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Customer
     */
    @SerializedName( "CustomerAccountAssignmentGroup" )
    @JsonProperty( "CustomerAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "CustomerAccountAssignmentGroup" )
    private String customerAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_ACCOUNT_ASSIGNMENT_GROUP =
        new BillingDocumentField<String>("CustomerAccountAssignmentGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRateIsSet</b>
     * </p>
     *
     * @return Exchange Rate Setting
     */
    @SerializedName( "AccountingExchangeRateIsSet" )
    @JsonProperty( "AccountingExchangeRateIsSet" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountingExchangeRateIsSet" )
    private Boolean accountingExchangeRateIsSet;
    /**
     * Use with available fluent helpers to apply the <b>AccountingExchangeRateIsSet</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> ACCOUNTING_EXCHANGE_RATE_IS_SET =
        new BillingDocumentField<Boolean>("AccountingExchangeRateIsSet");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltAccountingExchangeRate</b>
     * </p>
     *
     * @return Absolute exchange rate for FI postings
     */
    @SerializedName( "AbsltAccountingExchangeRate" )
    @JsonProperty( "AbsltAccountingExchangeRate" )
    @Nullable
    @ODataField( odataName = "AbsltAccountingExchangeRate" )
    private BigDecimal absltAccountingExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AbsltAccountingExchangeRate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<BigDecimal> ABSLT_ACCOUNTING_EXCHANGE_RATE =
        new BillingDocumentField<BigDecimal>("AbsltAccountingExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AcctgExchangeRateIsIndrctQtan</b>
     * </p>
     *
     * @return Accounting exchange rate quotation is indirect
     */
    @SerializedName( "AcctgExchangeRateIsIndrctQtan" )
    @JsonProperty( "AcctgExchangeRateIsIndrctQtan" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AcctgExchangeRateIsIndrctQtan" )
    private Boolean acctgExchangeRateIsIndrctQtan;
    /**
     * Use with available fluent helpers to apply the <b>AcctgExchangeRateIsIndrctQtan</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> ACCTG_EXCHANGE_RATE_IS_INDRCT_QTAN =
        new BillingDocumentField<Boolean>("AcctgExchangeRateIsIndrctQtan");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @return Translation Date
     */
    @SerializedName( "ExchangeRateDate" )
    @JsonProperty( "ExchangeRateDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ExchangeRateDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime exchangeRateDate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> EXCHANGE_RATE_DATE =
        new BillingDocumentField<LocalDateTime>("ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     *
     * @return Exchange Rate Type
     */
    @SerializedName( "ExchangeRateType" )
    @JsonProperty( "ExchangeRateType" )
    @Nullable
    @ODataField( odataName = "ExchangeRateType" )
    private String exchangeRateType;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateType</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> EXCHANGE_RATE_TYPE =
        new BillingDocumentField<String>("ExchangeRateType");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DOCUMENT_REFERENCE_ID =
        new BillingDocumentField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> ASSIGNMENT_REFERENCE =
        new BillingDocumentField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     *
     * @return Dunning Area
     */
    @SerializedName( "DunningArea" )
    @JsonProperty( "DunningArea" )
    @Nullable
    @ODataField( odataName = "DunningArea" )
    private String dunningArea;
    /**
     * Use with available fluent helpers to apply the <b>DunningArea</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DUNNING_AREA = new BillingDocumentField<String>("DunningArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     *
     * @return Dunning Block
     */
    @SerializedName( "DunningBlockingReason" )
    @JsonProperty( "DunningBlockingReason" )
    @Nullable
    @ODataField( odataName = "DunningBlockingReason" )
    private String dunningBlockingReason;
    /**
     * Use with available fluent helpers to apply the <b>DunningBlockingReason</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DUNNING_BLOCKING_REASON =
        new BillingDocumentField<String>("DunningBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     *
     * @return Dunning Key
     */
    @SerializedName( "DunningKey" )
    @JsonProperty( "DunningKey" )
    @Nullable
    @ODataField( odataName = "DunningKey" )
    private String dunningKey;
    /**
     * Use with available fluent helpers to apply the <b>DunningKey</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> DUNNING_KEY = new BillingDocumentField<String>("DunningKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalFinancialDocument</b>
     * </p>
     *
     * @return Financial doc. processing: Internal financial doc. number
     */
    @SerializedName( "InternalFinancialDocument" )
    @JsonProperty( "InternalFinancialDocument" )
    @Nullable
    @ODataField( odataName = "InternalFinancialDocument" )
    private String internalFinancialDocument;
    /**
     * Use with available fluent helpers to apply the <b>InternalFinancialDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INTERNAL_FINANCIAL_DOCUMENT =
        new BillingDocumentField<String>("InternalFinancialDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @return Is relevant for accrual
     */
    @SerializedName( "IsRelevantForAccrual" )
    @JsonProperty( "IsRelevantForAccrual" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForAccrual" )
    private Boolean isRelevantForAccrual;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForAccrual</b> field to query operations.
     *
     */
    public final static BillingDocumentField<Boolean> IS_RELEVANT_FOR_ACCRUAL =
        new BillingDocumentField<Boolean>("IsRelevantForAccrual");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SOLD_TO_PARTY = new BillingDocumentField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PARTNER_COMPANY =
        new BillingDocumentField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new BillingDocumentField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_GROUP = new BillingDocumentField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Destination Country/Region
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> COUNTRY = new BillingDocumentField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @return City Code
     */
    @SerializedName( "CityCode" )
    @JsonProperty( "CityCode" )
    @Nullable
    @ODataField( odataName = "CityCode" )
    private String cityCode;
    /**
     * Use with available fluent helpers to apply the <b>CityCode</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CITY_CODE = new BillingDocumentField<String>("CityCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SALES_DISTRICT = new BillingDocumentField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> REGION = new BillingDocumentField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @return County Code
     */
    @SerializedName( "County" )
    @JsonProperty( "County" )
    @Nullable
    @ODataField( odataName = "County" )
    private String county;
    /**
     * Use with available fluent helpers to apply the <b>County</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> COUNTY = new BillingDocumentField<String>("County");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @return Credit Control Area
     */
    @SerializedName( "CreditControlArea" )
    @JsonProperty( "CreditControlArea" )
    @Nullable
    @ODataField( odataName = "CreditControlArea" )
    private String creditControlArea;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlArea</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CREDIT_CONTROL_AREA =
        new BillingDocumentField<String>("CreditControlArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerRebateAgreement</b>
     * </p>
     *
     * @return Agreement (various conditions grouped together)
     */
    @SerializedName( "CustomerRebateAgreement" )
    @JsonProperty( "CustomerRebateAgreement" )
    @Nullable
    @ODataField( odataName = "CustomerRebateAgreement" )
    private String customerRebateAgreement;
    /**
     * Use with available fluent helpers to apply the <b>CustomerRebateAgreement</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> CUSTOMER_REBATE_AGREEMENT =
        new BillingDocumentField<String>("CustomerRebateAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCondition</b>
     * </p>
     *
     * @return Number of the Document Condition
     */
    @SerializedName( "SalesDocumentCondition" )
    @JsonProperty( "SalesDocumentCondition" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCondition" )
    private String salesDocumentCondition;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCondition</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> SALES_DOCUMENT_CONDITION =
        new BillingDocumentField<String>("SalesDocumentCondition");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> OVERALL_SD_PROCESS_STATUS =
        new BillingDocumentField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingStatus</b>
     * </p>
     *
     * @return SD Billing Status
     */
    @SerializedName( "OverallBillingStatus" )
    @JsonProperty( "OverallBillingStatus" )
    @Nullable
    @ODataField( odataName = "OverallBillingStatus" )
    private String overallBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallBillingStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> OVERALL_BILLING_STATUS =
        new BillingDocumentField<String>("OverallBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingPostingStatus</b>
     * </p>
     *
     * @return Posting Status of Billing Document
     */
    @SerializedName( "AccountingPostingStatus" )
    @JsonProperty( "AccountingPostingStatus" )
    @Nullable
    @ODataField( odataName = "AccountingPostingStatus" )
    private String accountingPostingStatus;
    /**
     * Use with available fluent helpers to apply the <b>AccountingPostingStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> ACCOUNTING_POSTING_STATUS =
        new BillingDocumentField<String>("AccountingPostingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingTransferStatus</b>
     * </p>
     *
     * @return Status for Transfer to Accounting
     */
    @SerializedName( "AccountingTransferStatus" )
    @JsonProperty( "AccountingTransferStatus" )
    @Nullable
    @ODataField( odataName = "AccountingTransferStatus" )
    private String accountingTransferStatus;
    /**
     * Use with available fluent helpers to apply the <b>AccountingTransferStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> ACCOUNTING_TRANSFER_STATUS =
        new BillingDocumentField<String>("AccountingTransferStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingIssueType</b>
     * </p>
     *
     * @return Billing Issue Type
     */
    @SerializedName( "BillingIssueType" )
    @JsonProperty( "BillingIssueType" )
    @Nullable
    @ODataField( odataName = "BillingIssueType" )
    private String billingIssueType;
    /**
     * Use with available fluent helpers to apply the <b>BillingIssueType</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_ISSUE_TYPE =
        new BillingDocumentField<String>("BillingIssueType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceListStatus</b>
     * </p>
     *
     * @return Invoice list status of billing document
     */
    @SerializedName( "InvoiceListStatus" )
    @JsonProperty( "InvoiceListStatus" )
    @Nullable
    @ODataField( odataName = "InvoiceListStatus" )
    private String invoiceListStatus;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceListStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INVOICE_LIST_STATUS =
        new BillingDocumentField<String>("InvoiceListStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGeneralIncompletionSts</b>
     * </p>
     *
     * @return Incompletion Status (All Items)
     */
    @SerializedName( "OvrlItmGeneralIncompletionSts" )
    @JsonProperty( "OvrlItmGeneralIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmGeneralIncompletionSts" )
    private String ovrlItmGeneralIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmGeneralIncompletionSts</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> OVRL_ITM_GENERAL_INCOMPLETION_STS =
        new BillingDocumentField<String>("OvrlItmGeneralIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPricingIncompletionSts</b>
     * </p>
     *
     * @return Pricing Incompletion Status (All Items)
     */
    @SerializedName( "OverallPricingIncompletionSts" )
    @JsonProperty( "OverallPricingIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OverallPricingIncompletionSts" )
    private String overallPricingIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OverallPricingIncompletionSts</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> OVERALL_PRICING_INCOMPLETION_STS =
        new BillingDocumentField<String>("OverallPricingIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceClearingStatus</b>
     * </p>
     *
     * @return Clearing Status of Billing Document
     */
    @SerializedName( "InvoiceClearingStatus" )
    @JsonProperty( "InvoiceClearingStatus" )
    @Nullable
    @ODataField( odataName = "InvoiceClearingStatus" )
    private String invoiceClearingStatus;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceClearingStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> INVOICE_CLEARING_STATUS =
        new BillingDocumentField<String>("InvoiceClearingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentListType</b>
     * </p>
     *
     * @return Invoice List Type
     */
    @SerializedName( "BillingDocumentListType" )
    @JsonProperty( "BillingDocumentListType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentListType" )
    private String billingDocumentListType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentListType</b> field to query operations.
     *
     */
    public final static BillingDocumentField<String> BILLING_DOCUMENT_LIST_TYPE =
        new BillingDocumentField<String>("BillingDocumentListType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentListDate</b>
     * </p>
     *
     * @return Billing date for the invoice list
     */
    @SerializedName( "BillingDocumentListDate" )
    @JsonProperty( "BillingDocumentListDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentListDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentListDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentListDate</b> field to query operations.
     *
     */
    public final static BillingDocumentField<LocalDateTime> BILLING_DOCUMENT_LIST_DATE =
        new BillingDocumentField<LocalDateTime>("BillingDocumentListDate");
    /**
     * Navigation property <b>to_Item</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>BillingDocument</b> to multiple
     * <b>BillingDocumentPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_Text</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentLink<BillingDocumentItem> TO_ITEM =
        new BillingDocumentLink<BillingDocumentItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentLink<BillingDocumentPartner> TO_PARTNER =
        new BillingDocumentLink<BillingDocumentPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentLink<BillingDocumentPrcgElmnt> TO_PRICING_ELEMENT =
        new BillingDocumentLink<BillingDocumentPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentLink<BillingDocumentText> TO_TEXT =
        new BillingDocumentLink<BillingDocumentText>("to_Text");

    @Nonnull
    @Override
    public Class<BillingDocument> getType()
    {
        return BillingDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            SD Document Category
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentCategory</b>
     * </p>
     *
     * @param billingDocumentCategory
     *            Billing Category
     */
    public void setBillingDocumentCategory( @Nullable final String billingDocumentCategory )
    {
        rememberChangedField("BillingDocumentCategory", this.billingDocumentCategory);
        this.billingDocumentCategory = billingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @param billingDocumentDate
     *            Billing Date
     */
    public void setBillingDocumentDate( @Nullable final LocalDateTime billingDocumentDate )
    {
        rememberChangedField("BillingDocumentDate", this.billingDocumentDate);
        this.billingDocumentDate = billingDocumentDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentIsCancelled</b>
     * </p>
     *
     * @param billingDocumentIsCancelled
     *            Billing document is canceled
     */
    public void setBillingDocumentIsCancelled( @Nullable final Boolean billingDocumentIsCancelled )
    {
        rememberChangedField("BillingDocumentIsCancelled", this.billingDocumentIsCancelled);
        this.billingDocumentIsCancelled = billingDocumentIsCancelled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CancelledBillingDocument</b>
     * </p>
     *
     * @param cancelledBillingDocument
     *            Number of canceled billing document
     */
    public void setCancelledBillingDocument( @Nullable final String cancelledBillingDocument )
    {
        rememberChangedField("CancelledBillingDocument", this.cancelledBillingDocument);
        this.cancelledBillingDocument = cancelledBillingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ForeignTrade</b>
     * </p>
     *
     * @param foreignTrade
     *            Number of foreign trade data in MM and SD documents
     */
    public void setForeignTrade( @Nullable final String foreignTrade )
    {
        rememberChangedField("ForeignTrade", this.foreignTrade);
        this.foreignTrade = foreignTrade;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsExportDelivery</b>
     * </p>
     *
     * @param isExportDelivery
     *            Export indicator
     */
    public void setIsExportDelivery( @Nullable final String isExportDelivery )
    {
        rememberChangedField("IsExportDelivery", this.isExportDelivery);
        this.isExportDelivery = isExportDelivery;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocCombinationCriteria</b>
     * </p>
     *
     * @param billingDocCombinationCriteria
     *            Combination criteria in the billing document
     */
    public void setBillingDocCombinationCriteria( @Nullable final String billingDocCombinationCriteria )
    {
        rememberChangedField("BillingDocCombinationCriteria", this.billingDocCombinationCriteria);
        this.billingDocCombinationCriteria = billingDocCombinationCriteria;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ManualInvoiceMaintIsRelevant</b>
     * </p>
     *
     * @param manualInvoiceMaintIsRelevant
     *            Manual Invoice Maintenance
     */
    public void setManualInvoiceMaintIsRelevant( @Nullable final Boolean manualInvoiceMaintIsRelevant )
    {
        rememberChangedField("ManualInvoiceMaintIsRelevant", this.manualInvoiceMaintIsRelevant);
        this.manualInvoiceMaintIsRelevant = manualInvoiceMaintIsRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsIntrastatReportingRelevant</b>
     * </p>
     *
     * @param isIntrastatReportingRelevant
     *            Relevant for Intrastat Reporting
     */
    public void setIsIntrastatReportingRelevant( @Nullable final Boolean isIntrastatReportingRelevant )
    {
        rememberChangedField("IsIntrastatReportingRelevant", this.isIntrastatReportingRelevant);
        this.isIntrastatReportingRelevant = isIntrastatReportingRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsIntrastatReportingExcluded</b>
     * </p>
     *
     * @param isIntrastatReportingExcluded
     *            Exclude from Intrastat Reporting
     */
    public void setIsIntrastatReportingExcluded( @Nullable final Boolean isIntrastatReportingExcluded )
    {
        rememberChangedField("IsIntrastatReportingExcluded", this.isIntrastatReportingExcluded);
        this.isIntrastatReportingExcluded = isIntrastatReportingExcluded;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @param statisticsCurrency
     *            Statistics Currency
     */
    public void setStatisticsCurrency( @Nullable final String statisticsCurrency )
    {
        rememberChangedField("StatisticsCurrency", this.statisticsCurrency);
        this.statisticsCurrency = statisticsCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     *
     * @param totalGrossAmount
     *            The totalGrossAmount to set.
     */
    public void setTotalGrossAmount( @Nullable final BigDecimal totalGrossAmount )
    {
        rememberChangedField("TotalGrossAmount", this.totalGrossAmount);
        this.totalGrossAmount = totalGrossAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @param customerPriceGroup
     *            Customer Price Group
     */
    public void setCustomerPriceGroup( @Nullable final String customerPriceGroup )
    {
        rememberChangedField("CustomerPriceGroup", this.customerPriceGroup);
        this.customerPriceGroup = customerPriceGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @param priceListType
     *            Price List Type
     */
    public void setPriceListType( @Nullable final String priceListType )
    {
        rememberChangedField("PriceListType", this.priceListType);
        this.priceListType = priceListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @param taxDepartureCountry
     *            Tax Departure Country/Region
     */
    public void setTaxDepartureCountry( @Nullable final String taxDepartureCountry )
    {
        rememberChangedField("TaxDepartureCountry", this.taxDepartureCountry);
        this.taxDepartureCountry = taxDepartureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @param vATRegistration
     *            VAT Registration Number
     */
    public void setVATRegistration( @Nullable final String vATRegistration )
    {
        rememberChangedField("VATRegistration", this.vATRegistration);
        this.vATRegistration = vATRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationOrigin</b>
     * </p>
     *
     * @param vATRegistrationOrigin
     *            Origin of Sales Tax Number
     */
    public void setVATRegistrationOrigin( @Nullable final String vATRegistrationOrigin )
    {
        rememberChangedField("VATRegistrationOrigin", this.vATRegistrationOrigin);
        this.vATRegistrationOrigin = vATRegistrationOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @param vATRegistrationCountry
     *            Country/Region of Sales Tax ID Number
     */
    public void setVATRegistrationCountry( @Nullable final String vATRegistrationCountry )
    {
        rememberChangedField("VATRegistrationCountry", this.vATRegistrationCountry);
        this.vATRegistrationCountry = vATRegistrationCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyTypePricing</b>
     * </p>
     *
     * @param hierarchyTypePricing
     *            Hierarchy type for pricing
     */
    public void setHierarchyTypePricing( @Nullable final String hierarchyTypePricing )
    {
        rememberChangedField("HierarchyTypePricing", this.hierarchyTypePricing);
        this.hierarchyTypePricing = hierarchyTypePricing;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @param customerTaxClassification1
     *            Tax Classification 1 for Customer
     */
    public void setCustomerTaxClassification1( @Nullable final String customerTaxClassification1 )
    {
        rememberChangedField("CustomerTaxClassification1", this.customerTaxClassification1);
        this.customerTaxClassification1 = customerTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @param customerTaxClassification2
     *            Tax Classification 2 for Customer
     */
    public void setCustomerTaxClassification2( @Nullable final String customerTaxClassification2 )
    {
        rememberChangedField("CustomerTaxClassification2", this.customerTaxClassification2);
        this.customerTaxClassification2 = customerTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @param customerTaxClassification3
     *            Tax Classification 3 for Customer
     */
    public void setCustomerTaxClassification3( @Nullable final String customerTaxClassification3 )
    {
        rememberChangedField("CustomerTaxClassification3", this.customerTaxClassification3);
        this.customerTaxClassification3 = customerTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @param customerTaxClassification4
     *            Tax Classification 4 for Customer
     */
    public void setCustomerTaxClassification4( @Nullable final String customerTaxClassification4 )
    {
        rememberChangedField("CustomerTaxClassification4", this.customerTaxClassification4);
        this.customerTaxClassification4 = customerTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @param customerTaxClassification5
     *            Tax Classification 5 for Customer
     */
    public void setCustomerTaxClassification5( @Nullable final String customerTaxClassification5 )
    {
        rememberChangedField("CustomerTaxClassification5", this.customerTaxClassification5);
        this.customerTaxClassification5 = customerTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @param customerTaxClassification6
     *            Tax Classification 6 for Customer
     */
    public void setCustomerTaxClassification6( @Nullable final String customerTaxClassification6 )
    {
        rememberChangedField("CustomerTaxClassification6", this.customerTaxClassification6);
        this.customerTaxClassification6 = customerTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @param customerTaxClassification7
     *            Tax Classification 7 for Customer
     */
    public void setCustomerTaxClassification7( @Nullable final String customerTaxClassification7 )
    {
        rememberChangedField("CustomerTaxClassification7", this.customerTaxClassification7);
        this.customerTaxClassification7 = customerTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @param customerTaxClassification8
     *            Tax Classification 8 for Customer
     */
    public void setCustomerTaxClassification8( @Nullable final String customerTaxClassification8 )
    {
        rememberChangedField("CustomerTaxClassification8", this.customerTaxClassification8);
        this.customerTaxClassification8 = customerTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @param customerTaxClassification9
     *            Tax Classification 9 for Customer
     */
    public void setCustomerTaxClassification9( @Nullable final String customerTaxClassification9 )
    {
        rememberChangedField("CustomerTaxClassification9", this.customerTaxClassification9);
        this.customerTaxClassification9 = customerTaxClassification9;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @param isEUTriangularDeal
     *            Indicator: Triangular Deal Within the EU
     */
    public void setIsEUTriangularDeal( @Nullable final Boolean isEUTriangularDeal )
    {
        rememberChangedField("IsEUTriangularDeal", this.isEUTriangularDeal);
        this.isEUTriangularDeal = isEUTriangularDeal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDPricingProcedure</b>
     * </p>
     *
     * @param sDPricingProcedure
     *            Pricing Procedure in Pricing
     */
    public void setSDPricingProcedure( @Nullable final String sDPricingProcedure )
    {
        rememberChangedField("SDPricingProcedure", this.sDPricingProcedure);
        this.sDPricingProcedure = sDPricingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Document Number of an Accounting Document
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @param customerAccountAssignmentGroup
     *            Account Assignment Group for Customer
     */
    public void setCustomerAccountAssignmentGroup( @Nullable final String customerAccountAssignmentGroup )
    {
        rememberChangedField("CustomerAccountAssignmentGroup", this.customerAccountAssignmentGroup);
        this.customerAccountAssignmentGroup = customerAccountAssignmentGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRateIsSet</b>
     * </p>
     *
     * @param accountingExchangeRateIsSet
     *            Exchange Rate Setting
     */
    public void setAccountingExchangeRateIsSet( @Nullable final Boolean accountingExchangeRateIsSet )
    {
        rememberChangedField("AccountingExchangeRateIsSet", this.accountingExchangeRateIsSet);
        this.accountingExchangeRateIsSet = accountingExchangeRateIsSet;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltAccountingExchangeRate</b>
     * </p>
     *
     * @param absltAccountingExchangeRate
     *            Absolute exchange rate for FI postings
     */
    public void setAbsltAccountingExchangeRate( @Nullable final BigDecimal absltAccountingExchangeRate )
    {
        rememberChangedField("AbsltAccountingExchangeRate", this.absltAccountingExchangeRate);
        this.absltAccountingExchangeRate = absltAccountingExchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AcctgExchangeRateIsIndrctQtan</b>
     * </p>
     *
     * @param acctgExchangeRateIsIndrctQtan
     *            Accounting exchange rate quotation is indirect
     */
    public void setAcctgExchangeRateIsIndrctQtan( @Nullable final Boolean acctgExchangeRateIsIndrctQtan )
    {
        rememberChangedField("AcctgExchangeRateIsIndrctQtan", this.acctgExchangeRateIsIndrctQtan);
        this.acctgExchangeRateIsIndrctQtan = acctgExchangeRateIsIndrctQtan;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @param exchangeRateDate
     *            Translation Date
     */
    public void setExchangeRateDate( @Nullable final LocalDateTime exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     *
     * @param exchangeRateType
     *            Exchange Rate Type
     */
    public void setExchangeRateType( @Nullable final String exchangeRateType )
    {
        rememberChangedField("ExchangeRateType", this.exchangeRateType);
        this.exchangeRateType = exchangeRateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Reference Document Number
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     *
     * @param dunningArea
     *            Dunning Area
     */
    public void setDunningArea( @Nullable final String dunningArea )
    {
        rememberChangedField("DunningArea", this.dunningArea);
        this.dunningArea = dunningArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     *
     * @param dunningBlockingReason
     *            Dunning Block
     */
    public void setDunningBlockingReason( @Nullable final String dunningBlockingReason )
    {
        rememberChangedField("DunningBlockingReason", this.dunningBlockingReason);
        this.dunningBlockingReason = dunningBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     *
     * @param dunningKey
     *            Dunning Key
     */
    public void setDunningKey( @Nullable final String dunningKey )
    {
        rememberChangedField("DunningKey", this.dunningKey);
        this.dunningKey = dunningKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalFinancialDocument</b>
     * </p>
     *
     * @param internalFinancialDocument
     *            Financial doc. processing: Internal financial doc. number
     */
    public void setInternalFinancialDocument( @Nullable final String internalFinancialDocument )
    {
        rememberChangedField("InternalFinancialDocument", this.internalFinancialDocument);
        this.internalFinancialDocument = internalFinancialDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @param isRelevantForAccrual
     *            Is relevant for accrual
     */
    public void setIsRelevantForAccrual( @Nullable final Boolean isRelevantForAccrual )
    {
        rememberChangedField("IsRelevantForAccrual", this.isRelevantForAccrual);
        this.isRelevantForAccrual = isRelevantForAccrual;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Destination Country/Region
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @param cityCode
     *            City Code
     */
    public void setCityCode( @Nullable final String cityCode )
    {
        rememberChangedField("CityCode", this.cityCode);
        this.cityCode = cityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @param county
     *            County Code
     */
    public void setCounty( @Nullable final String county )
    {
        rememberChangedField("County", this.county);
        this.county = county;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @param creditControlArea
     *            Credit Control Area
     */
    public void setCreditControlArea( @Nullable final String creditControlArea )
    {
        rememberChangedField("CreditControlArea", this.creditControlArea);
        this.creditControlArea = creditControlArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerRebateAgreement</b>
     * </p>
     *
     * @param customerRebateAgreement
     *            Agreement (various conditions grouped together)
     */
    public void setCustomerRebateAgreement( @Nullable final String customerRebateAgreement )
    {
        rememberChangedField("CustomerRebateAgreement", this.customerRebateAgreement);
        this.customerRebateAgreement = customerRebateAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCondition</b>
     * </p>
     *
     * @param salesDocumentCondition
     *            Number of the Document Condition
     */
    public void setSalesDocumentCondition( @Nullable final String salesDocumentCondition )
    {
        rememberChangedField("SalesDocumentCondition", this.salesDocumentCondition);
        this.salesDocumentCondition = salesDocumentCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingStatus</b>
     * </p>
     *
     * @param overallBillingStatus
     *            SD Billing Status
     */
    public void setOverallBillingStatus( @Nullable final String overallBillingStatus )
    {
        rememberChangedField("OverallBillingStatus", this.overallBillingStatus);
        this.overallBillingStatus = overallBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingPostingStatus</b>
     * </p>
     *
     * @param accountingPostingStatus
     *            Posting Status of Billing Document
     */
    public void setAccountingPostingStatus( @Nullable final String accountingPostingStatus )
    {
        rememberChangedField("AccountingPostingStatus", this.accountingPostingStatus);
        this.accountingPostingStatus = accountingPostingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingTransferStatus</b>
     * </p>
     *
     * @param accountingTransferStatus
     *            Status for Transfer to Accounting
     */
    public void setAccountingTransferStatus( @Nullable final String accountingTransferStatus )
    {
        rememberChangedField("AccountingTransferStatus", this.accountingTransferStatus);
        this.accountingTransferStatus = accountingTransferStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingIssueType</b>
     * </p>
     *
     * @param billingIssueType
     *            Billing Issue Type
     */
    public void setBillingIssueType( @Nullable final String billingIssueType )
    {
        rememberChangedField("BillingIssueType", this.billingIssueType);
        this.billingIssueType = billingIssueType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceListStatus</b>
     * </p>
     *
     * @param invoiceListStatus
     *            Invoice list status of billing document
     */
    public void setInvoiceListStatus( @Nullable final String invoiceListStatus )
    {
        rememberChangedField("InvoiceListStatus", this.invoiceListStatus);
        this.invoiceListStatus = invoiceListStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGeneralIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmGeneralIncompletionSts
     *            Incompletion Status (All Items)
     */
    public void setOvrlItmGeneralIncompletionSts( @Nullable final String ovrlItmGeneralIncompletionSts )
    {
        rememberChangedField("OvrlItmGeneralIncompletionSts", this.ovrlItmGeneralIncompletionSts);
        this.ovrlItmGeneralIncompletionSts = ovrlItmGeneralIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPricingIncompletionSts</b>
     * </p>
     *
     * @param overallPricingIncompletionSts
     *            Pricing Incompletion Status (All Items)
     */
    public void setOverallPricingIncompletionSts( @Nullable final String overallPricingIncompletionSts )
    {
        rememberChangedField("OverallPricingIncompletionSts", this.overallPricingIncompletionSts);
        this.overallPricingIncompletionSts = overallPricingIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceClearingStatus</b>
     * </p>
     *
     * @param invoiceClearingStatus
     *            Clearing Status of Billing Document
     */
    public void setInvoiceClearingStatus( @Nullable final String invoiceClearingStatus )
    {
        rememberChangedField("InvoiceClearingStatus", this.invoiceClearingStatus);
        this.invoiceClearingStatus = invoiceClearingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentListType</b>
     * </p>
     *
     * @param billingDocumentListType
     *            Invoice List Type
     */
    public void setBillingDocumentListType( @Nullable final String billingDocumentListType )
    {
        rememberChangedField("BillingDocumentListType", this.billingDocumentListType);
        this.billingDocumentListType = billingDocumentListType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentListDate</b>
     * </p>
     *
     * @param billingDocumentListDate
     *            Billing date for the invoice list
     */
    public void setBillingDocumentListDate( @Nullable final LocalDateTime billingDocumentListDate )
    {
        rememberChangedField("BillingDocumentListDate", this.billingDocumentListDate);
        this.billingDocumentListDate = billingDocumentListDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocument", getBillingDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocument", getBillingDocument());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("BillingDocumentCategory", getBillingDocumentCategory());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("BillingDocumentDate", getBillingDocumentDate());
        values.put("BillingDocumentIsCancelled", getBillingDocumentIsCancelled());
        values.put("CancelledBillingDocument", getCancelledBillingDocument());
        values.put("ForeignTrade", getForeignTrade());
        values.put("IsExportDelivery", getIsExportDelivery());
        values.put("BillingDocCombinationCriteria", getBillingDocCombinationCriteria());
        values.put("ManualInvoiceMaintIsRelevant", getManualInvoiceMaintIsRelevant());
        values.put("IsIntrastatReportingRelevant", getIsIntrastatReportingRelevant());
        values.put("IsIntrastatReportingExcluded", getIsIntrastatReportingExcluded());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("StatisticsCurrency", getStatisticsCurrency());
        values.put("TaxAmount", getTaxAmount());
        values.put("TotalGrossAmount", getTotalGrossAmount());
        values.put("CustomerPriceGroup", getCustomerPriceGroup());
        values.put("PriceListType", getPriceListType());
        values.put("TaxDepartureCountry", getTaxDepartureCountry());
        values.put("VATRegistration", getVATRegistration());
        values.put("VATRegistrationOrigin", getVATRegistrationOrigin());
        values.put("VATRegistrationCountry", getVATRegistrationCountry());
        values.put("HierarchyTypePricing", getHierarchyTypePricing());
        values.put("CustomerTaxClassification1", getCustomerTaxClassification1());
        values.put("CustomerTaxClassification2", getCustomerTaxClassification2());
        values.put("CustomerTaxClassification3", getCustomerTaxClassification3());
        values.put("CustomerTaxClassification4", getCustomerTaxClassification4());
        values.put("CustomerTaxClassification5", getCustomerTaxClassification5());
        values.put("CustomerTaxClassification6", getCustomerTaxClassification6());
        values.put("CustomerTaxClassification7", getCustomerTaxClassification7());
        values.put("CustomerTaxClassification8", getCustomerTaxClassification8());
        values.put("CustomerTaxClassification9", getCustomerTaxClassification9());
        values.put("IsEUTriangularDeal", getIsEUTriangularDeal());
        values.put("SDPricingProcedure", getSDPricingProcedure());
        values.put("ShippingCondition", getShippingCondition());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PayerParty", getPayerParty());
        values.put("ContractAccount", getContractAccount());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("PaymentReference", getPaymentReference());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("CustomerAccountAssignmentGroup", getCustomerAccountAssignmentGroup());
        values.put("AccountingExchangeRateIsSet", getAccountingExchangeRateIsSet());
        values.put("AbsltAccountingExchangeRate", getAbsltAccountingExchangeRate());
        values.put("AcctgExchangeRateIsIndrctQtan", getAcctgExchangeRateIsIndrctQtan());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("ExchangeRateType", getExchangeRateType());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("DunningArea", getDunningArea());
        values.put("DunningBlockingReason", getDunningBlockingReason());
        values.put("DunningKey", getDunningKey());
        values.put("InternalFinancialDocument", getInternalFinancialDocument());
        values.put("IsRelevantForAccrual", getIsRelevantForAccrual());
        values.put("SoldToParty", getSoldToParty());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("Country", getCountry());
        values.put("CityCode", getCityCode());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("Region", getRegion());
        values.put("County", getCounty());
        values.put("CreditControlArea", getCreditControlArea());
        values.put("CustomerRebateAgreement", getCustomerRebateAgreement());
        values.put("SalesDocumentCondition", getSalesDocumentCondition());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("OverallBillingStatus", getOverallBillingStatus());
        values.put("AccountingPostingStatus", getAccountingPostingStatus());
        values.put("AccountingTransferStatus", getAccountingTransferStatus());
        values.put("BillingIssueType", getBillingIssueType());
        values.put("InvoiceListStatus", getInvoiceListStatus());
        values.put("OvrlItmGeneralIncompletionSts", getOvrlItmGeneralIncompletionSts());
        values.put("OverallPricingIncompletionSts", getOverallPricingIncompletionSts());
        values.put("InvoiceClearingStatus", getInvoiceClearingStatus());
        values.put("BillingDocumentListType", getBillingDocumentListType());
        values.put("BillingDocumentListDate", getBillingDocumentListDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentCategory") ) {
                final Object value = values.remove("BillingDocumentCategory");
                if( (value == null) || (!value.equals(getBillingDocumentCategory())) ) {
                    setBillingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentDate") ) {
                final Object value = values.remove("BillingDocumentDate");
                if( (value == null) || (!value.equals(getBillingDocumentDate())) ) {
                    setBillingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingDocumentIsCancelled") ) {
                final Object value = values.remove("BillingDocumentIsCancelled");
                if( (value == null) || (!value.equals(getBillingDocumentIsCancelled())) ) {
                    setBillingDocumentIsCancelled(((Boolean) value));
                }
            }
            if( values.containsKey("CancelledBillingDocument") ) {
                final Object value = values.remove("CancelledBillingDocument");
                if( (value == null) || (!value.equals(getCancelledBillingDocument())) ) {
                    setCancelledBillingDocument(((String) value));
                }
            }
            if( values.containsKey("ForeignTrade") ) {
                final Object value = values.remove("ForeignTrade");
                if( (value == null) || (!value.equals(getForeignTrade())) ) {
                    setForeignTrade(((String) value));
                }
            }
            if( values.containsKey("IsExportDelivery") ) {
                final Object value = values.remove("IsExportDelivery");
                if( (value == null) || (!value.equals(getIsExportDelivery())) ) {
                    setIsExportDelivery(((String) value));
                }
            }
            if( values.containsKey("BillingDocCombinationCriteria") ) {
                final Object value = values.remove("BillingDocCombinationCriteria");
                if( (value == null) || (!value.equals(getBillingDocCombinationCriteria())) ) {
                    setBillingDocCombinationCriteria(((String) value));
                }
            }
            if( values.containsKey("ManualInvoiceMaintIsRelevant") ) {
                final Object value = values.remove("ManualInvoiceMaintIsRelevant");
                if( (value == null) || (!value.equals(getManualInvoiceMaintIsRelevant())) ) {
                    setManualInvoiceMaintIsRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsIntrastatReportingRelevant") ) {
                final Object value = values.remove("IsIntrastatReportingRelevant");
                if( (value == null) || (!value.equals(getIsIntrastatReportingRelevant())) ) {
                    setIsIntrastatReportingRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsIntrastatReportingExcluded") ) {
                final Object value = values.remove("IsIntrastatReportingExcluded");
                if( (value == null) || (!value.equals(getIsIntrastatReportingExcluded())) ) {
                    setIsIntrastatReportingExcluded(((Boolean) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("StatisticsCurrency") ) {
                final Object value = values.remove("StatisticsCurrency");
                if( (value == null) || (!value.equals(getStatisticsCurrency())) ) {
                    setStatisticsCurrency(((String) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalGrossAmount") ) {
                final Object value = values.remove("TotalGrossAmount");
                if( (value == null) || (!value.equals(getTotalGrossAmount())) ) {
                    setTotalGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerPriceGroup") ) {
                final Object value = values.remove("CustomerPriceGroup");
                if( (value == null) || (!value.equals(getCustomerPriceGroup())) ) {
                    setCustomerPriceGroup(((String) value));
                }
            }
            if( values.containsKey("PriceListType") ) {
                final Object value = values.remove("PriceListType");
                if( (value == null) || (!value.equals(getPriceListType())) ) {
                    setPriceListType(((String) value));
                }
            }
            if( values.containsKey("TaxDepartureCountry") ) {
                final Object value = values.remove("TaxDepartureCountry");
                if( (value == null) || (!value.equals(getTaxDepartureCountry())) ) {
                    setTaxDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("VATRegistration") ) {
                final Object value = values.remove("VATRegistration");
                if( (value == null) || (!value.equals(getVATRegistration())) ) {
                    setVATRegistration(((String) value));
                }
            }
            if( values.containsKey("VATRegistrationOrigin") ) {
                final Object value = values.remove("VATRegistrationOrigin");
                if( (value == null) || (!value.equals(getVATRegistrationOrigin())) ) {
                    setVATRegistrationOrigin(((String) value));
                }
            }
            if( values.containsKey("VATRegistrationCountry") ) {
                final Object value = values.remove("VATRegistrationCountry");
                if( (value == null) || (!value.equals(getVATRegistrationCountry())) ) {
                    setVATRegistrationCountry(((String) value));
                }
            }
            if( values.containsKey("HierarchyTypePricing") ) {
                final Object value = values.remove("HierarchyTypePricing");
                if( (value == null) || (!value.equals(getHierarchyTypePricing())) ) {
                    setHierarchyTypePricing(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification1") ) {
                final Object value = values.remove("CustomerTaxClassification1");
                if( (value == null) || (!value.equals(getCustomerTaxClassification1())) ) {
                    setCustomerTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification2") ) {
                final Object value = values.remove("CustomerTaxClassification2");
                if( (value == null) || (!value.equals(getCustomerTaxClassification2())) ) {
                    setCustomerTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification3") ) {
                final Object value = values.remove("CustomerTaxClassification3");
                if( (value == null) || (!value.equals(getCustomerTaxClassification3())) ) {
                    setCustomerTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification4") ) {
                final Object value = values.remove("CustomerTaxClassification4");
                if( (value == null) || (!value.equals(getCustomerTaxClassification4())) ) {
                    setCustomerTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification5") ) {
                final Object value = values.remove("CustomerTaxClassification5");
                if( (value == null) || (!value.equals(getCustomerTaxClassification5())) ) {
                    setCustomerTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification6") ) {
                final Object value = values.remove("CustomerTaxClassification6");
                if( (value == null) || (!value.equals(getCustomerTaxClassification6())) ) {
                    setCustomerTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification7") ) {
                final Object value = values.remove("CustomerTaxClassification7");
                if( (value == null) || (!value.equals(getCustomerTaxClassification7())) ) {
                    setCustomerTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification8") ) {
                final Object value = values.remove("CustomerTaxClassification8");
                if( (value == null) || (!value.equals(getCustomerTaxClassification8())) ) {
                    setCustomerTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification9") ) {
                final Object value = values.remove("CustomerTaxClassification9");
                if( (value == null) || (!value.equals(getCustomerTaxClassification9())) ) {
                    setCustomerTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("IsEUTriangularDeal") ) {
                final Object value = values.remove("IsEUTriangularDeal");
                if( (value == null) || (!value.equals(getIsEUTriangularDeal())) ) {
                    setIsEUTriangularDeal(((Boolean) value));
                }
            }
            if( values.containsKey("SDPricingProcedure") ) {
                final Object value = values.remove("SDPricingProcedure");
                if( (value == null) || (!value.equals(getSDPricingProcedure())) ) {
                    setSDPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("CustomerAccountAssignmentGroup") ) {
                final Object value = values.remove("CustomerAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getCustomerAccountAssignmentGroup())) ) {
                    setCustomerAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("AccountingExchangeRateIsSet") ) {
                final Object value = values.remove("AccountingExchangeRateIsSet");
                if( (value == null) || (!value.equals(getAccountingExchangeRateIsSet())) ) {
                    setAccountingExchangeRateIsSet(((Boolean) value));
                }
            }
            if( values.containsKey("AbsltAccountingExchangeRate") ) {
                final Object value = values.remove("AbsltAccountingExchangeRate");
                if( (value == null) || (!value.equals(getAbsltAccountingExchangeRate())) ) {
                    setAbsltAccountingExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("AcctgExchangeRateIsIndrctQtan") ) {
                final Object value = values.remove("AcctgExchangeRateIsIndrctQtan");
                if( (value == null) || (!value.equals(getAcctgExchangeRateIsIndrctQtan())) ) {
                    setAcctgExchangeRateIsIndrctQtan(((Boolean) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExchangeRateType") ) {
                final Object value = values.remove("ExchangeRateType");
                if( (value == null) || (!value.equals(getExchangeRateType())) ) {
                    setExchangeRateType(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("DunningArea") ) {
                final Object value = values.remove("DunningArea");
                if( (value == null) || (!value.equals(getDunningArea())) ) {
                    setDunningArea(((String) value));
                }
            }
            if( values.containsKey("DunningBlockingReason") ) {
                final Object value = values.remove("DunningBlockingReason");
                if( (value == null) || (!value.equals(getDunningBlockingReason())) ) {
                    setDunningBlockingReason(((String) value));
                }
            }
            if( values.containsKey("DunningKey") ) {
                final Object value = values.remove("DunningKey");
                if( (value == null) || (!value.equals(getDunningKey())) ) {
                    setDunningKey(((String) value));
                }
            }
            if( values.containsKey("InternalFinancialDocument") ) {
                final Object value = values.remove("InternalFinancialDocument");
                if( (value == null) || (!value.equals(getInternalFinancialDocument())) ) {
                    setInternalFinancialDocument(((String) value));
                }
            }
            if( values.containsKey("IsRelevantForAccrual") ) {
                final Object value = values.remove("IsRelevantForAccrual");
                if( (value == null) || (!value.equals(getIsRelevantForAccrual())) ) {
                    setIsRelevantForAccrual(((Boolean) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("CityCode") ) {
                final Object value = values.remove("CityCode");
                if( (value == null) || (!value.equals(getCityCode())) ) {
                    setCityCode(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("County") ) {
                final Object value = values.remove("County");
                if( (value == null) || (!value.equals(getCounty())) ) {
                    setCounty(((String) value));
                }
            }
            if( values.containsKey("CreditControlArea") ) {
                final Object value = values.remove("CreditControlArea");
                if( (value == null) || (!value.equals(getCreditControlArea())) ) {
                    setCreditControlArea(((String) value));
                }
            }
            if( values.containsKey("CustomerRebateAgreement") ) {
                final Object value = values.remove("CustomerRebateAgreement");
                if( (value == null) || (!value.equals(getCustomerRebateAgreement())) ) {
                    setCustomerRebateAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentCondition") ) {
                final Object value = values.remove("SalesDocumentCondition");
                if( (value == null) || (!value.equals(getSalesDocumentCondition())) ) {
                    setSalesDocumentCondition(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("OverallBillingStatus") ) {
                final Object value = values.remove("OverallBillingStatus");
                if( (value == null) || (!value.equals(getOverallBillingStatus())) ) {
                    setOverallBillingStatus(((String) value));
                }
            }
            if( values.containsKey("AccountingPostingStatus") ) {
                final Object value = values.remove("AccountingPostingStatus");
                if( (value == null) || (!value.equals(getAccountingPostingStatus())) ) {
                    setAccountingPostingStatus(((String) value));
                }
            }
            if( values.containsKey("AccountingTransferStatus") ) {
                final Object value = values.remove("AccountingTransferStatus");
                if( (value == null) || (!value.equals(getAccountingTransferStatus())) ) {
                    setAccountingTransferStatus(((String) value));
                }
            }
            if( values.containsKey("BillingIssueType") ) {
                final Object value = values.remove("BillingIssueType");
                if( (value == null) || (!value.equals(getBillingIssueType())) ) {
                    setBillingIssueType(((String) value));
                }
            }
            if( values.containsKey("InvoiceListStatus") ) {
                final Object value = values.remove("InvoiceListStatus");
                if( (value == null) || (!value.equals(getInvoiceListStatus())) ) {
                    setInvoiceListStatus(((String) value));
                }
            }
            if( values.containsKey("OvrlItmGeneralIncompletionSts") ) {
                final Object value = values.remove("OvrlItmGeneralIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmGeneralIncompletionSts())) ) {
                    setOvrlItmGeneralIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("OverallPricingIncompletionSts") ) {
                final Object value = values.remove("OverallPricingIncompletionSts");
                if( (value == null) || (!value.equals(getOverallPricingIncompletionSts())) ) {
                    setOverallPricingIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("InvoiceClearingStatus") ) {
                final Object value = values.remove("InvoiceClearingStatus");
                if( (value == null) || (!value.equals(getInvoiceClearingStatus())) ) {
                    setInvoiceClearingStatus(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentListType") ) {
                final Object value = values.remove("BillingDocumentListType");
                if( (value == null) || (!value.equals(getBillingDocumentListType())) ) {
                    setBillingDocumentListType(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentListDate") ) {
                final Object value = values.remove("BillingDocumentListDate");
                if( (value == null) || (!value.equals(getBillingDocumentListDate())) ) {
                    setBillingDocumentListDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new BillingDocumentItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new BillingDocumentPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new BillingDocumentPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BillingDocumentText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", BillingDocumentItem.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>BillingDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>BillingDocumentItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentItem</b> entities.
     */
    public void setItem( @Nonnull final List<BillingDocumentItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentItem</b> entities.
     */
    public void addItem( BillingDocumentItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocumentPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", BillingDocumentPartner.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>BillingDocumentPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>BillingDocumentPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<BillingDocumentPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentPartner</b> entities.
     */
    public void addPartner( BillingDocumentPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocumentPrcgElmnt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", BillingDocumentPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>BillingDocumentPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>BillingDocumentPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<BillingDocumentPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentPrcgElmnt</b> entities.
     */
    public void addPricingElement( BillingDocumentPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocumentText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentText> fetchText()
    {
        return fetchFieldAsList("to_Text", BillingDocumentText.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BillingDocumentText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BillingDocumentText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentText</b> entities.
     */
    public void setText( @Nonnull final List<BillingDocumentText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BillingDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentText</b> entities.
     */
    public void addText( BillingDocumentText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillingDocument instances.
     *
     */
    public final static class BillingDocumentBuilder
    {

        private List<BillingDocumentItem> toItem = Lists.newArrayList();
        private List<BillingDocumentPartner> toPartner = Lists.newArrayList();
        private List<BillingDocumentPrcgElmnt> toPricingElement = Lists.newArrayList();
        private List<BillingDocumentText> toText = Lists.newArrayList();

        private BillingDocument.BillingDocumentBuilder toItem( final List<BillingDocumentItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentItem</b>.
         *
         * @param value
         *            The BillingDocumentItems to build this BillingDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocument.BillingDocumentBuilder item( BillingDocumentItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private BillingDocument.BillingDocumentBuilder toPartner( final List<BillingDocumentPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentPartner</b>.
         *
         * @param value
         *            The BillingDocumentPartners to build this BillingDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocument.BillingDocumentBuilder partner( BillingDocumentPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private BillingDocument.BillingDocumentBuilder toPricingElement( final List<BillingDocumentPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>BillingDocument</b> to multiple
         * <b>BillingDocumentPrcgElmnt</b>.
         *
         * @param value
         *            The BillingDocumentPrcgElmnts to build this BillingDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocument.BillingDocumentBuilder pricingElement( BillingDocumentPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private BillingDocument.BillingDocumentBuilder toText( final List<BillingDocumentText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BillingDocument</b> to multiple <b>BillingDocumentText</b>.
         *
         * @param value
         *            The BillingDocumentTexts to build this BillingDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocument.BillingDocumentBuilder text( BillingDocumentText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
