/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable.BillingDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Billing Document Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocumentItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentItem extends VdmEntity<BillingDocumentItem>
{

    /**
     * Selector for all available fields of BillingDocumentItem.
     *
     */
    public final static BillingDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @Key
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_DOCUMENT =
        new BillingDocumentItemField<String>("BillingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItem</b>
     * </p>
     *
     * @return Billing Item
     */
    @Key
    @SerializedName( "BillingDocumentItem" )
    @JsonProperty( "BillingDocumentItem" )
    @Nullable
    @ODataField( odataName = "BillingDocumentItem" )
    private String billingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_DOCUMENT_ITEM =
        new BillingDocumentItemField<String>("BillingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesDocumentItemCategory" )
    @JsonProperty( "SalesDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItemCategory" )
    private String salesDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItemCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_DOCUMENT_ITEM_CATEGORY =
        new BillingDocumentItemField<String>("SalesDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemType</b>
     * </p>
     *
     * @return Item Type
     */
    @SerializedName( "SalesDocumentItemType" )
    @JsonProperty( "SalesDocumentItemType" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItemType" )
    private String salesDocumentItemType;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItemType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_DOCUMENT_ITEM_TYPE =
        new BillingDocumentItemField<String>("SalesDocumentItemType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnItemProcessingType</b>
     * </p>
     *
     * @return Returns item
     */
    @SerializedName( "ReturnItemProcessingType" )
    @JsonProperty( "ReturnItemProcessingType" )
    @Nullable
    @ODataField( odataName = "ReturnItemProcessingType" )
    private String returnItemProcessingType;
    /**
     * Use with available fluent helpers to apply the <b>ReturnItemProcessingType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> RETURN_ITEM_PROCESSING_TYPE =
        new BillingDocumentItemField<String>("ReturnItemProcessingType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CREATED_BY_USER =
        new BillingDocumentItemField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<LocalDateTime> CREATION_DATE =
        new BillingDocumentItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<LocalTime> CREATION_TIME =
        new BillingDocumentItemField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceLogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "ReferenceLogicalSystem" )
    @JsonProperty( "ReferenceLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceLogicalSystem" )
    private String referenceLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceLogicalSystem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> REFERENCE_LOGICAL_SYSTEM =
        new BillingDocumentItemField<String>("ReferenceLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division in Sales Order Header
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ORGANIZATION_DIVISION =
        new BillingDocumentItemField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> DIVISION = new BillingDocumentItemField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_OFFICE =
        new BillingDocumentItemField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL = new BillingDocumentItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @return Material Entered
     */
    @SerializedName( "OriginallyRequestedMaterial" )
    @JsonProperty( "OriginallyRequestedMaterial" )
    @Nullable
    @ODataField( odataName = "OriginallyRequestedMaterial" )
    private String originallyRequestedMaterial;
    /**
     * Use with available fluent helpers to apply the <b>OriginallyRequestedMaterial</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ORIGINALLY_REQUESTED_MATERIAL =
        new BillingDocumentItemField<String>("OriginallyRequestedMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @return International Article Number (EAN/UPC)
     */
    @SerializedName( "InternationalArticleNumber" )
    @JsonProperty( "InternationalArticleNumber" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumber" )
    private String internationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumber</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> INTERNATIONAL_ARTICLE_NUMBER =
        new BillingDocumentItemField<String>("InternationalArticleNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @return Pricing Reference Material
     */
    @SerializedName( "PricingReferenceMaterial" )
    @JsonProperty( "PricingReferenceMaterial" )
    @Nullable
    @ODataField( odataName = "PricingReferenceMaterial" )
    private String pricingReferenceMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PricingReferenceMaterial</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRICING_REFERENCE_MATERIAL =
        new BillingDocumentItemField<String>("PricingReferenceMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BATCH = new BillingDocumentItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @return Product Hierarchy
     */
    @SerializedName( "ProductHierarchyNode" )
    @JsonProperty( "ProductHierarchyNode" )
    @Nullable
    @ODataField( odataName = "ProductHierarchyNode" )
    private String productHierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchyNode</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_HIERARCHY_NODE =
        new BillingDocumentItemField<String>("ProductHierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_GROUP =
        new BillingDocumentItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @return Material Group 1
     */
    @SerializedName( "AdditionalMaterialGroup1" )
    @JsonProperty( "AdditionalMaterialGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup1" )
    private String additionalMaterialGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup1</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_MATERIAL_GROUP1 =
        new BillingDocumentItemField<String>("AdditionalMaterialGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @return Material Group 2
     */
    @SerializedName( "AdditionalMaterialGroup2" )
    @JsonProperty( "AdditionalMaterialGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup2" )
    private String additionalMaterialGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup2</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_MATERIAL_GROUP2 =
        new BillingDocumentItemField<String>("AdditionalMaterialGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @return Material Group 3
     */
    @SerializedName( "AdditionalMaterialGroup3" )
    @JsonProperty( "AdditionalMaterialGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup3" )
    private String additionalMaterialGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup3</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_MATERIAL_GROUP3 =
        new BillingDocumentItemField<String>("AdditionalMaterialGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @return Material Group 4
     */
    @SerializedName( "AdditionalMaterialGroup4" )
    @JsonProperty( "AdditionalMaterialGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup4" )
    private String additionalMaterialGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup4</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_MATERIAL_GROUP4 =
        new BillingDocumentItemField<String>("AdditionalMaterialGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @return Material Group 5
     */
    @SerializedName( "AdditionalMaterialGroup5" )
    @JsonProperty( "AdditionalMaterialGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup5" )
    private String additionalMaterialGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup5</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_MATERIAL_GROUP5 =
        new BillingDocumentItemField<String>("AdditionalMaterialGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCommissionGroup</b>
     * </p>
     *
     * @return Commission Group
     */
    @SerializedName( "MaterialCommissionGroup" )
    @JsonProperty( "MaterialCommissionGroup" )
    @Nullable
    @ODataField( odataName = "MaterialCommissionGroup" )
    private String materialCommissionGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCommissionGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_COMMISSION_GROUP =
        new BillingDocumentItemField<String>("MaterialCommissionGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PLANT = new BillingDocumentItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> STORAGE_LOCATION =
        new BillingDocumentItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementPartType</b>
     * </p>
     *
     * @return Replacement part
     */
    @SerializedName( "ReplacementPartType" )
    @JsonProperty( "ReplacementPartType" )
    @Nullable
    @ODataField( odataName = "ReplacementPartType" )
    private String replacementPartType;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementPartType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> REPLACEMENT_PART_TYPE =
        new BillingDocumentItemField<String>("ReplacementPartType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupHierarchy1</b>
     * </p>
     *
     * @return Material group hierarchy 1
     */
    @SerializedName( "MaterialGroupHierarchy1" )
    @JsonProperty( "MaterialGroupHierarchy1" )
    @Nullable
    @ODataField( odataName = "MaterialGroupHierarchy1" )
    private String materialGroupHierarchy1;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupHierarchy1</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_GROUP_HIERARCHY1 =
        new BillingDocumentItemField<String>("MaterialGroupHierarchy1");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupHierarchy2</b>
     * </p>
     *
     * @return Material group hierarchy 2
     */
    @SerializedName( "MaterialGroupHierarchy2" )
    @JsonProperty( "MaterialGroupHierarchy2" )
    @Nullable
    @ODataField( odataName = "MaterialGroupHierarchy2" )
    private String materialGroupHierarchy2;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupHierarchy2</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_GROUP_HIERARCHY2 =
        new BillingDocumentItemField<String>("MaterialGroupHierarchy2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @return Region in which plant is located
     */
    @SerializedName( "PlantRegion" )
    @JsonProperty( "PlantRegion" )
    @Nullable
    @ODataField( odataName = "PlantRegion" )
    private String plantRegion;
    /**
     * Use with available fluent helpers to apply the <b>PlantRegion</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PLANT_REGION =
        new BillingDocumentItemField<String>("PlantRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantCounty</b>
     * </p>
     *
     * @return County in which plant is located
     */
    @SerializedName( "PlantCounty" )
    @JsonProperty( "PlantCounty" )
    @Nullable
    @ODataField( odataName = "PlantCounty" )
    private String plantCounty;
    /**
     * Use with available fluent helpers to apply the <b>PlantCounty</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PLANT_COUNTY =
        new BillingDocumentItemField<String>("PlantCounty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlantCity</b>
     * </p>
     *
     * @return City in which plant is located
     */
    @SerializedName( "PlantCity" )
    @JsonProperty( "PlantCity" )
    @Nullable
    @ODataField( odataName = "PlantCity" )
    private String plantCity;
    /**
     * Use with available fluent helpers to apply the <b>PlantCity</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PLANT_CITY = new BillingDocumentItemField<String>("PlantCity");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosion</b>
     * </p>
     *
     * @return BOM Explosion Number
     */
    @SerializedName( "BOMExplosion" )
    @JsonProperty( "BOMExplosion" )
    @Nullable
    @ODataField( odataName = "BOMExplosion" )
    private String bOMExplosion;
    /**
     * Use with available fluent helpers to apply the <b>BOMExplosion</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BOM_EXPLOSION =
        new BillingDocumentItemField<String>("BOMExplosion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDeterminationType</b>
     * </p>
     *
     * @return ID for material determination
     */
    @SerializedName( "MaterialDeterminationType" )
    @JsonProperty( "MaterialDeterminationType" )
    @Nullable
    @ODataField( odataName = "MaterialDeterminationType" )
    private String materialDeterminationType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDeterminationType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_DETERMINATION_TYPE =
        new BillingDocumentItemField<String>("MaterialDeterminationType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "BillingDocumentItemText" )
    @JsonProperty( "BillingDocumentItemText" )
    @Nullable
    @ODataField( odataName = "BillingDocumentItemText" )
    private String billingDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentItemText</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_DOCUMENT_ITEM_TEXT =
        new BillingDocumentItemField<String>("BillingDocumentItemText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new BillingDocumentItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantity</b>
     * </p>
     *
     * @return Actual Invoiced Quantity
     */
    @SerializedName( "BillingQuantity" )
    @JsonProperty( "BillingQuantity" )
    @Nullable
    @ODataField( odataName = "BillingQuantity" )
    private BigDecimal billingQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BillingQuantity</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> BILLING_QUANTITY =
        new BillingDocumentItemField<BigDecimal>("BillingQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "BillingQuantityUnit" )
    @JsonProperty( "BillingQuantityUnit" )
    @Nullable
    @ODataField( odataName = "BillingQuantityUnit" )
    private String billingQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillingQuantityUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_QUANTITY_UNIT =
        new BillingDocumentItemField<String>("BillingQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityInBaseUnit</b>
     * </p>
     *
     * @return Billing quantity in stock keeping unit
     */
    @SerializedName( "BillingQuantityInBaseUnit" )
    @JsonProperty( "BillingQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "BillingQuantityInBaseUnit" )
    private BigDecimal billingQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillingQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> BILLING_QUANTITY_IN_BASE_UNIT =
        new BillingDocumentItemField<BigDecimal>("BillingQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BASE_UNIT = new BillingDocumentItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPRequiredQuantityInBaseUnit</b>
     * </p>
     *
     * @return Required quantity for mat.management in stockkeeping units
     */
    @SerializedName( "MRPRequiredQuantityInBaseUnit" )
    @JsonProperty( "MRPRequiredQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "MRPRequiredQuantityInBaseUnit" )
    private BigDecimal mRPRequiredQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MRPRequiredQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> MRP_REQUIRED_QUANTITY_IN_BASE_UNIT =
        new BillingDocumentItemField<BigDecimal>("MRPRequiredQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingToBaseQuantityDnmntr</b>
     * </p>
     *
     * @return Denominator (divisor) for conversion of sales Qty into SKU
     */
    @SerializedName( "BillingToBaseQuantityDnmntr" )
    @JsonProperty( "BillingToBaseQuantityDnmntr" )
    @Nullable
    @ODataField( odataName = "BillingToBaseQuantityDnmntr" )
    private BigDecimal billingToBaseQuantityDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>BillingToBaseQuantityDnmntr</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> BILLING_TO_BASE_QUANTITY_DNMNTR =
        new BillingDocumentItemField<BigDecimal>("BillingToBaseQuantityDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingToBaseQuantityNmrtr</b>
     * </p>
     *
     * @return Numerator (factor) for conversion of sales quantity into SKU
     */
    @SerializedName( "BillingToBaseQuantityNmrtr" )
    @JsonProperty( "BillingToBaseQuantityNmrtr" )
    @Nullable
    @ODataField( odataName = "BillingToBaseQuantityNmrtr" )
    private BigDecimal billingToBaseQuantityNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>BillingToBaseQuantityNmrtr</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> BILLING_TO_BASE_QUANTITY_NMRTR =
        new BillingDocumentItemField<BigDecimal>("BillingToBaseQuantityNmrtr");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new BillingDocumentItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ITEM_NET_WEIGHT =
        new BillingDocumentItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ITEM_WEIGHT_UNIT =
        new BillingDocumentItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ITEM_VOLUME =
        new BillingDocumentItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ITEM_VOLUME_UNIT =
        new BillingDocumentItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyCountry</b>
     * </p>
     *
     * @return Destination Country/Region of Sales Order
     */
    @SerializedName( "BillToPartyCountry" )
    @JsonProperty( "BillToPartyCountry" )
    @Nullable
    @ODataField( odataName = "BillToPartyCountry" )
    private String billToPartyCountry;
    /**
     * Use with available fluent helpers to apply the <b>BillToPartyCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILL_TO_PARTY_COUNTRY =
        new BillingDocumentItemField<String>("BillToPartyCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyRegion</b>
     * </p>
     *
     * @return Region of Sales Order
     */
    @SerializedName( "BillToPartyRegion" )
    @JsonProperty( "BillToPartyRegion" )
    @Nullable
    @ODataField( odataName = "BillToPartyRegion" )
    private String billToPartyRegion;
    /**
     * Use with available fluent helpers to apply the <b>BillToPartyRegion</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILL_TO_PARTY_REGION =
        new BillingDocumentItemField<String>("BillToPartyRegion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRule</b>
     * </p>
     *
     * @return Rule in billing plan/invoice plan
     */
    @SerializedName( "BillingPlanRule" )
    @JsonProperty( "BillingPlanRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanRule" )
    private String billingPlanRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanRule</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_PLAN_RULE =
        new BillingDocumentItemField<String>("BillingPlanRule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_PLAN =
        new BillingDocumentItemField<String>("BillingPlan");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @return Item for billing plan/invoice plan/payment cards
     */
    @SerializedName( "BillingPlanItem" )
    @JsonProperty( "BillingPlanItem" )
    @Nullable
    @ODataField( odataName = "BillingPlanItem" )
    private String billingPlanItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_PLAN_ITEM =
        new BillingDocumentItemField<String>("BillingPlanItem");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of Billing item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> NET_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> TRANSACTION_CURRENCY =
        new BillingDocumentItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmount</b>
     * </p>
     *
     * @return Gross Value of the Billing Item in Document Currency
     */
    @SerializedName( "GrossAmount" )
    @JsonProperty( "GrossAmount" )
    @Nullable
    @ODataField( odataName = "GrossAmount" )
    private BigDecimal grossAmount;
    /**
     * Use with available fluent helpers to apply the <b>GrossAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> GROSS_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("GrossAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<LocalDateTime> PRICING_DATE =
        new BillingDocumentItemField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltPriceDetnExchangeRate</b>
     * </p>
     *
     * @return Absolute exchange rate for price determination
     */
    @SerializedName( "AbsltPriceDetnExchangeRate" )
    @JsonProperty( "AbsltPriceDetnExchangeRate" )
    @Nullable
    @ODataField( odataName = "AbsltPriceDetnExchangeRate" )
    private BigDecimal absltPriceDetnExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AbsltPriceDetnExchangeRate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ABSLT_PRICE_DETN_EXCHANGE_RATE =
        new BillingDocumentItemField<BigDecimal>("AbsltPriceDetnExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchRateIsIndrctQtan</b>
     * </p>
     *
     * @return Pricing exchange rate quotation is indirect
     */
    @SerializedName( "PriceDetnExchRateIsIndrctQtan" )
    @JsonProperty( "PriceDetnExchRateIsIndrctQtan" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceDetnExchRateIsIndrctQtan" )
    private Boolean priceDetnExchRateIsIndrctQtan;
    /**
     * Use with available fluent helpers to apply the <b>PriceDetnExchRateIsIndrctQtan</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<Boolean> PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN =
        new BillingDocumentItemField<Boolean>("PriceDetnExchRateIsIndrctQtan");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRateDate</b>
     * </p>
     *
     * @return Translation Date
     */
    @SerializedName( "PriceDetnExchangeRateDate" )
    @JsonProperty( "PriceDetnExchangeRateDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PriceDetnExchangeRateDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime priceDetnExchangeRateDate;
    /**
     * Use with available fluent helpers to apply the <b>PriceDetnExchangeRateDate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<LocalDateTime> PRICE_DETN_EXCHANGE_RATE_DATE =
        new BillingDocumentItemField<LocalDateTime>("PriceDetnExchangeRateDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleQuantityInBaseUnit</b>
     * </p>
     *
     * @return Scale Quantity in base unit of measure
     */
    @SerializedName( "PricingScaleQuantityInBaseUnit" )
    @JsonProperty( "PricingScaleQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "PricingScaleQuantityInBaseUnit" )
    private BigDecimal pricingScaleQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> PRICING_SCALE_QUANTITY_IN_BASE_UNIT =
        new BillingDocumentItemField<BigDecimal>("PricingScaleQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> TAX_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @return Cost in Document Currency
     */
    @SerializedName( "CostAmount" )
    @JsonProperty( "CostAmount" )
    @Nullable
    @ODataField( odataName = "CostAmount" )
    private BigDecimal costAmount;
    /**
     * Use with available fluent helpers to apply the <b>CostAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> COST_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("CostAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @return Subtotal 1 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal1Amount" )
    @JsonProperty( "Subtotal1Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal1Amount" )
    private BigDecimal subtotal1Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal1Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL1_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal1Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @return Subtotal 2 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal2Amount" )
    @JsonProperty( "Subtotal2Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal2Amount" )
    private BigDecimal subtotal2Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal2Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL2_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal2Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @return Subtotal 3 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal3Amount" )
    @JsonProperty( "Subtotal3Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal3Amount" )
    private BigDecimal subtotal3Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal3Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL3_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal3Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @return Subtotal 4 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal4Amount" )
    @JsonProperty( "Subtotal4Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal4Amount" )
    private BigDecimal subtotal4Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal4Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL4_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal4Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @return Subtotal 5 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal5Amount" )
    @JsonProperty( "Subtotal5Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal5Amount" )
    private BigDecimal subtotal5Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal5Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL5_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal5Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @return Subtotal 6 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal6Amount" )
    @JsonProperty( "Subtotal6Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal6Amount" )
    private BigDecimal subtotal6Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal6Amount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> SUBTOTAL6_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("Subtotal6Amount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalValueControl</b>
     * </p>
     *
     * @return Statistical Values
     */
    @SerializedName( "StatisticalValueControl" )
    @JsonProperty( "StatisticalValueControl" )
    @Nullable
    @ODataField( odataName = "StatisticalValueControl" )
    private String statisticalValueControl;
    /**
     * Use with available fluent helpers to apply the <b>StatisticalValueControl</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> STATISTICAL_VALUE_CONTROL =
        new BillingDocumentItemField<String>("StatisticalValueControl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     *
     * @return Cash Discount Indicator
     */
    @SerializedName( "CashDiscountIsDeductible" )
    @JsonProperty( "CashDiscountIsDeductible" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CashDiscountIsDeductible" )
    private Boolean cashDiscountIsDeductible;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountIsDeductible</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<Boolean> CASH_DISCOUNT_IS_DEDUCTIBLE =
        new BillingDocumentItemField<Boolean>("CashDiscountIsDeductible");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup1</b>
     * </p>
     *
     * @return Customer Condition Group 1
     */
    @SerializedName( "CustomerConditionGroup1" )
    @JsonProperty( "CustomerConditionGroup1" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup1" )
    private String customerConditionGroup1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup1</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CUSTOMER_CONDITION_GROUP1 =
        new BillingDocumentItemField<String>("CustomerConditionGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup2</b>
     * </p>
     *
     * @return Customer Condition Group 2
     */
    @SerializedName( "CustomerConditionGroup2" )
    @JsonProperty( "CustomerConditionGroup2" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup2" )
    private String customerConditionGroup2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup2</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CUSTOMER_CONDITION_GROUP2 =
        new BillingDocumentItemField<String>("CustomerConditionGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup3</b>
     * </p>
     *
     * @return Customer Condition Group 3
     */
    @SerializedName( "CustomerConditionGroup3" )
    @JsonProperty( "CustomerConditionGroup3" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup3" )
    private String customerConditionGroup3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup3</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CUSTOMER_CONDITION_GROUP3 =
        new BillingDocumentItemField<String>("CustomerConditionGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup4</b>
     * </p>
     *
     * @return Customer Condition Group 4
     */
    @SerializedName( "CustomerConditionGroup4" )
    @JsonProperty( "CustomerConditionGroup4" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup4" )
    private String customerConditionGroup4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup4</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CUSTOMER_CONDITION_GROUP4 =
        new BillingDocumentItemField<String>("CustomerConditionGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup5</b>
     * </p>
     *
     * @return Customer Condition Group 5
     */
    @SerializedName( "CustomerConditionGroup5" )
    @JsonProperty( "CustomerConditionGroup5" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup5" )
    private String customerConditionGroup5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup5</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CUSTOMER_CONDITION_GROUP5 =
        new BillingDocumentItemField<String>("CustomerConditionGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManualPriceChangeType</b>
     * </p>
     *
     * @return Status manual price change
     */
    @SerializedName( "ManualPriceChangeType" )
    @JsonProperty( "ManualPriceChangeType" )
    @Nullable
    @ODataField( odataName = "ManualPriceChangeType" )
    private String manualPriceChangeType;
    /**
     * Use with available fluent helpers to apply the <b>ManualPriceChangeType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MANUAL_PRICE_CHANGE_TYPE =
        new BillingDocumentItemField<String>("ManualPriceChangeType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATERIAL_PRICING_GROUP =
        new BillingDocumentItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltStatisticsExchangeRate</b>
     * </p>
     *
     * @return Absolute exchange rate for statistics
     */
    @SerializedName( "AbsltStatisticsExchangeRate" )
    @JsonProperty( "AbsltStatisticsExchangeRate" )
    @Nullable
    @ODataField( odataName = "AbsltStatisticsExchangeRate" )
    private BigDecimal absltStatisticsExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AbsltStatisticsExchangeRate</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ABSLT_STATISTICS_EXCHANGE_RATE =
        new BillingDocumentItemField<BigDecimal>("AbsltStatisticsExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsExchRateIsIndrctQtan</b>
     * </p>
     *
     * @return Statistics exchange rate quotation is indirect
     */
    @SerializedName( "StatisticsExchRateIsIndrctQtan" )
    @JsonProperty( "StatisticsExchRateIsIndrctQtan" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StatisticsExchRateIsIndrctQtan" )
    private Boolean statisticsExchRateIsIndrctQtan;
    /**
     * Use with available fluent helpers to apply the <b>StatisticsExchRateIsIndrctQtan</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<Boolean> STATISTICS_EXCH_RATE_IS_INDRCT_QTAN =
        new BillingDocumentItemField<Boolean>("StatisticsExchRateIsIndrctQtan");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainItemPricingRefMaterial</b>
     * </p>
     *
     * @return Pricing reference material of main item
     */
    @SerializedName( "MainItemPricingRefMaterial" )
    @JsonProperty( "MainItemPricingRefMaterial" )
    @Nullable
    @ODataField( odataName = "MainItemPricingRefMaterial" )
    private String mainItemPricingRefMaterial;
    /**
     * Use with available fluent helpers to apply the <b>MainItemPricingRefMaterial</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MAIN_ITEM_PRICING_REF_MATERIAL =
        new BillingDocumentItemField<String>("MainItemPricingRefMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainItemMaterialPricingGroup</b>
     * </p>
     *
     * @return Material pricing group of main item
     */
    @SerializedName( "MainItemMaterialPricingGroup" )
    @JsonProperty( "MainItemMaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MainItemMaterialPricingGroup" )
    private String mainItemMaterialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MainItemMaterialPricingGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MAIN_ITEM_MATERIAL_PRICING_GROUP =
        new BillingDocumentItemField<String>("MainItemMaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @return Departure Country/Region (from which the goods are sent)
     */
    @SerializedName( "DepartureCountry" )
    @JsonProperty( "DepartureCountry" )
    @Nullable
    @ODataField( odataName = "DepartureCountry" )
    private String departureCountry;
    /**
     * Use with available fluent helpers to apply the <b>DepartureCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> DEPARTURE_COUNTRY =
        new BillingDocumentItemField<String>("DepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> TAX_JURISDICTION =
        new BillingDocumentItemField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification of Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new BillingDocumentItemField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new BillingDocumentItemField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new BillingDocumentItemField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new BillingDocumentItemField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new BillingDocumentItemField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new BillingDocumentItemField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new BillingDocumentItemField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new BillingDocumentItemField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new BillingDocumentItemField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ZeroVATRsn</b>
     * </p>
     *
     * @return Reason for Zero VAT
     */
    @SerializedName( "ZeroVATRsn" )
    @JsonProperty( "ZeroVATRsn" )
    @Nullable
    @ODataField( odataName = "ZeroVATRsn" )
    private String zeroVATRsn;
    /**
     * Use with available fluent helpers to apply the <b>ZeroVATRsn</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ZERO_VAT_RSN =
        new BillingDocumentItemField<String>("ZeroVATRsn");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EligibleAmountForCashDiscount</b>
     * </p>
     *
     * @return Amount eligible for cash discount in document currency
     */
    @SerializedName( "EligibleAmountForCashDiscount" )
    @JsonProperty( "EligibleAmountForCashDiscount" )
    @Nullable
    @ODataField( odataName = "EligibleAmountForCashDiscount" )
    private BigDecimal eligibleAmountForCashDiscount;
    /**
     * Use with available fluent helpers to apply the <b>EligibleAmountForCashDiscount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> ELIGIBLE_AMOUNT_FOR_CASH_DISCOUNT =
        new BillingDocumentItemField<BigDecimal>("EligibleAmountForCashDiscount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BUSINESS_AREA =
        new BillingDocumentItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PROFIT_CENTER =
        new BillingDocumentItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> WBS_ELEMENT =
        new BillingDocumentItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> CONTROLLING_AREA =
        new BillingDocumentItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Deprecated: Profitability Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> PROFITABILITY_SEGMENT =
        new BillingDocumentItemField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ORDER_ID = new BillingDocumentItemField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> COST_CENTER =
        new BillingDocumentItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginSDDocument</b>
     * </p>
     *
     * @return Originating Document
     */
    @SerializedName( "OriginSDDocument" )
    @JsonProperty( "OriginSDDocument" )
    @Nullable
    @ODataField( odataName = "OriginSDDocument" )
    private String originSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>OriginSDDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ORIGIN_SD_DOCUMENT =
        new BillingDocumentItemField<String>("OriginSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginSDDocumentItem</b>
     * </p>
     *
     * @return Originating Item
     */
    @SerializedName( "OriginSDDocumentItem" )
    @JsonProperty( "OriginSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "OriginSDDocumentItem" )
    private String originSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>OriginSDDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ORIGIN_SD_DOCUMENT_ITEM =
        new BillingDocumentItemField<String>("OriginSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "MatlAccountAssignmentGroup" )
    @JsonProperty( "MatlAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "MatlAccountAssignmentGroup" )
    private String matlAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> MATL_ACCOUNT_ASSIGNMENT_GROUP =
        new BillingDocumentItemField<String>("MatlAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> REFERENCE_SD_DOCUMENT =
        new BillingDocumentItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new BillingDocumentItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Reference Document Category
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new BillingDocumentItemField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_DOCUMENT =
        new BillingDocumentItemField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_DOCUMENT_ITEM =
        new BillingDocumentItemField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSDDocumentCategory</b>
     * </p>
     *
     * @return Sales Document Category
     */
    @SerializedName( "SalesSDDocumentCategory" )
    @JsonProperty( "SalesSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SalesSDDocumentCategory" )
    private String salesSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesSDDocumentCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_SD_DOCUMENT_CATEGORY =
        new BillingDocumentItemField<String>("SalesSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> HIGHER_LEVEL_ITEM =
        new BillingDocumentItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItemInPartSgmt</b>
     * </p>
     *
     * @return Item Number in the Partner Segment
     */
    @SerializedName( "BillingDocumentItemInPartSgmt" )
    @JsonProperty( "BillingDocumentItemInPartSgmt" )
    @Nullable
    @ODataField( odataName = "BillingDocumentItemInPartSgmt" )
    private String billingDocumentItemInPartSgmt;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentItemInPartSgmt</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> BILLING_DOCUMENT_ITEM_IN_PART_SGMT =
        new BillingDocumentItemField<String>("BillingDocumentItemInPartSgmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocument</b>
     * </p>
     *
     * @return External Reference Document
     */
    @SerializedName( "ExternalReferenceDocument" )
    @JsonProperty( "ExternalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ExternalReferenceDocument" )
    private String externalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ExternalReferenceDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> EXTERNAL_REFERENCE_DOCUMENT =
        new BillingDocumentItemField<String>("ExternalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocumentItem</b>
     * </p>
     *
     * @return External Reference Document Item
     */
    @SerializedName( "ExternalReferenceDocumentItem" )
    @JsonProperty( "ExternalReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ExternalReferenceDocumentItem" )
    private String externalReferenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ExternalReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> EXTERNAL_REFERENCE_DOCUMENT_ITEM =
        new BillingDocumentItemField<String>("ExternalReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_GROUP =
        new BillingDocumentItemField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @return Customer Group 1
     */
    @SerializedName( "AdditionalCustomerGroup1" )
    @JsonProperty( "AdditionalCustomerGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup1" )
    private String additionalCustomerGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup1</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_CUSTOMER_GROUP1 =
        new BillingDocumentItemField<String>("AdditionalCustomerGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @return Customer Group 2
     */
    @SerializedName( "AdditionalCustomerGroup2" )
    @JsonProperty( "AdditionalCustomerGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup2" )
    private String additionalCustomerGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup2</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_CUSTOMER_GROUP2 =
        new BillingDocumentItemField<String>("AdditionalCustomerGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @return Customer Group 3
     */
    @SerializedName( "AdditionalCustomerGroup3" )
    @JsonProperty( "AdditionalCustomerGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup3" )
    private String additionalCustomerGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup3</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_CUSTOMER_GROUP3 =
        new BillingDocumentItemField<String>("AdditionalCustomerGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @return Customer Group 4
     */
    @SerializedName( "AdditionalCustomerGroup4" )
    @JsonProperty( "AdditionalCustomerGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup4" )
    private String additionalCustomerGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup4</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_CUSTOMER_GROUP4 =
        new BillingDocumentItemField<String>("AdditionalCustomerGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @return Customer Group 5
     */
    @SerializedName( "AdditionalCustomerGroup5" )
    @JsonProperty( "AdditionalCustomerGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup5" )
    private String additionalCustomerGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup5</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> ADDITIONAL_CUSTOMER_GROUP5 =
        new BillingDocumentItemField<String>("AdditionalCustomerGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SD_DOCUMENT_REASON =
        new BillingDocumentItemField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetailPromotion</b>
     * </p>
     *
     * @return Retail Promotion
     */
    @SerializedName( "RetailPromotion" )
    @JsonProperty( "RetailPromotion" )
    @Nullable
    @ODataField( odataName = "RetailPromotion" )
    private String retailPromotion;
    /**
     * Use with available fluent helpers to apply the <b>RetailPromotion</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> RETAIL_PROMOTION =
        new BillingDocumentItemField<String>("RetailPromotion");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RebateBasisAmount</b>
     * </p>
     *
     * @return Rebate Basis 1
     */
    @SerializedName( "RebateBasisAmount" )
    @JsonProperty( "RebateBasisAmount" )
    @Nullable
    @ODataField( odataName = "RebateBasisAmount" )
    private BigDecimal rebateBasisAmount;
    /**
     * Use with available fluent helpers to apply the <b>RebateBasisAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> REBATE_BASIS_AMOUNT =
        new BillingDocumentItemField<BigDecimal>("RebateBasisAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @return Volume rebate group
     */
    @SerializedName( "VolumeRebateGroup" )
    @JsonProperty( "VolumeRebateGroup" )
    @Nullable
    @ODataField( odataName = "VolumeRebateGroup" )
    private String volumeRebateGroup;
    /**
     * Use with available fluent helpers to apply the <b>VolumeRebateGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> VOLUME_REBATE_GROUP =
        new BillingDocumentItemField<String>("VolumeRebateGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsRelevantForCredit</b>
     * </p>
     *
     * @return ID: Item with active credit function / relevant for credit
     */
    @SerializedName( "ItemIsRelevantForCredit" )
    @JsonProperty( "ItemIsRelevantForCredit" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ItemIsRelevantForCredit" )
    private Boolean itemIsRelevantForCredit;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsRelevantForCredit</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<Boolean> ITEM_IS_RELEVANT_FOR_CREDIT =
        new BillingDocumentItemField<Boolean>("ItemIsRelevantForCredit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditRelatedPrice</b>
     * </p>
     *
     * @return Item credit price
     */
    @SerializedName( "CreditRelatedPrice" )
    @JsonProperty( "CreditRelatedPrice" )
    @Nullable
    @ODataField( odataName = "CreditRelatedPrice" )
    private BigDecimal creditRelatedPrice;
    /**
     * Use with available fluent helpers to apply the <b>CreditRelatedPrice</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<BigDecimal> CREDIT_RELATED_PRICE =
        new BillingDocumentItemField<BigDecimal>("CreditRelatedPrice");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDeal</b>
     * </p>
     *
     * @return Sales Deal
     */
    @SerializedName( "SalesDeal" )
    @JsonProperty( "SalesDeal" )
    @Nullable
    @ODataField( odataName = "SalesDeal" )
    private String salesDeal;
    /**
     * Use with available fluent helpers to apply the <b>SalesDeal</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_DEAL = new BillingDocumentItemField<String>("SalesDeal");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesPromotion</b>
     * </p>
     *
     * @return Promotion
     */
    @SerializedName( "SalesPromotion" )
    @JsonProperty( "SalesPromotion" )
    @Nullable
    @ODataField( odataName = "SalesPromotion" )
    private String salesPromotion;
    /**
     * Use with available fluent helpers to apply the <b>SalesPromotion</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_PROMOTION =
        new BillingDocumentItemField<String>("SalesPromotion");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesDistrict</b>
     * </p>
     *
     * @return Sales district of sales order
     */
    @SerializedName( "SalesOrderSalesDistrict" )
    @JsonProperty( "SalesOrderSalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesOrderSalesDistrict" )
    private String salesOrderSalesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderSalesDistrict</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_SALES_DISTRICT =
        new BillingDocumentItemField<String>("SalesOrderSalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderCustomerGroup</b>
     * </p>
     *
     * @return Customer group of sales order
     */
    @SerializedName( "SalesOrderCustomerGroup" )
    @JsonProperty( "SalesOrderCustomerGroup" )
    @Nullable
    @ODataField( odataName = "SalesOrderCustomerGroup" )
    private String salesOrderCustomerGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderCustomerGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_CUSTOMER_GROUP =
        new BillingDocumentItemField<String>("SalesOrderCustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderCustomerPriceGroup</b>
     * </p>
     *
     * @return Price group of sales order
     */
    @SerializedName( "SalesOrderCustomerPriceGroup" )
    @JsonProperty( "SalesOrderCustomerPriceGroup" )
    @Nullable
    @ODataField( odataName = "SalesOrderCustomerPriceGroup" )
    private String salesOrderCustomerPriceGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderCustomerPriceGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_CUSTOMER_PRICE_GROUP =
        new BillingDocumentItemField<String>("SalesOrderCustomerPriceGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderPriceListType</b>
     * </p>
     *
     * @return Price list type of sales order
     */
    @SerializedName( "SalesOrderPriceListType" )
    @JsonProperty( "SalesOrderPriceListType" )
    @Nullable
    @ODataField( odataName = "SalesOrderPriceListType" )
    private String salesOrderPriceListType;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderPriceListType</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_PRICE_LIST_TYPE =
        new BillingDocumentItemField<String>("SalesOrderPriceListType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesOrganization</b>
     * </p>
     *
     * @return Sales organization of sales order
     */
    @SerializedName( "SalesOrderSalesOrganization" )
    @JsonProperty( "SalesOrderSalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrderSalesOrganization" )
    private String salesOrderSalesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderSalesOrganization</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_SALES_ORGANIZATION =
        new BillingDocumentItemField<String>("SalesOrderSalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDistributionChannel</b>
     * </p>
     *
     * @return Distribution channel of sales order
     */
    @SerializedName( "SalesOrderDistributionChannel" )
    @JsonProperty( "SalesOrderDistributionChannel" )
    @Nullable
    @ODataField( odataName = "SalesOrderDistributionChannel" )
    private String salesOrderDistributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderDistributionChannel</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SALES_ORDER_DISTRIBUTION_CHANNEL =
        new BillingDocumentItemField<String>("SalesOrderDistributionChannel");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocIsCreatedFromReference</b>
     * </p>
     *
     * @return Sales document was created from reference
     */
    @SerializedName( "SalesDocIsCreatedFromReference" )
    @JsonProperty( "SalesDocIsCreatedFromReference" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SalesDocIsCreatedFromReference" )
    private Boolean salesDocIsCreatedFromReference;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocIsCreatedFromReference</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<Boolean> SALES_DOC_IS_CREATED_FROM_REFERENCE =
        new BillingDocumentItemField<Boolean>("SalesDocIsCreatedFromReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> SHIPPING_POINT =
        new BillingDocumentItemField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @return ID for higher-level item usage
     */
    @SerializedName( "HigherLevelItemUsage" )
    @JsonProperty( "HigherLevelItemUsage" )
    @Nullable
    @ODataField( odataName = "HigherLevelItemUsage" )
    private String higherLevelItemUsage;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItemUsage</b> field to query operations.
     *
     */
    public final static BillingDocumentItemField<String> HIGHER_LEVEL_ITEM_USAGE =
        new BillingDocumentItemField<String>("HigherLevelItemUsage");
    /**
     * Navigation property <b>to_BillingDocument</b> for <b>BillingDocumentItem</b> to single <b>BillingDocument</b>.
     *
     */
    @SerializedName( "to_BillingDocument" )
    @JsonProperty( "to_BillingDocument" )
    @ODataField( odataName = "to_BillingDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocument toBillingDocument;
    /**
     * Navigation property <b>to_ItemText</b> for <b>BillingDocumentItem</b> to multiple <b>BillingDocumentItemText</b>.
     *
     */
    @SerializedName( "to_ItemText" )
    @JsonProperty( "to_ItemText" )
    @ODataField( odataName = "to_ItemText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentItemText> toItemText;
    /**
     * Navigation property <b>to_Partner</b> for <b>BillingDocumentItem</b> to multiple
     * <b>BillingDocumentItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentItem</b> to multiple
     * <b>BillingDocumentItemPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentItemPrcgElmnt> toPricingElement;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingDocument</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentItemOneToOneLink<BillingDocument> TO_BILLING_DOCUMENT =
        new BillingDocumentItemOneToOneLink<BillingDocument>("to_BillingDocument");
    /**
     * Use with available fluent helpers to apply the <b>to_ItemText</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentItemLink<BillingDocumentItemText> TO_ITEM_TEXT =
        new BillingDocumentItemLink<BillingDocumentItemText>("to_ItemText");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentItemLink<BillingDocumentItemPartner> TO_PARTNER =
        new BillingDocumentItemLink<BillingDocumentItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentItemLink<BillingDocumentItemPrcgElmnt> TO_PRICING_ELEMENT =
        new BillingDocumentItemLink<BillingDocumentItemPrcgElmnt>("to_PricingElement");

    @Nonnull
    @Override
    public Class<BillingDocumentItem> getType()
    {
        return BillingDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItem</b>
     * </p>
     *
     * @param billingDocumentItem
     *            Billing Item
     */
    public void setBillingDocumentItem( @Nullable final String billingDocumentItem )
    {
        rememberChangedField("BillingDocumentItem", this.billingDocumentItem);
        this.billingDocumentItem = billingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemCategory</b>
     * </p>
     *
     * @param salesDocumentItemCategory
     *            Sales Document Item Category
     */
    public void setSalesDocumentItemCategory( @Nullable final String salesDocumentItemCategory )
    {
        rememberChangedField("SalesDocumentItemCategory", this.salesDocumentItemCategory);
        this.salesDocumentItemCategory = salesDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemType</b>
     * </p>
     *
     * @param salesDocumentItemType
     *            Item Type
     */
    public void setSalesDocumentItemType( @Nullable final String salesDocumentItemType )
    {
        rememberChangedField("SalesDocumentItemType", this.salesDocumentItemType);
        this.salesDocumentItemType = salesDocumentItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnItemProcessingType</b>
     * </p>
     *
     * @param returnItemProcessingType
     *            Returns item
     */
    public void setReturnItemProcessingType( @Nullable final String returnItemProcessingType )
    {
        rememberChangedField("ReturnItemProcessingType", this.returnItemProcessingType);
        this.returnItemProcessingType = returnItemProcessingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceLogicalSystem</b>
     * </p>
     *
     * @param referenceLogicalSystem
     *            Logical System
     */
    public void setReferenceLogicalSystem( @Nullable final String referenceLogicalSystem )
    {
        rememberChangedField("ReferenceLogicalSystem", this.referenceLogicalSystem);
        this.referenceLogicalSystem = referenceLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division in Sales Order Header
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @param originallyRequestedMaterial
     *            Material Entered
     */
    public void setOriginallyRequestedMaterial( @Nullable final String originallyRequestedMaterial )
    {
        rememberChangedField("OriginallyRequestedMaterial", this.originallyRequestedMaterial);
        this.originallyRequestedMaterial = originallyRequestedMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @param internationalArticleNumber
     *            International Article Number (EAN/UPC)
     */
    public void setInternationalArticleNumber( @Nullable final String internationalArticleNumber )
    {
        rememberChangedField("InternationalArticleNumber", this.internationalArticleNumber);
        this.internationalArticleNumber = internationalArticleNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @param pricingReferenceMaterial
     *            Pricing Reference Material
     */
    public void setPricingReferenceMaterial( @Nullable final String pricingReferenceMaterial )
    {
        rememberChangedField("PricingReferenceMaterial", this.pricingReferenceMaterial);
        this.pricingReferenceMaterial = pricingReferenceMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @param productHierarchyNode
     *            Product Hierarchy
     */
    public void setProductHierarchyNode( @Nullable final String productHierarchyNode )
    {
        rememberChangedField("ProductHierarchyNode", this.productHierarchyNode);
        this.productHierarchyNode = productHierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @param additionalMaterialGroup1
     *            Material Group 1
     */
    public void setAdditionalMaterialGroup1( @Nullable final String additionalMaterialGroup1 )
    {
        rememberChangedField("AdditionalMaterialGroup1", this.additionalMaterialGroup1);
        this.additionalMaterialGroup1 = additionalMaterialGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @param additionalMaterialGroup2
     *            Material Group 2
     */
    public void setAdditionalMaterialGroup2( @Nullable final String additionalMaterialGroup2 )
    {
        rememberChangedField("AdditionalMaterialGroup2", this.additionalMaterialGroup2);
        this.additionalMaterialGroup2 = additionalMaterialGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @param additionalMaterialGroup3
     *            Material Group 3
     */
    public void setAdditionalMaterialGroup3( @Nullable final String additionalMaterialGroup3 )
    {
        rememberChangedField("AdditionalMaterialGroup3", this.additionalMaterialGroup3);
        this.additionalMaterialGroup3 = additionalMaterialGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @param additionalMaterialGroup4
     *            Material Group 4
     */
    public void setAdditionalMaterialGroup4( @Nullable final String additionalMaterialGroup4 )
    {
        rememberChangedField("AdditionalMaterialGroup4", this.additionalMaterialGroup4);
        this.additionalMaterialGroup4 = additionalMaterialGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @param additionalMaterialGroup5
     *            Material Group 5
     */
    public void setAdditionalMaterialGroup5( @Nullable final String additionalMaterialGroup5 )
    {
        rememberChangedField("AdditionalMaterialGroup5", this.additionalMaterialGroup5);
        this.additionalMaterialGroup5 = additionalMaterialGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCommissionGroup</b>
     * </p>
     *
     * @param materialCommissionGroup
     *            Commission Group
     */
    public void setMaterialCommissionGroup( @Nullable final String materialCommissionGroup )
    {
        rememberChangedField("MaterialCommissionGroup", this.materialCommissionGroup);
        this.materialCommissionGroup = materialCommissionGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementPartType</b>
     * </p>
     *
     * @param replacementPartType
     *            Replacement part
     */
    public void setReplacementPartType( @Nullable final String replacementPartType )
    {
        rememberChangedField("ReplacementPartType", this.replacementPartType);
        this.replacementPartType = replacementPartType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupHierarchy1</b>
     * </p>
     *
     * @param materialGroupHierarchy1
     *            Material group hierarchy 1
     */
    public void setMaterialGroupHierarchy1( @Nullable final String materialGroupHierarchy1 )
    {
        rememberChangedField("MaterialGroupHierarchy1", this.materialGroupHierarchy1);
        this.materialGroupHierarchy1 = materialGroupHierarchy1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupHierarchy2</b>
     * </p>
     *
     * @param materialGroupHierarchy2
     *            Material group hierarchy 2
     */
    public void setMaterialGroupHierarchy2( @Nullable final String materialGroupHierarchy2 )
    {
        rememberChangedField("MaterialGroupHierarchy2", this.materialGroupHierarchy2);
        this.materialGroupHierarchy2 = materialGroupHierarchy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @param plantRegion
     *            Region in which plant is located
     */
    public void setPlantRegion( @Nullable final String plantRegion )
    {
        rememberChangedField("PlantRegion", this.plantRegion);
        this.plantRegion = plantRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantCounty</b>
     * </p>
     *
     * @param plantCounty
     *            County in which plant is located
     */
    public void setPlantCounty( @Nullable final String plantCounty )
    {
        rememberChangedField("PlantCounty", this.plantCounty);
        this.plantCounty = plantCounty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlantCity</b>
     * </p>
     *
     * @param plantCity
     *            City in which plant is located
     */
    public void setPlantCity( @Nullable final String plantCity )
    {
        rememberChangedField("PlantCity", this.plantCity);
        this.plantCity = plantCity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosion</b>
     * </p>
     *
     * @param bOMExplosion
     *            BOM Explosion Number
     */
    public void setBOMExplosion( @Nullable final String bOMExplosion )
    {
        rememberChangedField("BOMExplosion", this.bOMExplosion);
        this.bOMExplosion = bOMExplosion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDeterminationType</b>
     * </p>
     *
     * @param materialDeterminationType
     *            ID for material determination
     */
    public void setMaterialDeterminationType( @Nullable final String materialDeterminationType )
    {
        rememberChangedField("MaterialDeterminationType", this.materialDeterminationType);
        this.materialDeterminationType = materialDeterminationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItemText</b>
     * </p>
     *
     * @param billingDocumentItemText
     *            Short Text for Sales Order Item
     */
    public void setBillingDocumentItemText( @Nullable final String billingDocumentItemText )
    {
        rememberChangedField("BillingDocumentItemText", this.billingDocumentItemText);
        this.billingDocumentItemText = billingDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantity</b>
     * </p>
     *
     * @param billingQuantity
     *            Actual Invoiced Quantity
     */
    public void setBillingQuantity( @Nullable final BigDecimal billingQuantity )
    {
        rememberChangedField("BillingQuantity", this.billingQuantity);
        this.billingQuantity = billingQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityUnit</b>
     * </p>
     *
     * @param billingQuantityUnit
     *            Sales Unit
     */
    public void setBillingQuantityUnit( @Nullable final String billingQuantityUnit )
    {
        rememberChangedField("BillingQuantityUnit", this.billingQuantityUnit);
        this.billingQuantityUnit = billingQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityInBaseUnit</b>
     * </p>
     *
     * @param billingQuantityInBaseUnit
     *            Billing quantity in stock keeping unit
     */
    public void setBillingQuantityInBaseUnit( @Nullable final BigDecimal billingQuantityInBaseUnit )
    {
        rememberChangedField("BillingQuantityInBaseUnit", this.billingQuantityInBaseUnit);
        this.billingQuantityInBaseUnit = billingQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPRequiredQuantityInBaseUnit</b>
     * </p>
     *
     * @param mRPRequiredQuantityInBaseUnit
     *            Required quantity for mat.management in stockkeeping units
     */
    public void setMRPRequiredQuantityInBaseUnit( @Nullable final BigDecimal mRPRequiredQuantityInBaseUnit )
    {
        rememberChangedField("MRPRequiredQuantityInBaseUnit", this.mRPRequiredQuantityInBaseUnit);
        this.mRPRequiredQuantityInBaseUnit = mRPRequiredQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingToBaseQuantityDnmntr</b>
     * </p>
     *
     * @param billingToBaseQuantityDnmntr
     *            Denominator (divisor) for conversion of sales Qty into SKU
     */
    public void setBillingToBaseQuantityDnmntr( @Nullable final BigDecimal billingToBaseQuantityDnmntr )
    {
        rememberChangedField("BillingToBaseQuantityDnmntr", this.billingToBaseQuantityDnmntr);
        this.billingToBaseQuantityDnmntr = billingToBaseQuantityDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingToBaseQuantityNmrtr</b>
     * </p>
     *
     * @param billingToBaseQuantityNmrtr
     *            Numerator (factor) for conversion of sales quantity into SKU
     */
    public void setBillingToBaseQuantityNmrtr( @Nullable final BigDecimal billingToBaseQuantityNmrtr )
    {
        rememberChangedField("BillingToBaseQuantityNmrtr", this.billingToBaseQuantityNmrtr);
        this.billingToBaseQuantityNmrtr = billingToBaseQuantityNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyCountry</b>
     * </p>
     *
     * @param billToPartyCountry
     *            Destination Country/Region of Sales Order
     */
    public void setBillToPartyCountry( @Nullable final String billToPartyCountry )
    {
        rememberChangedField("BillToPartyCountry", this.billToPartyCountry);
        this.billToPartyCountry = billToPartyCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyRegion</b>
     * </p>
     *
     * @param billToPartyRegion
     *            Region of Sales Order
     */
    public void setBillToPartyRegion( @Nullable final String billToPartyRegion )
    {
        rememberChangedField("BillToPartyRegion", this.billToPartyRegion);
        this.billToPartyRegion = billToPartyRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRule</b>
     * </p>
     *
     * @param billingPlanRule
     *            Rule in billing plan/invoice plan
     */
    public void setBillingPlanRule( @Nullable final String billingPlanRule )
    {
        rememberChangedField("BillingPlanRule", this.billingPlanRule);
        this.billingPlanRule = billingPlanRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     */
    public void setBillingPlanItem( @Nullable final String billingPlanItem )
    {
        rememberChangedField("BillingPlanItem", this.billingPlanItem);
        this.billingPlanItem = billingPlanItem;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of Billing item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmount</b>
     * </p>
     *
     * @param grossAmount
     *            Gross Value of the Billing Item in Document Currency
     */
    public void setGrossAmount( @Nullable final BigDecimal grossAmount )
    {
        rememberChangedField("GrossAmount", this.grossAmount);
        this.grossAmount = grossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltPriceDetnExchangeRate</b>
     * </p>
     *
     * @param absltPriceDetnExchangeRate
     *            Absolute exchange rate for price determination
     */
    public void setAbsltPriceDetnExchangeRate( @Nullable final BigDecimal absltPriceDetnExchangeRate )
    {
        rememberChangedField("AbsltPriceDetnExchangeRate", this.absltPriceDetnExchangeRate);
        this.absltPriceDetnExchangeRate = absltPriceDetnExchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchRateIsIndrctQtan</b>
     * </p>
     *
     * @param priceDetnExchRateIsIndrctQtan
     *            Pricing exchange rate quotation is indirect
     */
    public void setPriceDetnExchRateIsIndrctQtan( @Nullable final Boolean priceDetnExchRateIsIndrctQtan )
    {
        rememberChangedField("PriceDetnExchRateIsIndrctQtan", this.priceDetnExchRateIsIndrctQtan);
        this.priceDetnExchRateIsIndrctQtan = priceDetnExchRateIsIndrctQtan;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRateDate</b>
     * </p>
     *
     * @param priceDetnExchangeRateDate
     *            Translation Date
     */
    public void setPriceDetnExchangeRateDate( @Nullable final LocalDateTime priceDetnExchangeRateDate )
    {
        rememberChangedField("PriceDetnExchangeRateDate", this.priceDetnExchangeRateDate);
        this.priceDetnExchangeRateDate = priceDetnExchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleQuantityInBaseUnit</b>
     * </p>
     *
     * @param pricingScaleQuantityInBaseUnit
     *            Scale Quantity in base unit of measure
     */
    public void setPricingScaleQuantityInBaseUnit( @Nullable final BigDecimal pricingScaleQuantityInBaseUnit )
    {
        rememberChangedField("PricingScaleQuantityInBaseUnit", this.pricingScaleQuantityInBaseUnit);
        this.pricingScaleQuantityInBaseUnit = pricingScaleQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @param costAmount
     *            Cost in Document Currency
     */
    public void setCostAmount( @Nullable final BigDecimal costAmount )
    {
        rememberChangedField("CostAmount", this.costAmount);
        this.costAmount = costAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @param subtotal1Amount
     *            Subtotal 1 from Pricing Procedure for Price Element
     */
    public void setSubtotal1Amount( @Nullable final BigDecimal subtotal1Amount )
    {
        rememberChangedField("Subtotal1Amount", this.subtotal1Amount);
        this.subtotal1Amount = subtotal1Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @param subtotal2Amount
     *            Subtotal 2 from Pricing Procedure for Price Element
     */
    public void setSubtotal2Amount( @Nullable final BigDecimal subtotal2Amount )
    {
        rememberChangedField("Subtotal2Amount", this.subtotal2Amount);
        this.subtotal2Amount = subtotal2Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @param subtotal3Amount
     *            Subtotal 3 from Pricing Procedure for Price Element
     */
    public void setSubtotal3Amount( @Nullable final BigDecimal subtotal3Amount )
    {
        rememberChangedField("Subtotal3Amount", this.subtotal3Amount);
        this.subtotal3Amount = subtotal3Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @param subtotal4Amount
     *            Subtotal 4 from Pricing Procedure for Price Element
     */
    public void setSubtotal4Amount( @Nullable final BigDecimal subtotal4Amount )
    {
        rememberChangedField("Subtotal4Amount", this.subtotal4Amount);
        this.subtotal4Amount = subtotal4Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @param subtotal5Amount
     *            Subtotal 5 from Pricing Procedure for Price Element
     */
    public void setSubtotal5Amount( @Nullable final BigDecimal subtotal5Amount )
    {
        rememberChangedField("Subtotal5Amount", this.subtotal5Amount);
        this.subtotal5Amount = subtotal5Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @param subtotal6Amount
     *            Subtotal 6 from Pricing Procedure for Price Element
     */
    public void setSubtotal6Amount( @Nullable final BigDecimal subtotal6Amount )
    {
        rememberChangedField("Subtotal6Amount", this.subtotal6Amount);
        this.subtotal6Amount = subtotal6Amount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StatisticalValueControl</b>
     * </p>
     *
     * @param statisticalValueControl
     *            Statistical Values
     */
    public void setStatisticalValueControl( @Nullable final String statisticalValueControl )
    {
        rememberChangedField("StatisticalValueControl", this.statisticalValueControl);
        this.statisticalValueControl = statisticalValueControl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     *
     * @param cashDiscountIsDeductible
     *            Cash Discount Indicator
     */
    public void setCashDiscountIsDeductible( @Nullable final Boolean cashDiscountIsDeductible )
    {
        rememberChangedField("CashDiscountIsDeductible", this.cashDiscountIsDeductible);
        this.cashDiscountIsDeductible = cashDiscountIsDeductible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup1</b>
     * </p>
     *
     * @param customerConditionGroup1
     *            Customer Condition Group 1
     */
    public void setCustomerConditionGroup1( @Nullable final String customerConditionGroup1 )
    {
        rememberChangedField("CustomerConditionGroup1", this.customerConditionGroup1);
        this.customerConditionGroup1 = customerConditionGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup2</b>
     * </p>
     *
     * @param customerConditionGroup2
     *            Customer Condition Group 2
     */
    public void setCustomerConditionGroup2( @Nullable final String customerConditionGroup2 )
    {
        rememberChangedField("CustomerConditionGroup2", this.customerConditionGroup2);
        this.customerConditionGroup2 = customerConditionGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup3</b>
     * </p>
     *
     * @param customerConditionGroup3
     *            Customer Condition Group 3
     */
    public void setCustomerConditionGroup3( @Nullable final String customerConditionGroup3 )
    {
        rememberChangedField("CustomerConditionGroup3", this.customerConditionGroup3);
        this.customerConditionGroup3 = customerConditionGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup4</b>
     * </p>
     *
     * @param customerConditionGroup4
     *            Customer Condition Group 4
     */
    public void setCustomerConditionGroup4( @Nullable final String customerConditionGroup4 )
    {
        rememberChangedField("CustomerConditionGroup4", this.customerConditionGroup4);
        this.customerConditionGroup4 = customerConditionGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup5</b>
     * </p>
     *
     * @param customerConditionGroup5
     *            Customer Condition Group 5
     */
    public void setCustomerConditionGroup5( @Nullable final String customerConditionGroup5 )
    {
        rememberChangedField("CustomerConditionGroup5", this.customerConditionGroup5);
        this.customerConditionGroup5 = customerConditionGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManualPriceChangeType</b>
     * </p>
     *
     * @param manualPriceChangeType
     *            Status manual price change
     */
    public void setManualPriceChangeType( @Nullable final String manualPriceChangeType )
    {
        rememberChangedField("ManualPriceChangeType", this.manualPriceChangeType);
        this.manualPriceChangeType = manualPriceChangeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltStatisticsExchangeRate</b>
     * </p>
     *
     * @param absltStatisticsExchangeRate
     *            Absolute exchange rate for statistics
     */
    public void setAbsltStatisticsExchangeRate( @Nullable final BigDecimal absltStatisticsExchangeRate )
    {
        rememberChangedField("AbsltStatisticsExchangeRate", this.absltStatisticsExchangeRate);
        this.absltStatisticsExchangeRate = absltStatisticsExchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsExchRateIsIndrctQtan</b>
     * </p>
     *
     * @param statisticsExchRateIsIndrctQtan
     *            Statistics exchange rate quotation is indirect
     */
    public void setStatisticsExchRateIsIndrctQtan( @Nullable final Boolean statisticsExchRateIsIndrctQtan )
    {
        rememberChangedField("StatisticsExchRateIsIndrctQtan", this.statisticsExchRateIsIndrctQtan);
        this.statisticsExchRateIsIndrctQtan = statisticsExchRateIsIndrctQtan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainItemPricingRefMaterial</b>
     * </p>
     *
     * @param mainItemPricingRefMaterial
     *            Pricing reference material of main item
     */
    public void setMainItemPricingRefMaterial( @Nullable final String mainItemPricingRefMaterial )
    {
        rememberChangedField("MainItemPricingRefMaterial", this.mainItemPricingRefMaterial);
        this.mainItemPricingRefMaterial = mainItemPricingRefMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainItemMaterialPricingGroup</b>
     * </p>
     *
     * @param mainItemMaterialPricingGroup
     *            Material pricing group of main item
     */
    public void setMainItemMaterialPricingGroup( @Nullable final String mainItemMaterialPricingGroup )
    {
        rememberChangedField("MainItemMaterialPricingGroup", this.mainItemMaterialPricingGroup);
        this.mainItemMaterialPricingGroup = mainItemMaterialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     */
    public void setDepartureCountry( @Nullable final String departureCountry )
    {
        rememberChangedField("DepartureCountry", this.departureCountry);
        this.departureCountry = departureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification of Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification 2 for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification 3 for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification 4 for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification 5 for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification 6 for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification 7 for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification 8 for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification 9 for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ZeroVATRsn</b>
     * </p>
     *
     * @param zeroVATRsn
     *            Reason for Zero VAT
     */
    public void setZeroVATRsn( @Nullable final String zeroVATRsn )
    {
        rememberChangedField("ZeroVATRsn", this.zeroVATRsn);
        this.zeroVATRsn = zeroVATRsn;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EligibleAmountForCashDiscount</b>
     * </p>
     *
     * @param eligibleAmountForCashDiscount
     *            Amount eligible for cash discount in document currency
     */
    public void setEligibleAmountForCashDiscount( @Nullable final BigDecimal eligibleAmountForCashDiscount )
    {
        rememberChangedField("EligibleAmountForCashDiscount", this.eligibleAmountForCashDiscount);
        this.eligibleAmountForCashDiscount = eligibleAmountForCashDiscount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Deprecated: Profitability Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginSDDocument</b>
     * </p>
     *
     * @param originSDDocument
     *            Originating Document
     */
    public void setOriginSDDocument( @Nullable final String originSDDocument )
    {
        rememberChangedField("OriginSDDocument", this.originSDDocument);
        this.originSDDocument = originSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginSDDocumentItem</b>
     * </p>
     *
     * @param originSDDocumentItem
     *            Originating Item
     */
    public void setOriginSDDocumentItem( @Nullable final String originSDDocumentItem )
    {
        rememberChangedField("OriginSDDocumentItem", this.originSDDocumentItem);
        this.originSDDocumentItem = originSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @param matlAccountAssignmentGroup
     *            Account Assignment Group for Material
     */
    public void setMatlAccountAssignmentGroup( @Nullable final String matlAccountAssignmentGroup )
    {
        rememberChangedField("MatlAccountAssignmentGroup", this.matlAccountAssignmentGroup);
        this.matlAccountAssignmentGroup = matlAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Reference Document Category
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSDDocumentCategory</b>
     * </p>
     *
     * @param salesSDDocumentCategory
     *            Sales Document Category
     */
    public void setSalesSDDocumentCategory( @Nullable final String salesSDDocumentCategory )
    {
        rememberChangedField("SalesSDDocumentCategory", this.salesSDDocumentCategory);
        this.salesSDDocumentCategory = salesSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentItemInPartSgmt</b>
     * </p>
     *
     * @param billingDocumentItemInPartSgmt
     *            Item Number in the Partner Segment
     */
    public void setBillingDocumentItemInPartSgmt( @Nullable final String billingDocumentItemInPartSgmt )
    {
        rememberChangedField("BillingDocumentItemInPartSgmt", this.billingDocumentItemInPartSgmt);
        this.billingDocumentItemInPartSgmt = billingDocumentItemInPartSgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocument</b>
     * </p>
     *
     * @param externalReferenceDocument
     *            External Reference Document
     */
    public void setExternalReferenceDocument( @Nullable final String externalReferenceDocument )
    {
        rememberChangedField("ExternalReferenceDocument", this.externalReferenceDocument);
        this.externalReferenceDocument = externalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocumentItem</b>
     * </p>
     *
     * @param externalReferenceDocumentItem
     *            External Reference Document Item
     */
    public void setExternalReferenceDocumentItem( @Nullable final String externalReferenceDocumentItem )
    {
        rememberChangedField("ExternalReferenceDocumentItem", this.externalReferenceDocumentItem);
        this.externalReferenceDocumentItem = externalReferenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @param additionalCustomerGroup1
     *            Customer Group 1
     */
    public void setAdditionalCustomerGroup1( @Nullable final String additionalCustomerGroup1 )
    {
        rememberChangedField("AdditionalCustomerGroup1", this.additionalCustomerGroup1);
        this.additionalCustomerGroup1 = additionalCustomerGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @param additionalCustomerGroup2
     *            Customer Group 2
     */
    public void setAdditionalCustomerGroup2( @Nullable final String additionalCustomerGroup2 )
    {
        rememberChangedField("AdditionalCustomerGroup2", this.additionalCustomerGroup2);
        this.additionalCustomerGroup2 = additionalCustomerGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @param additionalCustomerGroup3
     *            Customer Group 3
     */
    public void setAdditionalCustomerGroup3( @Nullable final String additionalCustomerGroup3 )
    {
        rememberChangedField("AdditionalCustomerGroup3", this.additionalCustomerGroup3);
        this.additionalCustomerGroup3 = additionalCustomerGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @param additionalCustomerGroup4
     *            Customer Group 4
     */
    public void setAdditionalCustomerGroup4( @Nullable final String additionalCustomerGroup4 )
    {
        rememberChangedField("AdditionalCustomerGroup4", this.additionalCustomerGroup4);
        this.additionalCustomerGroup4 = additionalCustomerGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @param additionalCustomerGroup5
     *            Customer Group 5
     */
    public void setAdditionalCustomerGroup5( @Nullable final String additionalCustomerGroup5 )
    {
        rememberChangedField("AdditionalCustomerGroup5", this.additionalCustomerGroup5);
        this.additionalCustomerGroup5 = additionalCustomerGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetailPromotion</b>
     * </p>
     *
     * @param retailPromotion
     *            Retail Promotion
     */
    public void setRetailPromotion( @Nullable final String retailPromotion )
    {
        rememberChangedField("RetailPromotion", this.retailPromotion);
        this.retailPromotion = retailPromotion;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RebateBasisAmount</b>
     * </p>
     *
     * @param rebateBasisAmount
     *            Rebate Basis 1
     */
    public void setRebateBasisAmount( @Nullable final BigDecimal rebateBasisAmount )
    {
        rememberChangedField("RebateBasisAmount", this.rebateBasisAmount);
        this.rebateBasisAmount = rebateBasisAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @param volumeRebateGroup
     *            Volume rebate group
     */
    public void setVolumeRebateGroup( @Nullable final String volumeRebateGroup )
    {
        rememberChangedField("VolumeRebateGroup", this.volumeRebateGroup);
        this.volumeRebateGroup = volumeRebateGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsRelevantForCredit</b>
     * </p>
     *
     * @param itemIsRelevantForCredit
     *            ID: Item with active credit function / relevant for credit
     */
    public void setItemIsRelevantForCredit( @Nullable final Boolean itemIsRelevantForCredit )
    {
        rememberChangedField("ItemIsRelevantForCredit", this.itemIsRelevantForCredit);
        this.itemIsRelevantForCredit = itemIsRelevantForCredit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditRelatedPrice</b>
     * </p>
     *
     * @param creditRelatedPrice
     *            Item credit price
     */
    public void setCreditRelatedPrice( @Nullable final BigDecimal creditRelatedPrice )
    {
        rememberChangedField("CreditRelatedPrice", this.creditRelatedPrice);
        this.creditRelatedPrice = creditRelatedPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDeal</b>
     * </p>
     *
     * @param salesDeal
     *            Sales Deal
     */
    public void setSalesDeal( @Nullable final String salesDeal )
    {
        rememberChangedField("SalesDeal", this.salesDeal);
        this.salesDeal = salesDeal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesPromotion</b>
     * </p>
     *
     * @param salesPromotion
     *            Promotion
     */
    public void setSalesPromotion( @Nullable final String salesPromotion )
    {
        rememberChangedField("SalesPromotion", this.salesPromotion);
        this.salesPromotion = salesPromotion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesDistrict</b>
     * </p>
     *
     * @param salesOrderSalesDistrict
     *            Sales district of sales order
     */
    public void setSalesOrderSalesDistrict( @Nullable final String salesOrderSalesDistrict )
    {
        rememberChangedField("SalesOrderSalesDistrict", this.salesOrderSalesDistrict);
        this.salesOrderSalesDistrict = salesOrderSalesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderCustomerGroup</b>
     * </p>
     *
     * @param salesOrderCustomerGroup
     *            Customer group of sales order
     */
    public void setSalesOrderCustomerGroup( @Nullable final String salesOrderCustomerGroup )
    {
        rememberChangedField("SalesOrderCustomerGroup", this.salesOrderCustomerGroup);
        this.salesOrderCustomerGroup = salesOrderCustomerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderCustomerPriceGroup</b>
     * </p>
     *
     * @param salesOrderCustomerPriceGroup
     *            Price group of sales order
     */
    public void setSalesOrderCustomerPriceGroup( @Nullable final String salesOrderCustomerPriceGroup )
    {
        rememberChangedField("SalesOrderCustomerPriceGroup", this.salesOrderCustomerPriceGroup);
        this.salesOrderCustomerPriceGroup = salesOrderCustomerPriceGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderPriceListType</b>
     * </p>
     *
     * @param salesOrderPriceListType
     *            Price list type of sales order
     */
    public void setSalesOrderPriceListType( @Nullable final String salesOrderPriceListType )
    {
        rememberChangedField("SalesOrderPriceListType", this.salesOrderPriceListType);
        this.salesOrderPriceListType = salesOrderPriceListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesOrganization</b>
     * </p>
     *
     * @param salesOrderSalesOrganization
     *            Sales organization of sales order
     */
    public void setSalesOrderSalesOrganization( @Nullable final String salesOrderSalesOrganization )
    {
        rememberChangedField("SalesOrderSalesOrganization", this.salesOrderSalesOrganization);
        this.salesOrderSalesOrganization = salesOrderSalesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDistributionChannel</b>
     * </p>
     *
     * @param salesOrderDistributionChannel
     *            Distribution channel of sales order
     */
    public void setSalesOrderDistributionChannel( @Nullable final String salesOrderDistributionChannel )
    {
        rememberChangedField("SalesOrderDistributionChannel", this.salesOrderDistributionChannel);
        this.salesOrderDistributionChannel = salesOrderDistributionChannel;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocIsCreatedFromReference</b>
     * </p>
     *
     * @param salesDocIsCreatedFromReference
     *            Sales document was created from reference
     */
    public void setSalesDocIsCreatedFromReference( @Nullable final Boolean salesDocIsCreatedFromReference )
    {
        rememberChangedField("SalesDocIsCreatedFromReference", this.salesDocIsCreatedFromReference);
        this.salesDocIsCreatedFromReference = salesDocIsCreatedFromReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @param higherLevelItemUsage
     *            ID for higher-level item usage
     */
    public void setHigherLevelItemUsage( @Nullable final String higherLevelItemUsage )
    {
        rememberChangedField("HigherLevelItemUsage", this.higherLevelItemUsage);
        this.higherLevelItemUsage = higherLevelItemUsage;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocument", getBillingDocument());
        result.put("BillingDocumentItem", getBillingDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocument", getBillingDocument());
        values.put("BillingDocumentItem", getBillingDocumentItem());
        values.put("SalesDocumentItemCategory", getSalesDocumentItemCategory());
        values.put("SalesDocumentItemType", getSalesDocumentItemType());
        values.put("ReturnItemProcessingType", getReturnItemProcessingType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("ReferenceLogicalSystem", getReferenceLogicalSystem());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("Material", getMaterial());
        values.put("OriginallyRequestedMaterial", getOriginallyRequestedMaterial());
        values.put("InternationalArticleNumber", getInternationalArticleNumber());
        values.put("PricingReferenceMaterial", getPricingReferenceMaterial());
        values.put("Batch", getBatch());
        values.put("ProductHierarchyNode", getProductHierarchyNode());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("AdditionalMaterialGroup1", getAdditionalMaterialGroup1());
        values.put("AdditionalMaterialGroup2", getAdditionalMaterialGroup2());
        values.put("AdditionalMaterialGroup3", getAdditionalMaterialGroup3());
        values.put("AdditionalMaterialGroup4", getAdditionalMaterialGroup4());
        values.put("AdditionalMaterialGroup5", getAdditionalMaterialGroup5());
        values.put("MaterialCommissionGroup", getMaterialCommissionGroup());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ReplacementPartType", getReplacementPartType());
        values.put("MaterialGroupHierarchy1", getMaterialGroupHierarchy1());
        values.put("MaterialGroupHierarchy2", getMaterialGroupHierarchy2());
        values.put("PlantRegion", getPlantRegion());
        values.put("PlantCounty", getPlantCounty());
        values.put("PlantCity", getPlantCity());
        values.put("BOMExplosion", getBOMExplosion());
        values.put("MaterialDeterminationType", getMaterialDeterminationType());
        values.put("BillingDocumentItemText", getBillingDocumentItemText());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        values.put("BillingQuantity", getBillingQuantity());
        values.put("BillingQuantityUnit", getBillingQuantityUnit());
        values.put("BillingQuantityInBaseUnit", getBillingQuantityInBaseUnit());
        values.put("BaseUnit", getBaseUnit());
        values.put("MRPRequiredQuantityInBaseUnit", getMRPRequiredQuantityInBaseUnit());
        values.put("BillingToBaseQuantityDnmntr", getBillingToBaseQuantityDnmntr());
        values.put("BillingToBaseQuantityNmrtr", getBillingToBaseQuantityNmrtr());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("BillToPartyCountry", getBillToPartyCountry());
        values.put("BillToPartyRegion", getBillToPartyRegion());
        values.put("BillingPlanRule", getBillingPlanRule());
        values.put("BillingPlan", getBillingPlan());
        values.put("BillingPlanItem", getBillingPlanItem());
        values.put("NetAmount", getNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("GrossAmount", getGrossAmount());
        values.put("PricingDate", getPricingDate());
        values.put("AbsltPriceDetnExchangeRate", getAbsltPriceDetnExchangeRate());
        values.put("PriceDetnExchRateIsIndrctQtan", getPriceDetnExchRateIsIndrctQtan());
        values.put("PriceDetnExchangeRateDate", getPriceDetnExchangeRateDate());
        values.put("PricingScaleQuantityInBaseUnit", getPricingScaleQuantityInBaseUnit());
        values.put("TaxAmount", getTaxAmount());
        values.put("CostAmount", getCostAmount());
        values.put("Subtotal1Amount", getSubtotal1Amount());
        values.put("Subtotal2Amount", getSubtotal2Amount());
        values.put("Subtotal3Amount", getSubtotal3Amount());
        values.put("Subtotal4Amount", getSubtotal4Amount());
        values.put("Subtotal5Amount", getSubtotal5Amount());
        values.put("Subtotal6Amount", getSubtotal6Amount());
        values.put("StatisticalValueControl", getStatisticalValueControl());
        values.put("CashDiscountIsDeductible", getCashDiscountIsDeductible());
        values.put("CustomerConditionGroup1", getCustomerConditionGroup1());
        values.put("CustomerConditionGroup2", getCustomerConditionGroup2());
        values.put("CustomerConditionGroup3", getCustomerConditionGroup3());
        values.put("CustomerConditionGroup4", getCustomerConditionGroup4());
        values.put("CustomerConditionGroup5", getCustomerConditionGroup5());
        values.put("ManualPriceChangeType", getManualPriceChangeType());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("AbsltStatisticsExchangeRate", getAbsltStatisticsExchangeRate());
        values.put("StatisticsExchRateIsIndrctQtan", getStatisticsExchRateIsIndrctQtan());
        values.put("MainItemPricingRefMaterial", getMainItemPricingRefMaterial());
        values.put("MainItemMaterialPricingGroup", getMainItemMaterialPricingGroup());
        values.put("DepartureCountry", getDepartureCountry());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("ZeroVATRsn", getZeroVATRsn());
        values.put("EligibleAmountForCashDiscount", getEligibleAmountForCashDiscount());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("WBSElement", getWBSElement());
        values.put("ControllingArea", getControllingArea());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("OrderID", getOrderID());
        values.put("CostCenter", getCostCenter());
        values.put("OriginSDDocument", getOriginSDDocument());
        values.put("OriginSDDocumentItem", getOriginSDDocumentItem());
        values.put("MatlAccountAssignmentGroup", getMatlAccountAssignmentGroup());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("SalesSDDocumentCategory", getSalesSDDocumentCategory());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("BillingDocumentItemInPartSgmt", getBillingDocumentItemInPartSgmt());
        values.put("ExternalReferenceDocument", getExternalReferenceDocument());
        values.put("ExternalReferenceDocumentItem", getExternalReferenceDocumentItem());
        values.put("SalesGroup", getSalesGroup());
        values.put("AdditionalCustomerGroup1", getAdditionalCustomerGroup1());
        values.put("AdditionalCustomerGroup2", getAdditionalCustomerGroup2());
        values.put("AdditionalCustomerGroup3", getAdditionalCustomerGroup3());
        values.put("AdditionalCustomerGroup4", getAdditionalCustomerGroup4());
        values.put("AdditionalCustomerGroup5", getAdditionalCustomerGroup5());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("RetailPromotion", getRetailPromotion());
        values.put("RebateBasisAmount", getRebateBasisAmount());
        values.put("VolumeRebateGroup", getVolumeRebateGroup());
        values.put("ItemIsRelevantForCredit", getItemIsRelevantForCredit());
        values.put("CreditRelatedPrice", getCreditRelatedPrice());
        values.put("SalesDeal", getSalesDeal());
        values.put("SalesPromotion", getSalesPromotion());
        values.put("SalesOrderSalesDistrict", getSalesOrderSalesDistrict());
        values.put("SalesOrderCustomerGroup", getSalesOrderCustomerGroup());
        values.put("SalesOrderCustomerPriceGroup", getSalesOrderCustomerPriceGroup());
        values.put("SalesOrderPriceListType", getSalesOrderPriceListType());
        values.put("SalesOrderSalesOrganization", getSalesOrderSalesOrganization());
        values.put("SalesOrderDistributionChannel", getSalesOrderDistributionChannel());
        values.put("SalesDocIsCreatedFromReference", getSalesDocIsCreatedFromReference());
        values.put("ShippingPoint", getShippingPoint());
        values.put("HigherLevelItemUsage", getHigherLevelItemUsage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentItem") ) {
                final Object value = values.remove("BillingDocumentItem");
                if( (value == null) || (!value.equals(getBillingDocumentItem())) ) {
                    setBillingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItemCategory") ) {
                final Object value = values.remove("SalesDocumentItemCategory");
                if( (value == null) || (!value.equals(getSalesDocumentItemCategory())) ) {
                    setSalesDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItemType") ) {
                final Object value = values.remove("SalesDocumentItemType");
                if( (value == null) || (!value.equals(getSalesDocumentItemType())) ) {
                    setSalesDocumentItemType(((String) value));
                }
            }
            if( values.containsKey("ReturnItemProcessingType") ) {
                final Object value = values.remove("ReturnItemProcessingType");
                if( (value == null) || (!value.equals(getReturnItemProcessingType())) ) {
                    setReturnItemProcessingType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ReferenceLogicalSystem") ) {
                final Object value = values.remove("ReferenceLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceLogicalSystem())) ) {
                    setReferenceLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OriginallyRequestedMaterial") ) {
                final Object value = values.remove("OriginallyRequestedMaterial");
                if( (value == null) || (!value.equals(getOriginallyRequestedMaterial())) ) {
                    setOriginallyRequestedMaterial(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumber") ) {
                final Object value = values.remove("InternationalArticleNumber");
                if( (value == null) || (!value.equals(getInternationalArticleNumber())) ) {
                    setInternationalArticleNumber(((String) value));
                }
            }
            if( values.containsKey("PricingReferenceMaterial") ) {
                final Object value = values.remove("PricingReferenceMaterial");
                if( (value == null) || (!value.equals(getPricingReferenceMaterial())) ) {
                    setPricingReferenceMaterial(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("ProductHierarchyNode") ) {
                final Object value = values.remove("ProductHierarchyNode");
                if( (value == null) || (!value.equals(getProductHierarchyNode())) ) {
                    setProductHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup1") ) {
                final Object value = values.remove("AdditionalMaterialGroup1");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup1())) ) {
                    setAdditionalMaterialGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup2") ) {
                final Object value = values.remove("AdditionalMaterialGroup2");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup2())) ) {
                    setAdditionalMaterialGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup3") ) {
                final Object value = values.remove("AdditionalMaterialGroup3");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup3())) ) {
                    setAdditionalMaterialGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup4") ) {
                final Object value = values.remove("AdditionalMaterialGroup4");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup4())) ) {
                    setAdditionalMaterialGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup5") ) {
                final Object value = values.remove("AdditionalMaterialGroup5");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup5())) ) {
                    setAdditionalMaterialGroup5(((String) value));
                }
            }
            if( values.containsKey("MaterialCommissionGroup") ) {
                final Object value = values.remove("MaterialCommissionGroup");
                if( (value == null) || (!value.equals(getMaterialCommissionGroup())) ) {
                    setMaterialCommissionGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ReplacementPartType") ) {
                final Object value = values.remove("ReplacementPartType");
                if( (value == null) || (!value.equals(getReplacementPartType())) ) {
                    setReplacementPartType(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupHierarchy1") ) {
                final Object value = values.remove("MaterialGroupHierarchy1");
                if( (value == null) || (!value.equals(getMaterialGroupHierarchy1())) ) {
                    setMaterialGroupHierarchy1(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupHierarchy2") ) {
                final Object value = values.remove("MaterialGroupHierarchy2");
                if( (value == null) || (!value.equals(getMaterialGroupHierarchy2())) ) {
                    setMaterialGroupHierarchy2(((String) value));
                }
            }
            if( values.containsKey("PlantRegion") ) {
                final Object value = values.remove("PlantRegion");
                if( (value == null) || (!value.equals(getPlantRegion())) ) {
                    setPlantRegion(((String) value));
                }
            }
            if( values.containsKey("PlantCounty") ) {
                final Object value = values.remove("PlantCounty");
                if( (value == null) || (!value.equals(getPlantCounty())) ) {
                    setPlantCounty(((String) value));
                }
            }
            if( values.containsKey("PlantCity") ) {
                final Object value = values.remove("PlantCity");
                if( (value == null) || (!value.equals(getPlantCity())) ) {
                    setPlantCity(((String) value));
                }
            }
            if( values.containsKey("BOMExplosion") ) {
                final Object value = values.remove("BOMExplosion");
                if( (value == null) || (!value.equals(getBOMExplosion())) ) {
                    setBOMExplosion(((String) value));
                }
            }
            if( values.containsKey("MaterialDeterminationType") ) {
                final Object value = values.remove("MaterialDeterminationType");
                if( (value == null) || (!value.equals(getMaterialDeterminationType())) ) {
                    setMaterialDeterminationType(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentItemText") ) {
                final Object value = values.remove("BillingDocumentItemText");
                if( (value == null) || (!value.equals(getBillingDocumentItemText())) ) {
                    setBillingDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingQuantity") ) {
                final Object value = values.remove("BillingQuantity");
                if( (value == null) || (!value.equals(getBillingQuantity())) ) {
                    setBillingQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingQuantityUnit") ) {
                final Object value = values.remove("BillingQuantityUnit");
                if( (value == null) || (!value.equals(getBillingQuantityUnit())) ) {
                    setBillingQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BillingQuantityInBaseUnit") ) {
                final Object value = values.remove("BillingQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getBillingQuantityInBaseUnit())) ) {
                    setBillingQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("MRPRequiredQuantityInBaseUnit") ) {
                final Object value = values.remove("MRPRequiredQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getMRPRequiredQuantityInBaseUnit())) ) {
                    setMRPRequiredQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingToBaseQuantityDnmntr") ) {
                final Object value = values.remove("BillingToBaseQuantityDnmntr");
                if( (value == null) || (!value.equals(getBillingToBaseQuantityDnmntr())) ) {
                    setBillingToBaseQuantityDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingToBaseQuantityNmrtr") ) {
                final Object value = values.remove("BillingToBaseQuantityNmrtr");
                if( (value == null) || (!value.equals(getBillingToBaseQuantityNmrtr())) ) {
                    setBillingToBaseQuantityNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("BillToPartyCountry") ) {
                final Object value = values.remove("BillToPartyCountry");
                if( (value == null) || (!value.equals(getBillToPartyCountry())) ) {
                    setBillToPartyCountry(((String) value));
                }
            }
            if( values.containsKey("BillToPartyRegion") ) {
                final Object value = values.remove("BillToPartyRegion");
                if( (value == null) || (!value.equals(getBillToPartyRegion())) ) {
                    setBillToPartyRegion(((String) value));
                }
            }
            if( values.containsKey("BillingPlanRule") ) {
                final Object value = values.remove("BillingPlanRule");
                if( (value == null) || (!value.equals(getBillingPlanRule())) ) {
                    setBillingPlanRule(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItem") ) {
                final Object value = values.remove("BillingPlanItem");
                if( (value == null) || (!value.equals(getBillingPlanItem())) ) {
                    setBillingPlanItem(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("GrossAmount") ) {
                final Object value = values.remove("GrossAmount");
                if( (value == null) || (!value.equals(getGrossAmount())) ) {
                    setGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AbsltPriceDetnExchangeRate") ) {
                final Object value = values.remove("AbsltPriceDetnExchangeRate");
                if( (value == null) || (!value.equals(getAbsltPriceDetnExchangeRate())) ) {
                    setAbsltPriceDetnExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("PriceDetnExchRateIsIndrctQtan") ) {
                final Object value = values.remove("PriceDetnExchRateIsIndrctQtan");
                if( (value == null) || (!value.equals(getPriceDetnExchRateIsIndrctQtan())) ) {
                    setPriceDetnExchRateIsIndrctQtan(((Boolean) value));
                }
            }
            if( values.containsKey("PriceDetnExchangeRateDate") ) {
                final Object value = values.remove("PriceDetnExchangeRateDate");
                if( (value == null) || (!value.equals(getPriceDetnExchangeRateDate())) ) {
                    setPriceDetnExchangeRateDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PricingScaleQuantityInBaseUnit") ) {
                final Object value = values.remove("PricingScaleQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getPricingScaleQuantityInBaseUnit())) ) {
                    setPricingScaleQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostAmount") ) {
                final Object value = values.remove("CostAmount");
                if( (value == null) || (!value.equals(getCostAmount())) ) {
                    setCostAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal1Amount") ) {
                final Object value = values.remove("Subtotal1Amount");
                if( (value == null) || (!value.equals(getSubtotal1Amount())) ) {
                    setSubtotal1Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal2Amount") ) {
                final Object value = values.remove("Subtotal2Amount");
                if( (value == null) || (!value.equals(getSubtotal2Amount())) ) {
                    setSubtotal2Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal3Amount") ) {
                final Object value = values.remove("Subtotal3Amount");
                if( (value == null) || (!value.equals(getSubtotal3Amount())) ) {
                    setSubtotal3Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal4Amount") ) {
                final Object value = values.remove("Subtotal4Amount");
                if( (value == null) || (!value.equals(getSubtotal4Amount())) ) {
                    setSubtotal4Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal5Amount") ) {
                final Object value = values.remove("Subtotal5Amount");
                if( (value == null) || (!value.equals(getSubtotal5Amount())) ) {
                    setSubtotal5Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal6Amount") ) {
                final Object value = values.remove("Subtotal6Amount");
                if( (value == null) || (!value.equals(getSubtotal6Amount())) ) {
                    setSubtotal6Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("StatisticalValueControl") ) {
                final Object value = values.remove("StatisticalValueControl");
                if( (value == null) || (!value.equals(getStatisticalValueControl())) ) {
                    setStatisticalValueControl(((String) value));
                }
            }
            if( values.containsKey("CashDiscountIsDeductible") ) {
                final Object value = values.remove("CashDiscountIsDeductible");
                if( (value == null) || (!value.equals(getCashDiscountIsDeductible())) ) {
                    setCashDiscountIsDeductible(((Boolean) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup1") ) {
                final Object value = values.remove("CustomerConditionGroup1");
                if( (value == null) || (!value.equals(getCustomerConditionGroup1())) ) {
                    setCustomerConditionGroup1(((String) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup2") ) {
                final Object value = values.remove("CustomerConditionGroup2");
                if( (value == null) || (!value.equals(getCustomerConditionGroup2())) ) {
                    setCustomerConditionGroup2(((String) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup3") ) {
                final Object value = values.remove("CustomerConditionGroup3");
                if( (value == null) || (!value.equals(getCustomerConditionGroup3())) ) {
                    setCustomerConditionGroup3(((String) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup4") ) {
                final Object value = values.remove("CustomerConditionGroup4");
                if( (value == null) || (!value.equals(getCustomerConditionGroup4())) ) {
                    setCustomerConditionGroup4(((String) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup5") ) {
                final Object value = values.remove("CustomerConditionGroup5");
                if( (value == null) || (!value.equals(getCustomerConditionGroup5())) ) {
                    setCustomerConditionGroup5(((String) value));
                }
            }
            if( values.containsKey("ManualPriceChangeType") ) {
                final Object value = values.remove("ManualPriceChangeType");
                if( (value == null) || (!value.equals(getManualPriceChangeType())) ) {
                    setManualPriceChangeType(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("AbsltStatisticsExchangeRate") ) {
                final Object value = values.remove("AbsltStatisticsExchangeRate");
                if( (value == null) || (!value.equals(getAbsltStatisticsExchangeRate())) ) {
                    setAbsltStatisticsExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("StatisticsExchRateIsIndrctQtan") ) {
                final Object value = values.remove("StatisticsExchRateIsIndrctQtan");
                if( (value == null) || (!value.equals(getStatisticsExchRateIsIndrctQtan())) ) {
                    setStatisticsExchRateIsIndrctQtan(((Boolean) value));
                }
            }
            if( values.containsKey("MainItemPricingRefMaterial") ) {
                final Object value = values.remove("MainItemPricingRefMaterial");
                if( (value == null) || (!value.equals(getMainItemPricingRefMaterial())) ) {
                    setMainItemPricingRefMaterial(((String) value));
                }
            }
            if( values.containsKey("MainItemMaterialPricingGroup") ) {
                final Object value = values.remove("MainItemMaterialPricingGroup");
                if( (value == null) || (!value.equals(getMainItemMaterialPricingGroup())) ) {
                    setMainItemMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("DepartureCountry") ) {
                final Object value = values.remove("DepartureCountry");
                if( (value == null) || (!value.equals(getDepartureCountry())) ) {
                    setDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("ZeroVATRsn") ) {
                final Object value = values.remove("ZeroVATRsn");
                if( (value == null) || (!value.equals(getZeroVATRsn())) ) {
                    setZeroVATRsn(((String) value));
                }
            }
            if( values.containsKey("EligibleAmountForCashDiscount") ) {
                final Object value = values.remove("EligibleAmountForCashDiscount");
                if( (value == null) || (!value.equals(getEligibleAmountForCashDiscount())) ) {
                    setEligibleAmountForCashDiscount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("OriginSDDocument") ) {
                final Object value = values.remove("OriginSDDocument");
                if( (value == null) || (!value.equals(getOriginSDDocument())) ) {
                    setOriginSDDocument(((String) value));
                }
            }
            if( values.containsKey("OriginSDDocumentItem") ) {
                final Object value = values.remove("OriginSDDocumentItem");
                if( (value == null) || (!value.equals(getOriginSDDocumentItem())) ) {
                    setOriginSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MatlAccountAssignmentGroup") ) {
                final Object value = values.remove("MatlAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getMatlAccountAssignmentGroup())) ) {
                    setMatlAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesSDDocumentCategory") ) {
                final Object value = values.remove("SalesSDDocumentCategory");
                if( (value == null) || (!value.equals(getSalesSDDocumentCategory())) ) {
                    setSalesSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentItemInPartSgmt") ) {
                final Object value = values.remove("BillingDocumentItemInPartSgmt");
                if( (value == null) || (!value.equals(getBillingDocumentItemInPartSgmt())) ) {
                    setBillingDocumentItemInPartSgmt(((String) value));
                }
            }
            if( values.containsKey("ExternalReferenceDocument") ) {
                final Object value = values.remove("ExternalReferenceDocument");
                if( (value == null) || (!value.equals(getExternalReferenceDocument())) ) {
                    setExternalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ExternalReferenceDocumentItem") ) {
                final Object value = values.remove("ExternalReferenceDocumentItem");
                if( (value == null) || (!value.equals(getExternalReferenceDocumentItem())) ) {
                    setExternalReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup1") ) {
                final Object value = values.remove("AdditionalCustomerGroup1");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup1())) ) {
                    setAdditionalCustomerGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup2") ) {
                final Object value = values.remove("AdditionalCustomerGroup2");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup2())) ) {
                    setAdditionalCustomerGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup3") ) {
                final Object value = values.remove("AdditionalCustomerGroup3");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup3())) ) {
                    setAdditionalCustomerGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup4") ) {
                final Object value = values.remove("AdditionalCustomerGroup4");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup4())) ) {
                    setAdditionalCustomerGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup5") ) {
                final Object value = values.remove("AdditionalCustomerGroup5");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup5())) ) {
                    setAdditionalCustomerGroup5(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("RetailPromotion") ) {
                final Object value = values.remove("RetailPromotion");
                if( (value == null) || (!value.equals(getRetailPromotion())) ) {
                    setRetailPromotion(((String) value));
                }
            }
            if( values.containsKey("RebateBasisAmount") ) {
                final Object value = values.remove("RebateBasisAmount");
                if( (value == null) || (!value.equals(getRebateBasisAmount())) ) {
                    setRebateBasisAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeRebateGroup") ) {
                final Object value = values.remove("VolumeRebateGroup");
                if( (value == null) || (!value.equals(getVolumeRebateGroup())) ) {
                    setVolumeRebateGroup(((String) value));
                }
            }
            if( values.containsKey("ItemIsRelevantForCredit") ) {
                final Object value = values.remove("ItemIsRelevantForCredit");
                if( (value == null) || (!value.equals(getItemIsRelevantForCredit())) ) {
                    setItemIsRelevantForCredit(((Boolean) value));
                }
            }
            if( values.containsKey("CreditRelatedPrice") ) {
                final Object value = values.remove("CreditRelatedPrice");
                if( (value == null) || (!value.equals(getCreditRelatedPrice())) ) {
                    setCreditRelatedPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesDeal") ) {
                final Object value = values.remove("SalesDeal");
                if( (value == null) || (!value.equals(getSalesDeal())) ) {
                    setSalesDeal(((String) value));
                }
            }
            if( values.containsKey("SalesPromotion") ) {
                final Object value = values.remove("SalesPromotion");
                if( (value == null) || (!value.equals(getSalesPromotion())) ) {
                    setSalesPromotion(((String) value));
                }
            }
            if( values.containsKey("SalesOrderSalesDistrict") ) {
                final Object value = values.remove("SalesOrderSalesDistrict");
                if( (value == null) || (!value.equals(getSalesOrderSalesDistrict())) ) {
                    setSalesOrderSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SalesOrderCustomerGroup") ) {
                final Object value = values.remove("SalesOrderCustomerGroup");
                if( (value == null) || (!value.equals(getSalesOrderCustomerGroup())) ) {
                    setSalesOrderCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOrderCustomerPriceGroup") ) {
                final Object value = values.remove("SalesOrderCustomerPriceGroup");
                if( (value == null) || (!value.equals(getSalesOrderCustomerPriceGroup())) ) {
                    setSalesOrderCustomerPriceGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOrderPriceListType") ) {
                final Object value = values.remove("SalesOrderPriceListType");
                if( (value == null) || (!value.equals(getSalesOrderPriceListType())) ) {
                    setSalesOrderPriceListType(((String) value));
                }
            }
            if( values.containsKey("SalesOrderSalesOrganization") ) {
                final Object value = values.remove("SalesOrderSalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrderSalesOrganization())) ) {
                    setSalesOrderSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrderDistributionChannel") ) {
                final Object value = values.remove("SalesOrderDistributionChannel");
                if( (value == null) || (!value.equals(getSalesOrderDistributionChannel())) ) {
                    setSalesOrderDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("SalesDocIsCreatedFromReference") ) {
                final Object value = values.remove("SalesDocIsCreatedFromReference");
                if( (value == null) || (!value.equals(getSalesDocIsCreatedFromReference())) ) {
                    setSalesDocIsCreatedFromReference(((Boolean) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItemUsage") ) {
                final Object value = values.remove("HigherLevelItemUsage");
                if( (value == null) || (!value.equals(getHigherLevelItemUsage())) ) {
                    setHigherLevelItemUsage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingDocument") ) {
                final Object value = (values).remove("to_BillingDocument");
                if( value instanceof Map ) {
                    if( toBillingDocument == null ) {
                        toBillingDocument = new BillingDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocument.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ItemText") ) {
                final Object value = (values).remove("to_ItemText");
                if( value instanceof Iterable ) {
                    if( toItemText == null ) {
                        toItemText = Lists.newArrayList();
                    } else {
                        toItemText = Lists.newArrayList(toItemText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentItemText entity;
                        if( toItemText.size() > i ) {
                            entity = toItemText.get(i);
                        } else {
                            entity = new BillingDocumentItemText();
                            toItemText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new BillingDocumentItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentItemPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new BillingDocumentItemPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingDocument != null ) {
            (values).put("to_BillingDocument", toBillingDocument);
        }
        if( toItemText != null ) {
            (values).put("to_ItemText", toItemText);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BillingDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument fetchBillingDocument()
    {
        return fetchFieldAsSingle("to_BillingDocument", BillingDocument.class);
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillingDocument</b>.
     * <p>
     * If the navigation property <b>to_BillingDocument</b> of a queried <b>BillingDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument getBillingDocumentOrFetch()
    {
        if( toBillingDocument == null ) {
            toBillingDocument = fetchBillingDocument();
        }
        return toBillingDocument;
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillingDocument</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingDocument</b> is already loaded, the result will
     *         contain the <b>BillingDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocument> getBillingDocumentIfPresent()
    {
        return Option.of(toBillingDocument);
    }

    /**
     * Overwrites the associated <b>BillingDocument</b> entity for the loaded navigation property
     * <b>to_BillingDocument</b>.
     *
     * @param value
     *            New <b>BillingDocument</b> entity.
     */
    public void setBillingDocument( final BillingDocument value )
    {
        toBillingDocument = value;
    }

    /**
     * Fetches the <b>BillingDocumentItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ItemText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemText> fetchItemText()
    {
        return fetchFieldAsList("to_ItemText", BillingDocumentItemText.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemText</b>.
     * <p>
     * If the navigation property <b>to_ItemText</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemText> getItemTextOrFetch()
    {
        if( toItemText == null ) {
            toItemText = fetchItemText();
        }
        return toItemText;
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemText</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ItemText</b> is already loaded, the result will contain
     *         the <b>BillingDocumentItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentItemText>> getItemTextIfPresent()
    {
        return Option.of(toItemText);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentItemText</b> entities for the loaded navigation property
     * <b>to_ItemText</b>.
     * <p>
     * If the navigation property <b>to_ItemText</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentItemText</b> entities.
     */
    public void setItemText( @Nonnull final List<BillingDocumentItemText> value )
    {
        if( toItemText == null ) {
            toItemText = Lists.newArrayList();
        }
        toItemText.clear();
        toItemText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_ItemText</b>.
     * <p>
     * If the navigation property <b>to_ItemText</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentItemText</b> entities.
     */
    public void addItemText( BillingDocumentItemText... entity )
    {
        if( toItemText == null ) {
            toItemText = Lists.newArrayList();
        }
        toItemText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocumentItemPartner</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", BillingDocumentItemPartner.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>BillingDocumentItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<BillingDocumentItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentItemPartner</b> entities.
     */
    public void addPartner( BillingDocumentItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocumentItemPrcgElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentItemPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", BillingDocumentItemPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentItemPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentItemPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>BillingDocumentItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>BillingDocumentItemPrcgElmnt</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentItemPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentItemPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentItemPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<BillingDocumentItemPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentItemPrcgElmnt</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentItemPrcgElmnt</b> entities.
     */
    public void addPricingElement( BillingDocumentItemPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentItem instances.
     *
     */
    public final static class BillingDocumentItemBuilder
    {

        private BillingDocument toBillingDocument;
        private String billingDocument = null;
        private List<BillingDocumentItemText> toItemText = Lists.newArrayList();
        private List<BillingDocumentItemPartner> toPartner = Lists.newArrayList();
        private List<BillingDocumentItemPrcgElmnt> toPricingElement = Lists.newArrayList();

        private BillingDocumentItem.BillingDocumentItemBuilder toBillingDocument( final BillingDocument value )
        {
            toBillingDocument = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingDocument</b> for <b>BillingDocumentItem</b> to single
         * <b>BillingDocument</b>.
         *
         * @param value
         *            The BillingDocument to build this BillingDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentItem.BillingDocumentItemBuilder billingDocument( final BillingDocument value )
        {
            return toBillingDocument(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingDocument</b>
         * </p>
         *
         * @param value
         *            The billingDocument to build this BillingDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentItem.BillingDocumentItemBuilder billingDocument( final String value )
        {
            billingDocument = value;
            return this;
        }

        private BillingDocumentItem.BillingDocumentItemBuilder toItemText( final List<BillingDocumentItemText> value )
        {
            toItemText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ItemText</b> for <b>BillingDocumentItem</b> to multiple
         * <b>BillingDocumentItemText</b>.
         *
         * @param value
         *            The BillingDocumentItemTexts to build this BillingDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentItem.BillingDocumentItemBuilder itemText( BillingDocumentItemText... value )
        {
            return toItemText(Lists.newArrayList(value));
        }

        private BillingDocumentItem.BillingDocumentItemBuilder toPartner( final List<BillingDocumentItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>BillingDocumentItem</b> to multiple
         * <b>BillingDocumentItemPartner</b>.
         *
         * @param value
         *            The BillingDocumentItemPartners to build this BillingDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentItem.BillingDocumentItemBuilder partner( BillingDocumentItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private BillingDocumentItem.BillingDocumentItemBuilder toPricingElement(
            final List<BillingDocumentItemPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentItem</b> to multiple
         * <b>BillingDocumentItemPrcgElmnt</b>.
         *
         * @param value
         *            The BillingDocumentItemPrcgElmnts to build this BillingDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentItem.BillingDocumentItemBuilder pricingElement( BillingDocumentItemPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

    }

}
