/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable.BillingDocumentItemTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
 * BillingDocumentItemText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BillingDocumentItemTextByKeyFluentHelper
    extends
    FluentHelperByKey<BillingDocumentItemTextByKeyFluentHelper, BillingDocumentItemText, BillingDocumentItemTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
     * BillingDocumentItemText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BillingDocumentItemText}
     * @param billingDocumentItem
     *            Billing Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BillingDocumentItemText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public BillingDocumentItemTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billingDocument,
        final String billingDocumentItem,
        final String language,
        final String longTextID )
    {
        super(servicePath, entityCollection);
        this.key.put("BillingDocument", billingDocument);
        this.key.put("BillingDocumentItem", billingDocumentItem);
        this.key.put("Language", language);
        this.key.put("LongTextID", longTextID);
    }

    @Override
    @Nonnull
    protected Class<BillingDocumentItemText> getEntityClass()
    {
        return BillingDocumentItemText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
