/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable.BillingDocumentPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocumentPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentPartner extends VdmEntity<BillingDocumentPartner>
{

    /**
     * Selector for all available fields of BillingDocumentPartner.
     *
     */
    public final static BillingDocumentPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @Key
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> BILLING_DOCUMENT =
        new BillingDocumentPartnerField<String>("BillingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> PARTNER_FUNCTION =
        new BillingDocumentPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> CUSTOMER =
        new BillingDocumentPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> SUPPLIER =
        new BillingDocumentPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> PERSONNEL =
        new BillingDocumentPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BillingDocumentPartnerField<String> CONTACT_PERSON =
        new BillingDocumentPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_BillingDocument</b> for <b>BillingDocumentPartner</b> to single <b>BillingDocument</b>.
     *
     */
    @SerializedName( "to_BillingDocument" )
    @JsonProperty( "to_BillingDocument" )
    @ODataField( odataName = "to_BillingDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocument toBillingDocument;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingDocument</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentPartnerOneToOneLink<BillingDocument> TO_BILLING_DOCUMENT =
        new BillingDocumentPartnerOneToOneLink<BillingDocument>("to_BillingDocument");

    @Nonnull
    @Override
    public Class<BillingDocumentPartner> getType()
    {
        return BillingDocumentPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocumentPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocument", getBillingDocument());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocument", getBillingDocument());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingDocument") ) {
                final Object value = (values).remove("to_BillingDocument");
                if( value instanceof Map ) {
                    if( toBillingDocument == null ) {
                        toBillingDocument = new BillingDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocument.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingDocument != null ) {
            (values).put("to_BillingDocument", toBillingDocument);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BillingDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument fetchBillingDocument()
    {
        return fetchFieldAsSingle("to_BillingDocument", BillingDocument.class);
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillingDocument</b>.
     * <p>
     * If the navigation property <b>to_BillingDocument</b> of a queried <b>BillingDocumentPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument getBillingDocumentOrFetch()
    {
        if( toBillingDocument == null ) {
            toBillingDocument = fetchBillingDocument();
        }
        return toBillingDocument;
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillingDocument</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingDocument</b> is already loaded, the result will
     *         contain the <b>BillingDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocument> getBillingDocumentIfPresent()
    {
        return Option.of(toBillingDocument);
    }

    /**
     * Overwrites the associated <b>BillingDocument</b> entity for the loaded navigation property
     * <b>to_BillingDocument</b>.
     *
     * @param value
     *            New <b>BillingDocument</b> entity.
     */
    public void setBillingDocument( final BillingDocument value )
    {
        toBillingDocument = value;
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentPartner instances.
     *
     */
    public final static class BillingDocumentPartnerBuilder
    {

        private BillingDocument toBillingDocument;
        private String billingDocument = null;

        private BillingDocumentPartner.BillingDocumentPartnerBuilder toBillingDocument( final BillingDocument value )
        {
            toBillingDocument = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingDocument</b> for <b>BillingDocumentPartner</b> to single
         * <b>BillingDocument</b>.
         *
         * @param value
         *            The BillingDocument to build this BillingDocumentPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentPartner.BillingDocumentPartnerBuilder billingDocument( final BillingDocument value )
        {
            return toBillingDocument(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingDocument</b>
         * </p>
         *
         * @param value
         *            The billingDocument to build this BillingDocumentPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentPartner.BillingDocumentPartnerBuilder billingDocument( final String value )
        {
            billingDocument = value;
            return this;
        }

    }

}
