/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>GetPDFResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GetPDFResult extends VdmComplex<GetPDFResult>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>BillingDocumentBinary</b>
     * </p>
     *
     * @param billingDocumentBinary
     *
     */
    @SerializedName( "BillingDocumentBinary" )
    @JsonProperty( "BillingDocumentBinary" )
    @Nullable
    @ODataField( odataName = "BillingDocumentBinary" )
    private String billingDocumentBinary;

    @Nonnull
    @Override
    public Class<GetPDFResult> getType()
    {
        return GetPDFResult.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentBinary", getBillingDocumentBinary());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentBinary") ) {
                final Object value = values.remove("BillingDocumentBinary");
                if( (value == null) || (!value.equals(getBillingDocumentBinary())) ) {
                    setBillingDocumentBinary(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>BillingDocumentBinary</b>
     * </p>
     *
     * @param billingDocumentBinary
     *            The billingDocumentBinary to set.
     */
    public void setBillingDocumentBinary( @Nullable final String billingDocumentBinary )
    {
        rememberChangedField("BillingDocumentBinary", this.billingDocumentBinary);
        this.billingDocumentBinary = billingDocumentBinary;
    }

}
