/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BillingDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService BillingDocumentService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBillingDocumentServiceBatch
    extends
    BatchFluentHelperBasic<BillingDocumentServiceBatch, BillingDocumentServiceBatchChangeSet>
    implements
    BillingDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBillingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBillingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBillingDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillingDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBillingDocumentServiceBatchChangeSet(this, service);
    }

}
