/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BillingDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService BillingDocumentService}.
 *
 */
public class DefaultBillingDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillingDocumentServiceBatch, BillingDocumentServiceBatchChangeSet>
    implements
    BillingDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultBillingDocumentServiceBatchChangeSet(
        @Nonnull final DefaultBillingDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillingDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

}
