/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem BillingDocumentItem}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentItemField
 * BillingDocumentItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentItemLink
 * BillingDocumentItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_DOCUMENT_ITEM
 * BILLING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DOCUMENT_ITEM_CATEGORY
 * SALES_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DOCUMENT_ITEM_TYPE
 * SALES_DOCUMENT_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#RETURN_ITEM_PROCESSING_TYPE
 * RETURN_ITEM_PROCESSING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REFERENCE_LOGICAL_SYSTEM
 * REFERENCE_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ORIGINALLY_REQUESTED_MATERIAL
 * ORIGINALLY_REQUESTED_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#INTERNATIONAL_ARTICLE_NUMBER
 * INTERNATIONAL_ARTICLE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRICING_REFERENCE_MATERIAL
 * PRICING_REFERENCE_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_HIERARCHY_NODE
 * PRODUCT_HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_MATERIAL_GROUP1
 * ADDITIONAL_MATERIAL_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_MATERIAL_GROUP2
 * ADDITIONAL_MATERIAL_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_MATERIAL_GROUP3
 * ADDITIONAL_MATERIAL_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_MATERIAL_GROUP4
 * ADDITIONAL_MATERIAL_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_MATERIAL_GROUP5
 * ADDITIONAL_MATERIAL_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_COMMISSION_GROUP
 * MATERIAL_COMMISSION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REPLACEMENT_PART_TYPE
 * REPLACEMENT_PART_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_GROUP_HIERARCHY1
 * MATERIAL_GROUP_HIERARCHY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_GROUP_HIERARCHY2
 * MATERIAL_GROUP_HIERARCHY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PLANT_REGION
 * PLANT_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PLANT_COUNTY
 * PLANT_COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PLANT_CITY
 * PLANT_CITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BOM_EXPLOSION
 * BOM_EXPLOSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_DETERMINATION_TYPE
 * MATERIAL_DETERMINATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_DOCUMENT_ITEM_TEXT
 * BILLING_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SERVICES_RENDERED_DATE
 * SERVICES_RENDERED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_QUANTITY
 * BILLING_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_QUANTITY_UNIT
 * BILLING_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_QUANTITY_IN_BASE_UNIT
 * BILLING_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MRP_REQUIRED_QUANTITY_IN_BASE_UNIT
 * MRP_REQUIRED_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_TO_BASE_QUANTITY_DNMNTR
 * BILLING_TO_BASE_QUANTITY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_TO_BASE_QUANTITY_NMRTR
 * BILLING_TO_BASE_QUANTITY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILL_TO_PARTY_COUNTRY
 * BILL_TO_PARTY_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILL_TO_PARTY_REGION
 * BILL_TO_PARTY_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_PLAN_RULE
 * BILLING_PLAN_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_PLAN_ITEM
 * BILLING_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#GROSS_AMOUNT
 * GROSS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ABSLT_PRICE_DETN_EXCHANGE_RATE
 * ABSLT_PRICE_DETN_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN
 * PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRICE_DETN_EXCHANGE_RATE_DATE
 * PRICE_DETN_EXCHANGE_RATE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRICING_SCALE_QUANTITY_IN_BASE_UNIT
 * PRICING_SCALE_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TAX_AMOUNT
 * TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#COST_AMOUNT
 * COST_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL1_AMOUNT
 * SUBTOTAL1_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL2_AMOUNT
 * SUBTOTAL2_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL3_AMOUNT
 * SUBTOTAL3_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL4_AMOUNT
 * SUBTOTAL4_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL5_AMOUNT
 * SUBTOTAL5_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SUBTOTAL6_AMOUNT
 * SUBTOTAL6_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#STATISTICAL_VALUE_CONTROL
 * STATISTICAL_VALUE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CASH_DISCOUNT_IS_DEDUCTIBLE
 * CASH_DISCOUNT_IS_DEDUCTIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CUSTOMER_CONDITION_GROUP1
 * CUSTOMER_CONDITION_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CUSTOMER_CONDITION_GROUP2
 * CUSTOMER_CONDITION_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CUSTOMER_CONDITION_GROUP3
 * CUSTOMER_CONDITION_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CUSTOMER_CONDITION_GROUP4
 * CUSTOMER_CONDITION_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CUSTOMER_CONDITION_GROUP5
 * CUSTOMER_CONDITION_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MANUAL_PRICE_CHANGE_TYPE
 * MANUAL_PRICE_CHANGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATERIAL_PRICING_GROUP
 * MATERIAL_PRICING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ABSLT_STATISTICS_EXCHANGE_RATE
 * ABSLT_STATISTICS_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#STATISTICS_EXCH_RATE_IS_INDRCT_QTAN
 * STATISTICS_EXCH_RATE_IS_INDRCT_QTAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MAIN_ITEM_PRICING_REF_MATERIAL
 * MAIN_ITEM_PRICING_REF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MAIN_ITEM_MATERIAL_PRICING_GROUP
 * MAIN_ITEM_MATERIAL_PRICING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#DEPARTURE_COUNTRY
 * DEPARTURE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION1
 * PRODUCT_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION2
 * PRODUCT_TAX_CLASSIFICATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION3
 * PRODUCT_TAX_CLASSIFICATION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION4
 * PRODUCT_TAX_CLASSIFICATION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION5
 * PRODUCT_TAX_CLASSIFICATION5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION6
 * PRODUCT_TAX_CLASSIFICATION6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION7
 * PRODUCT_TAX_CLASSIFICATION7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION8
 * PRODUCT_TAX_CLASSIFICATION8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PRODUCT_TAX_CLASSIFICATION9
 * PRODUCT_TAX_CLASSIFICATION9}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ZERO_VAT_RSN
 * ZERO_VAT_RSN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ELIGIBLE_AMOUNT_FOR_CASH_DISCOUNT
 * ELIGIBLE_AMOUNT_FOR_CASH_DISCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ORIGIN_SD_DOCUMENT
 * ORIGIN_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ORIGIN_SD_DOCUMENT_ITEM
 * ORIGIN_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#MATL_ACCOUNT_ASSIGNMENT_GROUP
 * MATL_ACCOUNT_ASSIGNMENT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REFERENCE_SD_DOCUMENT_CATEGORY
 * REFERENCE_SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_SD_DOCUMENT_CATEGORY
 * SALES_SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#BILLING_DOCUMENT_ITEM_IN_PART_SGMT
 * BILLING_DOCUMENT_ITEM_IN_PART_SGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#EXTERNAL_REFERENCE_DOCUMENT
 * EXTERNAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#EXTERNAL_REFERENCE_DOCUMENT_ITEM
 * EXTERNAL_REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_CUSTOMER_GROUP1
 * ADDITIONAL_CUSTOMER_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_CUSTOMER_GROUP2
 * ADDITIONAL_CUSTOMER_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_CUSTOMER_GROUP3
 * ADDITIONAL_CUSTOMER_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_CUSTOMER_GROUP4
 * ADDITIONAL_CUSTOMER_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ADDITIONAL_CUSTOMER_GROUP5
 * ADDITIONAL_CUSTOMER_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#RETAIL_PROMOTION
 * RETAIL_PROMOTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#REBATE_BASIS_AMOUNT
 * REBATE_BASIS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#VOLUME_REBATE_GROUP
 * VOLUME_REBATE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#ITEM_IS_RELEVANT_FOR_CREDIT
 * ITEM_IS_RELEVANT_FOR_CREDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#CREDIT_RELATED_PRICE
 * CREDIT_RELATED_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DEAL
 * SALES_DEAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_PROMOTION
 * SALES_PROMOTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_SALES_DISTRICT
 * SALES_ORDER_SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_CUSTOMER_GROUP
 * SALES_ORDER_CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_CUSTOMER_PRICE_GROUP
 * SALES_ORDER_CUSTOMER_PRICE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_PRICE_LIST_TYPE
 * SALES_ORDER_PRICE_LIST_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_SALES_ORGANIZATION
 * SALES_ORDER_SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_ORDER_DISTRIBUTION_CHANNEL
 * SALES_ORDER_DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SALES_DOC_IS_CREATED_FROM_REFERENCE
 * SALES_DOC_IS_CREATED_FROM_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#HIGHER_LEVEL_ITEM_USAGE
 * HIGHER_LEVEL_ITEM_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TO_BILLING_DOCUMENT
 * TO_BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TO_ITEM_TEXT
 * TO_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * </ul>
 *
 */
public interface BillingDocumentItemSelectable extends EntitySelectable<BillingDocumentItem>
{

}
