/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
 * BillingDocumentItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentItemTextField
 * BillingDocumentItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentItemTextLink
 * BillingDocumentItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText#BILLING_DOCUMENT_ITEM
 * BILLING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface BillingDocumentItemTextSelectable extends EntitySelectable<BillingDocumentItemText>
{

}
