/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt
 * BillingDocumentPrcgElmnt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.field.BillingDocumentPrcgElmntField
 * BillingDocumentPrcgElmntField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.link.BillingDocumentPrcgElmntLink
 * BillingDocumentPrcgElmntLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRICING_DATE_TIME
 * PRICING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_BASE_VALUE
 * CONDITION_BASE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_CATEGORY
 * CONDITION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_IS_FOR_STATISTICS
 * CONDITION_IS_FOR_STATISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_ORIGIN
 * CONDITION_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#IS_GROUP_CONDITION
 * IS_GROUP_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CNDN_ROUNDING_OFF_DIFF_AMOUNT
 * CNDN_ROUNDING_OFF_DIFF_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_AMOUNT
 * CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_CONTROL
 * CONDITION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_CLASS
 * CONDITION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRCG_PROCEDURE_COUNTER_FOR_HEADER
 * PRCG_PROCEDURE_COUNTER_FOR_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#FACTOR_FOR_CONDITION_BASIS_VALUE
 * FACTOR_FOR_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#STRUCTURE_CONDITION
 * STRUCTURE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE
 * PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_SCALE_BASIS_VALUE
 * CONDITION_SCALE_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_SCALE_BASIS_UNIT
 * CONDITION_SCALE_BASIS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_SCALE_BASIS_CURRENCY
 * CONDITION_SCALE_BASIS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CNDN_IS_RELEVANT_FOR_INTCO_BILLING
 * CNDN_IS_RELEVANT_FOR_INTCO_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_IS_MANUALLY_CHANGED
 * CONDITION_IS_MANUALLY_CHANGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#CONDITION_IS_FOR_CONFIGURATION
 * CONDITION_IS_FOR_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#VARIANT_CONDITION
 * VARIANT_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt#TO_BILLING_DOCUMENT
 * TO_BILLING_DOCUMENT}</li>
 * </ul>
 *
 */
public interface BillingDocumentPrcgElmntSelectable extends EntitySelectable<BillingDocumentPrcgElmnt>
{

}
