/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.field.BillingDocReqItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocReqItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable.BillingDocReqItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocReqItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocReqItemPartner extends VdmEntity<BillingDocReqItemPartner>
{

    /**
     * Selector for all available fields of BillingDocReqItemPartner.
     *
     */
    public final static BillingDocReqItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @return Billing Document Request
     */
    @Key
    @SerializedName( "BillingDocumentRequest" )
    @JsonProperty( "BillingDocumentRequest" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequest" )
    private String billingDocumentRequest;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequest</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> BILLING_DOCUMENT_REQUEST =
        new BillingDocReqItemPartnerField<String>("BillingDocumentRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItem</b>
     * </p>
     *
     * @return Billing Document Request Item
     */
    @Key
    @SerializedName( "BillingDocumentRequestItem" )
    @JsonProperty( "BillingDocumentRequestItem" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequestItem" )
    private String billingDocumentRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequestItem</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> BILLING_DOCUMENT_REQUEST_ITEM =
        new BillingDocReqItemPartnerField<String>("BillingDocumentRequestItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> PARTNER_FUNCTION =
        new BillingDocReqItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> CUSTOMER =
        new BillingDocReqItemPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> SUPPLIER =
        new BillingDocReqItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> PERSONNEL =
        new BillingDocReqItemPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BillingDocReqItemPartnerField<String> CONTACT_PERSON =
        new BillingDocReqItemPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_BillingDocumentRequest</b> for <b>BillingDocReqItemPartner</b> to single
     * <b>BillingDocumentRequest</b>.
     *
     */
    @SerializedName( "to_BillingDocumentRequest" )
    @JsonProperty( "to_BillingDocumentRequest" )
    @ODataField( odataName = "to_BillingDocumentRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocumentRequest toBillingDocumentRequest;
    /**
     * Navigation property <b>to_BillingDocumentRequestItem</b> for <b>BillingDocReqItemPartner</b> to single
     * <b>BillingDocumentRequestItem</b>.
     *
     */
    @SerializedName( "to_BillingDocumentRequestItem" )
    @JsonProperty( "to_BillingDocumentRequestItem" )
    @ODataField( odataName = "to_BillingDocumentRequestItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocumentRequestItem toBillingDocumentRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingDocumentRequest</b> navigation property to query
     * operations.
     *
     */
    public final static BillingDocReqItemPartnerOneToOneLink<BillingDocumentRequest> TO_BILLING_DOCUMENT_REQUEST =
        new BillingDocReqItemPartnerOneToOneLink<BillingDocumentRequest>("to_BillingDocumentRequest");
    /**
     * Use with available fluent helpers to apply the <b>to_BillingDocumentRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static BillingDocReqItemPartnerOneToOneLink<BillingDocumentRequestItem> TO_BILLING_DOCUMENT_REQUEST_ITEM =
        new BillingDocReqItemPartnerOneToOneLink<BillingDocumentRequestItem>("to_BillingDocumentRequestItem");

    @Nonnull
    @Override
    public Class<BillingDocReqItemPartner> getType()
    {
        return BillingDocReqItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @param billingDocumentRequest
     *            Billing Document Request
     */
    public void setBillingDocumentRequest( @Nullable final String billingDocumentRequest )
    {
        rememberChangedField("BillingDocumentRequest", this.billingDocumentRequest);
        this.billingDocumentRequest = billingDocumentRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItem</b>
     * </p>
     *
     * @param billingDocumentRequestItem
     *            Billing Document Request Item
     */
    public void setBillingDocumentRequestItem( @Nullable final String billingDocumentRequestItem )
    {
        rememberChangedField("BillingDocumentRequestItem", this.billingDocumentRequestItem);
        this.billingDocumentRequestItem = billingDocumentRequestItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocReqItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocumentRequest", getBillingDocumentRequest());
        result.put("BillingDocumentRequestItem", getBillingDocumentRequestItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentRequest", getBillingDocumentRequest());
        values.put("BillingDocumentRequestItem", getBillingDocumentRequestItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentRequest") ) {
                final Object value = values.remove("BillingDocumentRequest");
                if( (value == null) || (!value.equals(getBillingDocumentRequest())) ) {
                    setBillingDocumentRequest(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentRequestItem") ) {
                final Object value = values.remove("BillingDocumentRequestItem");
                if( (value == null) || (!value.equals(getBillingDocumentRequestItem())) ) {
                    setBillingDocumentRequestItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingDocumentRequest") ) {
                final Object value = (values).remove("to_BillingDocumentRequest");
                if( value instanceof Map ) {
                    if( toBillingDocumentRequest == null ) {
                        toBillingDocumentRequest = new BillingDocumentRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocumentRequest.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BillingDocumentRequestItem") ) {
                final Object value = (values).remove("to_BillingDocumentRequestItem");
                if( value instanceof Map ) {
                    if( toBillingDocumentRequestItem == null ) {
                        toBillingDocumentRequestItem = new BillingDocumentRequestItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocumentRequestItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocReqItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocReqItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocReqItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocReqItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingDocumentRequest != null ) {
            (values).put("to_BillingDocumentRequest", toBillingDocumentRequest);
        }
        if( toBillingDocumentRequestItem != null ) {
            (values).put("to_BillingDocumentRequestItem", toBillingDocumentRequestItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentRequest</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocumentRequest</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequest fetchBillingDocumentRequest()
    {
        return fetchFieldAsSingle("to_BillingDocumentRequest", BillingDocumentRequest.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * If the navigation property <b>to_BillingDocumentRequest</b> of a queried <b>BillingDocReqItemPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequest getBillingDocumentRequestOrFetch()
    {
        if( toBillingDocumentRequest == null ) {
            toBillingDocumentRequest = fetchBillingDocumentRequest();
        }
        return toBillingDocumentRequest;
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocReqItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingDocumentRequest</b> is already loaded, the result
     *         will contain the <b>BillingDocumentRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocumentRequest> getBillingDocumentRequestIfPresent()
    {
        return Option.of(toBillingDocumentRequest);
    }

    /**
     * Overwrites the associated <b>BillingDocumentRequest</b> entity for the loaded navigation property
     * <b>to_BillingDocumentRequest</b>.
     *
     * @param value
     *            New <b>BillingDocumentRequest</b> entity.
     */
    public void setBillingDocumentRequest( final BillingDocumentRequest value )
    {
        toBillingDocumentRequest = value;
    }

    /**
     * Fetches the <b>BillingDocumentRequestItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BillingDocumentRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocumentRequestItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequestItem fetchBillingDocumentRequestItem()
    {
        return fetchFieldAsSingle("to_BillingDocumentRequestItem", BillingDocumentRequestItem.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequestItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingDocumentRequestItem</b> of a queried <b>BillingDocReqItemPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentRequestItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequestItem getBillingDocumentRequestItemOrFetch()
    {
        if( toBillingDocumentRequestItem == null ) {
            toBillingDocumentRequestItem = fetchBillingDocumentRequestItem();
        }
        return toBillingDocumentRequestItem;
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequestItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocReqItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingDocumentRequestItem</b> is already loaded, the
     *         result will contain the <b>BillingDocumentRequestItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocumentRequestItem> getBillingDocumentRequestItemIfPresent()
    {
        return Option.of(toBillingDocumentRequestItem);
    }

    /**
     * Overwrites the associated <b>BillingDocumentRequestItem</b> entity for the loaded navigation property
     * <b>to_BillingDocumentRequestItem</b>.
     *
     * @param value
     *            New <b>BillingDocumentRequestItem</b> entity.
     */
    public void setBillingDocumentRequestItem( final BillingDocumentRequestItem value )
    {
        toBillingDocumentRequestItem = value;
    }

    /**
     * Helper class to allow for fluent creation of BillingDocReqItemPartner instances.
     *
     */
    public final static class BillingDocReqItemPartnerBuilder
    {

        private BillingDocumentRequest toBillingDocumentRequest;
        private String billingDocumentRequest = null;
        private BillingDocumentRequestItem toBillingDocumentRequestItem;
        private String billingDocumentRequestItem = null;

        private BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder toBillingDocumentRequest(
            final BillingDocumentRequest value )
        {
            toBillingDocumentRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingDocumentRequest</b> for <b>BillingDocReqItemPartner</b> to single
         * <b>BillingDocumentRequest</b>.
         *
         * @param value
         *            The BillingDocumentRequest to build this BillingDocReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder billingDocumentRequest(
            final BillingDocumentRequest value )
        {
            return toBillingDocumentRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
         * </p>
         *
         * @param value
         *            The billingDocumentRequest to build this BillingDocReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder billingDocumentRequest( final String value )
        {
            billingDocumentRequest = value;
            return this;
        }

        private BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder toBillingDocumentRequestItem(
            final BillingDocumentRequestItem value )
        {
            toBillingDocumentRequestItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingDocumentRequestItem</b> for <b>BillingDocReqItemPartner</b> to single
         * <b>BillingDocumentRequestItem</b>.
         *
         * @param value
         *            The BillingDocumentRequestItem to build this BillingDocReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder billingDocumentRequestItem(
            final BillingDocumentRequestItem value )
        {
            return toBillingDocumentRequestItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>BillingDocumentRequestItem</b>
         * </p>
         *
         * @param value
         *            The billingDocumentRequestItem to build this BillingDocReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocReqItemPartner.BillingDocReqItemPartnerBuilder billingDocumentRequestItem( final String value )
        {
            billingDocumentRequestItem = value;
            return this;
        }

    }

}
