/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.field.BillingDocumentRequestField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocumentRequestLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable.BillingDocumentRequestSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Billing Document Request Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocumentRequestType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentRequest extends VdmEntity<BillingDocumentRequest>
{

    /**
     * Selector for all available fields of BillingDocumentRequest.
     *
     */
    public final static BillingDocumentRequestSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @return Billing Document Request
     */
    @Key
    @SerializedName( "BillingDocumentRequest" )
    @JsonProperty( "BillingDocumentRequest" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequest" )
    private String billingDocumentRequest;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequest</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> BILLING_DOCUMENT_REQUEST =
        new BillingDocumentRequestField<String>("BillingDocumentRequest");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestType</b>
     * </p>
     *
     * @return Billing Document Request Type
     */
    @SerializedName( "BillingDocumentRequestType" )
    @JsonProperty( "BillingDocumentRequestType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequestType" )
    private String billingDocumentRequestType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequestType</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> BILLING_DOCUMENT_REQUEST_TYPE =
        new BillingDocumentRequestField<String>("BillingDocumentRequestType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProposedBillingDocumentType</b>
     * </p>
     *
     * @return Proposed Billing Document Type
     */
    @SerializedName( "ProposedBillingDocumentType" )
    @JsonProperty( "ProposedBillingDocumentType" )
    @Nullable
    @ODataField( odataName = "ProposedBillingDocumentType" )
    private String proposedBillingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ProposedBillingDocumentType</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> PROPOSED_BILLING_DOCUMENT_TYPE =
        new BillingDocumentRequestField<String>("ProposedBillingDocumentType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<LocalDateTime> CREATION_DATE =
        new BillingDocumentRequestField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<LocalTime> CREATION_TIME =
        new BillingDocumentRequestField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<LocalDateTime> LAST_CHANGE_DATE =
        new BillingDocumentRequestField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BillingDocumentRequestField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> LOGICAL_SYSTEM =
        new BillingDocumentRequestField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> SALES_ORGANIZATION =
        new BillingDocumentRequestField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> DISTRIBUTION_CHANNEL =
        new BillingDocumentRequestField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> DIVISION =
        new BillingDocumentRequestField<String>("Division");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingDocumentDate" )
    @JsonProperty( "BillingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<LocalDateTime> BILLING_DOCUMENT_DATE =
        new BillingDocumentRequestField<LocalDateTime>("BillingDocumentDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<BigDecimal> TOTAL_NET_AMOUNT =
        new BillingDocumentRequestField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> TRANSACTION_CURRENCY =
        new BillingDocumentRequestField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalTaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TotalTaxAmount" )
    @JsonProperty( "TotalTaxAmount" )
    @Nullable
    @ODataField( odataName = "TotalTaxAmount" )
    private BigDecimal totalTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalTaxAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<BigDecimal> TOTAL_TAX_AMOUNT =
        new BillingDocumentRequestField<BigDecimal>("TotalTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     *
     * @return The totalGrossAmount contained in this entity.
     */
    @SerializedName( "TotalGrossAmount" )
    @JsonProperty( "TotalGrossAmount" )
    @Nullable
    @ODataField( odataName = "TotalGrossAmount" )
    private BigDecimal totalGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalGrossAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<BigDecimal> TOTAL_GROSS_AMOUNT =
        new BillingDocumentRequestField<BigDecimal>("TotalGrossAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @return Tax Departure Country/Region
     */
    @SerializedName( "TaxDepartureCountry" )
    @JsonProperty( "TaxDepartureCountry" )
    @Nullable
    @ODataField( odataName = "TaxDepartureCountry" )
    private String taxDepartureCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxDepartureCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> TAX_DEPARTURE_COUNTRY =
        new BillingDocumentRequestField<String>("TaxDepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> PAYER_PARTY =
        new BillingDocumentRequestField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @return Contract Account Number
     */
    @SerializedName( "ContractAccount" )
    @JsonProperty( "ContractAccount" )
    @Nullable
    @ODataField( odataName = "ContractAccount" )
    private String contractAccount;
    /**
     * Use with available fluent helpers to apply the <b>ContractAccount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> CONTRACT_ACCOUNT =
        new BillingDocumentRequestField<String>("ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> CUSTOMER_PAYMENT_TERMS =
        new BillingDocumentRequestField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> PAYMENT_METHOD =
        new BillingDocumentRequestField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate for each Payee
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> SEPA_MANDATE =
        new BillingDocumentRequestField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> COMPANY_CODE =
        new BillingDocumentRequestField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Source document of data contained in billing doc. request
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> REFERENCE_DOCUMENT =
        new BillingDocumentRequestField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @return Source system of the data contained in the billing doc. req.
     */
    @SerializedName( "ReferenceDocumentLogicalSystem" )
    @JsonProperty( "ReferenceDocumentLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentLogicalSystem" )
    private String referenceDocumentLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentLogicalSystem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> REFERENCE_DOCUMENT_LOGICAL_SYSTEM =
        new BillingDocumentRequestField<String>("ReferenceDocumentLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocSDDocCategory</b>
     * </p>
     *
     * @return Source Document Category
     */
    @SerializedName( "ReferenceDocSDDocCategory" )
    @JsonProperty( "ReferenceDocSDDocCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceDocSDDocCategory" )
    private String referenceDocSDDocCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocSDDocCategory</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> REFERENCE_DOC_SD_DOC_CATEGORY =
        new BillingDocumentRequestField<String>("ReferenceDocSDDocCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> SOLD_TO_PARTY =
        new BillingDocumentRequestField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new BillingDocumentRequestField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocument</b>
     * </p>
     *
     * @return Number of the Document Condition
     */
    @SerializedName( "PricingDocument" )
    @JsonProperty( "PricingDocument" )
    @Nullable
    @ODataField( odataName = "PricingDocument" )
    private String pricingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PricingDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> PRICING_DOCUMENT =
        new BillingDocumentRequestField<String>("PricingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingIssueType</b>
     * </p>
     *
     * @return Billing Issue Type
     */
    @SerializedName( "BillingIssueType" )
    @JsonProperty( "BillingIssueType" )
    @Nullable
    @ODataField( odataName = "BillingIssueType" )
    private String billingIssueType;
    /**
     * Use with available fluent helpers to apply the <b>BillingIssueType</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> BILLING_ISSUE_TYPE =
        new BillingDocumentRequestField<String>("BillingIssueType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> INCOTERMS_VERSION =
        new BillingDocumentRequestField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> INCOTERMS_CLASSIFICATION =
        new BillingDocumentRequestField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> INCOTERMS_TRANSFER_LOCATION =
        new BillingDocumentRequestField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> INCOTERMS_LOCATION1 =
        new BillingDocumentRequestField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> INCOTERMS_LOCATION2 =
        new BillingDocumentRequestField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingDocReqStatus</b>
     * </p>
     *
     * @return Billing Document Request Status
     */
    @SerializedName( "OverallBillingDocReqStatus" )
    @JsonProperty( "OverallBillingDocReqStatus" )
    @Nullable
    @ODataField( odataName = "OverallBillingDocReqStatus" )
    private String overallBillingDocReqStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallBillingDocReqStatus</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> OVERALL_BILLING_DOC_REQ_STATUS =
        new BillingDocumentRequestField<String>("OverallBillingDocReqStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPricingIncompletionSts</b>
     * </p>
     *
     * @return Pricing Incompletion Status (All Items)
     */
    @SerializedName( "OverallPricingIncompletionSts" )
    @JsonProperty( "OverallPricingIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OverallPricingIncompletionSts" )
    private String overallPricingIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OverallPricingIncompletionSts</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestField<String> OVERALL_PRICING_INCOMPLETION_STS =
        new BillingDocumentRequestField<String>("OverallPricingIncompletionSts");
    /**
     * Navigation property <b>to_Item</b> for <b>BillingDocumentRequest</b> to multiple
     * <b>BillingDocumentRequestItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentRequestItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>BillingDocumentRequest</b> to multiple <b>BillingDocReqPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocReqPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentRequest</b> to multiple
     * <b>BillingDocReqPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocReqPrcgElmnt> toPricingElement;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentRequestLink<BillingDocumentRequestItem> TO_ITEM =
        new BillingDocumentRequestLink<BillingDocumentRequestItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentRequestLink<BillingDocReqPartner> TO_PARTNER =
        new BillingDocumentRequestLink<BillingDocReqPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentRequestLink<BillingDocReqPrcgElmnt> TO_PRICING_ELEMENT =
        new BillingDocumentRequestLink<BillingDocReqPrcgElmnt>("to_PricingElement");

    @Nonnull
    @Override
    public Class<BillingDocumentRequest> getType()
    {
        return BillingDocumentRequest.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @param billingDocumentRequest
     *            Billing Document Request
     */
    public void setBillingDocumentRequest( @Nullable final String billingDocumentRequest )
    {
        rememberChangedField("BillingDocumentRequest", this.billingDocumentRequest);
        this.billingDocumentRequest = billingDocumentRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestType</b>
     * </p>
     *
     * @param billingDocumentRequestType
     *            Billing Document Request Type
     */
    public void setBillingDocumentRequestType( @Nullable final String billingDocumentRequestType )
    {
        rememberChangedField("BillingDocumentRequestType", this.billingDocumentRequestType);
        this.billingDocumentRequestType = billingDocumentRequestType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProposedBillingDocumentType</b>
     * </p>
     *
     * @param proposedBillingDocumentType
     *            Proposed Billing Document Type
     */
    public void setProposedBillingDocumentType( @Nullable final String proposedBillingDocumentType )
    {
        rememberChangedField("ProposedBillingDocumentType", this.proposedBillingDocumentType);
        this.proposedBillingDocumentType = proposedBillingDocumentType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @param billingDocumentDate
     *            Billing Date
     */
    public void setBillingDocumentDate( @Nullable final LocalDateTime billingDocumentDate )
    {
        rememberChangedField("BillingDocumentDate", this.billingDocumentDate);
        this.billingDocumentDate = billingDocumentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalTaxAmount</b>
     * </p>
     *
     * @param totalTaxAmount
     *            Tax Amount in Document Currency
     */
    public void setTotalTaxAmount( @Nullable final BigDecimal totalTaxAmount )
    {
        rememberChangedField("TotalTaxAmount", this.totalTaxAmount);
        this.totalTaxAmount = totalTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     *
     * @param totalGrossAmount
     *            The totalGrossAmount to set.
     */
    public void setTotalGrossAmount( @Nullable final BigDecimal totalGrossAmount )
    {
        rememberChangedField("TotalGrossAmount", this.totalGrossAmount);
        this.totalGrossAmount = totalGrossAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @param taxDepartureCountry
     *            Tax Departure Country/Region
     */
    public void setTaxDepartureCountry( @Nullable final String taxDepartureCountry )
    {
        rememberChangedField("TaxDepartureCountry", this.taxDepartureCountry);
        this.taxDepartureCountry = taxDepartureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Source document of data contained in billing doc. request
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @param referenceDocumentLogicalSystem
     *            Source system of the data contained in the billing doc. req.
     */
    public void setReferenceDocumentLogicalSystem( @Nullable final String referenceDocumentLogicalSystem )
    {
        rememberChangedField("ReferenceDocumentLogicalSystem", this.referenceDocumentLogicalSystem);
        this.referenceDocumentLogicalSystem = referenceDocumentLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocSDDocCategory</b>
     * </p>
     *
     * @param referenceDocSDDocCategory
     *            Source Document Category
     */
    public void setReferenceDocSDDocCategory( @Nullable final String referenceDocSDDocCategory )
    {
        rememberChangedField("ReferenceDocSDDocCategory", this.referenceDocSDDocCategory);
        this.referenceDocSDDocCategory = referenceDocSDDocCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocument</b>
     * </p>
     *
     * @param pricingDocument
     *            Number of the Document Condition
     */
    public void setPricingDocument( @Nullable final String pricingDocument )
    {
        rememberChangedField("PricingDocument", this.pricingDocument);
        this.pricingDocument = pricingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingIssueType</b>
     * </p>
     *
     * @param billingIssueType
     *            Billing Issue Type
     */
    public void setBillingIssueType( @Nullable final String billingIssueType )
    {
        rememberChangedField("BillingIssueType", this.billingIssueType);
        this.billingIssueType = billingIssueType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingDocReqStatus</b>
     * </p>
     *
     * @param overallBillingDocReqStatus
     *            Billing Document Request Status
     */
    public void setOverallBillingDocReqStatus( @Nullable final String overallBillingDocReqStatus )
    {
        rememberChangedField("OverallBillingDocReqStatus", this.overallBillingDocReqStatus);
        this.overallBillingDocReqStatus = overallBillingDocReqStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPricingIncompletionSts</b>
     * </p>
     *
     * @param overallPricingIncompletionSts
     *            Pricing Incompletion Status (All Items)
     */
    public void setOverallPricingIncompletionSts( @Nullable final String overallPricingIncompletionSts )
    {
        rememberChangedField("OverallPricingIncompletionSts", this.overallPricingIncompletionSts);
        this.overallPricingIncompletionSts = overallPricingIncompletionSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocumentRequest";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocumentRequest", getBillingDocumentRequest());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentRequest", getBillingDocumentRequest());
        values.put("BillingDocumentRequestType", getBillingDocumentRequestType());
        values.put("ProposedBillingDocumentType", getProposedBillingDocumentType());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("BillingDocumentDate", getBillingDocumentDate());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("TotalTaxAmount", getTotalTaxAmount());
        values.put("TotalGrossAmount", getTotalGrossAmount());
        values.put("TaxDepartureCountry", getTaxDepartureCountry());
        values.put("PayerParty", getPayerParty());
        values.put("ContractAccount", getContractAccount());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("CompanyCode", getCompanyCode());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentLogicalSystem", getReferenceDocumentLogicalSystem());
        values.put("ReferenceDocSDDocCategory", getReferenceDocSDDocCategory());
        values.put("SoldToParty", getSoldToParty());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("PricingDocument", getPricingDocument());
        values.put("BillingIssueType", getBillingIssueType());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("OverallBillingDocReqStatus", getOverallBillingDocReqStatus());
        values.put("OverallPricingIncompletionSts", getOverallPricingIncompletionSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentRequest") ) {
                final Object value = values.remove("BillingDocumentRequest");
                if( (value == null) || (!value.equals(getBillingDocumentRequest())) ) {
                    setBillingDocumentRequest(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentRequestType") ) {
                final Object value = values.remove("BillingDocumentRequestType");
                if( (value == null) || (!value.equals(getBillingDocumentRequestType())) ) {
                    setBillingDocumentRequestType(((String) value));
                }
            }
            if( values.containsKey("ProposedBillingDocumentType") ) {
                final Object value = values.remove("ProposedBillingDocumentType");
                if( (value == null) || (!value.equals(getProposedBillingDocumentType())) ) {
                    setProposedBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentDate") ) {
                final Object value = values.remove("BillingDocumentDate");
                if( (value == null) || (!value.equals(getBillingDocumentDate())) ) {
                    setBillingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("TotalTaxAmount") ) {
                final Object value = values.remove("TotalTaxAmount");
                if( (value == null) || (!value.equals(getTotalTaxAmount())) ) {
                    setTotalTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalGrossAmount") ) {
                final Object value = values.remove("TotalGrossAmount");
                if( (value == null) || (!value.equals(getTotalGrossAmount())) ) {
                    setTotalGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxDepartureCountry") ) {
                final Object value = values.remove("TaxDepartureCountry");
                if( (value == null) || (!value.equals(getTaxDepartureCountry())) ) {
                    setTaxDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentLogicalSystem") ) {
                final Object value = values.remove("ReferenceDocumentLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceDocumentLogicalSystem())) ) {
                    setReferenceDocumentLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocSDDocCategory") ) {
                final Object value = values.remove("ReferenceDocSDDocCategory");
                if( (value == null) || (!value.equals(getReferenceDocSDDocCategory())) ) {
                    setReferenceDocSDDocCategory(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("PricingDocument") ) {
                final Object value = values.remove("PricingDocument");
                if( (value == null) || (!value.equals(getPricingDocument())) ) {
                    setPricingDocument(((String) value));
                }
            }
            if( values.containsKey("BillingIssueType") ) {
                final Object value = values.remove("BillingIssueType");
                if( (value == null) || (!value.equals(getBillingIssueType())) ) {
                    setBillingIssueType(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("OverallBillingDocReqStatus") ) {
                final Object value = values.remove("OverallBillingDocReqStatus");
                if( (value == null) || (!value.equals(getOverallBillingDocReqStatus())) ) {
                    setOverallBillingDocReqStatus(((String) value));
                }
            }
            if( values.containsKey("OverallPricingIncompletionSts") ) {
                final Object value = values.remove("OverallPricingIncompletionSts");
                if( (value == null) || (!value.equals(getOverallPricingIncompletionSts())) ) {
                    setOverallPricingIncompletionSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentRequestItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new BillingDocumentRequestItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocReqPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new BillingDocReqPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocReqPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new BillingDocReqPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentRequestField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentRequestField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentRequestField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentRequestField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentRequestItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentRequestItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentRequestItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", BillingDocumentRequestItem.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequestItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentRequestItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentRequestItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequestItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequest</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>BillingDocumentRequestItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentRequestItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentRequestItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentRequestItem</b> entities.
     */
    public void setItem( @Nonnull final List<BillingDocumentRequestItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentRequestItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentRequestItem</b> entities.
     */
    public void addItem( BillingDocumentRequestItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocReqPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocReqPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", BillingDocReqPartner.class);
    }

    /**
     * Retrieval of associated <b>BillingDocReqPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocReqPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>BillingDocReqPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequest</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>BillingDocReqPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocReqPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>BillingDocReqPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocReqPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<BillingDocReqPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocReqPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocReqPartner</b> entities.
     */
    public void addPartner( BillingDocReqPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocReqPrcgElmnt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocReqPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", BillingDocReqPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>BillingDocReqPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequest</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocReqPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>BillingDocReqPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequest</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>BillingDocReqPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocReqPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>BillingDocReqPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequest</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocReqPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<BillingDocReqPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocReqPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequest</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocReqPrcgElmnt</b> entities.
     */
    public void addPricingElement( BillingDocReqPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentRequest instances.
     *
     */
    public final static class BillingDocumentRequestBuilder
    {

        private List<BillingDocumentRequestItem> toItem = Lists.newArrayList();
        private List<BillingDocReqPartner> toPartner = Lists.newArrayList();
        private List<BillingDocReqPrcgElmnt> toPricingElement = Lists.newArrayList();

        private BillingDocumentRequest.BillingDocumentRequestBuilder toItem(
            final List<BillingDocumentRequestItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>BillingDocumentRequest</b> to multiple
         * <b>BillingDocumentRequestItem</b>.
         *
         * @param value
         *            The BillingDocumentRequestItems to build this BillingDocumentRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequest.BillingDocumentRequestBuilder item( BillingDocumentRequestItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private BillingDocumentRequest.BillingDocumentRequestBuilder toPartner( final List<BillingDocReqPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>BillingDocumentRequest</b> to multiple
         * <b>BillingDocReqPartner</b>.
         *
         * @param value
         *            The BillingDocReqPartners to build this BillingDocumentRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequest.BillingDocumentRequestBuilder partner( BillingDocReqPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private BillingDocumentRequest.BillingDocumentRequestBuilder toPricingElement(
            final List<BillingDocReqPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentRequest</b> to multiple
         * <b>BillingDocReqPrcgElmnt</b>.
         *
         * @param value
         *            The BillingDocReqPrcgElmnts to build this BillingDocumentRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequest.BillingDocumentRequestBuilder pricingElement( BillingDocReqPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

    }

}
