/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest
 * BillingDocumentRequest} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class BillingDocumentRequestDeleteFluentHelper
    extends
    FluentHelperDelete<BillingDocumentRequestDeleteFluentHelper, BillingDocumentRequest>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest
     * BillingDocumentRequest} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final BillingDocumentRequest entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest
     * BillingDocumentRequest} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The BillingDocumentRequest to delete from the endpoint.
     */
    public BillingDocumentRequestDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final BillingDocumentRequest entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected BillingDocumentRequest getEntity()
    {
        return entity;
    }

}
