/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.field.BillingDocumentRequestItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocumentRequestItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocumentRequestItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable.BillingDocumentRequestItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Billing Document Request Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillingDocumentRequestItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentRequestItem extends VdmEntity<BillingDocumentRequestItem>
{

    /**
     * Selector for all available fields of BillingDocumentRequestItem.
     *
     */
    public final static BillingDocumentRequestItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @return Billing Document Request
     */
    @Key
    @SerializedName( "BillingDocumentRequest" )
    @JsonProperty( "BillingDocumentRequest" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequest" )
    private String billingDocumentRequest;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequest</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BILLING_DOCUMENT_REQUEST =
        new BillingDocumentRequestItemField<String>("BillingDocumentRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItem</b>
     * </p>
     *
     * @return Billing Document Request Item
     */
    @Key
    @SerializedName( "BillingDocumentRequestItem" )
    @JsonProperty( "BillingDocumentRequestItem" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequestItem" )
    private String billingDocumentRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequestItem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BILLING_DOCUMENT_REQUEST_ITEM =
        new BillingDocumentRequestItemField<String>("BillingDocumentRequestItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<LocalDateTime> CREATION_DATE =
        new BillingDocumentRequestItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<LocalTime> CREATION_TIME =
        new BillingDocumentRequestItemField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceLogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "ReferenceLogicalSystem" )
    @JsonProperty( "ReferenceLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceLogicalSystem" )
    private String referenceLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceLogicalSystem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> REFERENCE_LOGICAL_SYSTEM =
        new BillingDocumentRequestItemField<String>("ReferenceLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> DIVISION =
        new BillingDocumentRequestItemField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> MATERIAL =
        new BillingDocumentRequestItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @return Product Hierarchy
     */
    @SerializedName( "ProductHierarchyNode" )
    @JsonProperty( "ProductHierarchyNode" )
    @Nullable
    @ODataField( odataName = "ProductHierarchyNode" )
    private String productHierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchyNode</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> PRODUCT_HIERARCHY_NODE =
        new BillingDocumentRequestItemField<String>("ProductHierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> PLANT =
        new BillingDocumentRequestItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItemText</b>
     * </p>
     *
     * @return Text of Billing Document Request Item
     */
    @SerializedName( "BillingDocumentRequestItemText" )
    @JsonProperty( "BillingDocumentRequestItemText" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequestItemText" )
    private String billingDocumentRequestItemText;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentRequestItemText</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BILLING_DOCUMENT_REQUEST_ITEM_TEXT =
        new BillingDocumentRequestItemField<String>("BillingDocumentRequestItemText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new BillingDocumentRequestItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantity</b>
     * </p>
     *
     * @return Billing Quantity
     */
    @SerializedName( "BillingQuantity" )
    @JsonProperty( "BillingQuantity" )
    @Nullable
    @ODataField( odataName = "BillingQuantity" )
    private BigDecimal billingQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BillingQuantity</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<BigDecimal> BILLING_QUANTITY =
        new BillingDocumentRequestItemField<BigDecimal>("BillingQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityUnit</b>
     * </p>
     *
     * @return Billing Quantity Unit
     */
    @SerializedName( "BillingQuantityUnit" )
    @JsonProperty( "BillingQuantityUnit" )
    @Nullable
    @ODataField( odataName = "BillingQuantityUnit" )
    private String billingQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillingQuantityUnit</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BILLING_QUANTITY_UNIT =
        new BillingDocumentRequestItemField<String>("BillingQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of Billing item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<BigDecimal> NET_AMOUNT =
        new BillingDocumentRequestItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> TRANSACTION_CURRENCY =
        new BillingDocumentRequestItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmount</b>
     * </p>
     *
     * @return Gross Value of the Billing Item in Document Currency
     */
    @SerializedName( "GrossAmount" )
    @JsonProperty( "GrossAmount" )
    @Nullable
    @ODataField( odataName = "GrossAmount" )
    private BigDecimal grossAmount;
    /**
     * Use with available fluent helpers to apply the <b>GrossAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<BigDecimal> GROSS_AMOUNT =
        new BillingDocumentRequestItemField<BigDecimal>("GrossAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<LocalDateTime> PRICING_DATE =
        new BillingDocumentRequestItemField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltPriceDetnExchangeRate</b>
     * </p>
     *
     * @return Absolute exchange rate for price determination
     */
    @SerializedName( "AbsltPriceDetnExchangeRate" )
    @JsonProperty( "AbsltPriceDetnExchangeRate" )
    @Nullable
    @ODataField( odataName = "AbsltPriceDetnExchangeRate" )
    private BigDecimal absltPriceDetnExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AbsltPriceDetnExchangeRate</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<BigDecimal> ABSLT_PRICE_DETN_EXCHANGE_RATE =
        new BillingDocumentRequestItemField<BigDecimal>("AbsltPriceDetnExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchRateIsIndrctQtan</b>
     * </p>
     *
     * @return Pricing exchange rate quotation is indirect
     */
    @SerializedName( "PriceDetnExchRateIsIndrctQtan" )
    @JsonProperty( "PriceDetnExchRateIsIndrctQtan" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceDetnExchRateIsIndrctQtan" )
    private Boolean priceDetnExchRateIsIndrctQtan;
    /**
     * Use with available fluent helpers to apply the <b>PriceDetnExchRateIsIndrctQtan</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<Boolean> PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN =
        new BillingDocumentRequestItemField<Boolean>("PriceDetnExchRateIsIndrctQtan");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<BigDecimal> TAX_AMOUNT =
        new BillingDocumentRequestItemField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @return Departure Country/Region (from which the goods are sent)
     */
    @SerializedName( "DepartureCountry" )
    @JsonProperty( "DepartureCountry" )
    @Nullable
    @ODataField( odataName = "DepartureCountry" )
    private String departureCountry;
    /**
     * Use with available fluent helpers to apply the <b>DepartureCountry</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> DEPARTURE_COUNTRY =
        new BillingDocumentRequestItemField<String>("DepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> TAX_JURISDICTION =
        new BillingDocumentRequestItemField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification of Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new BillingDocumentRequestItemField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BUSINESS_AREA =
        new BillingDocumentRequestItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> PROFIT_CENTER =
        new BillingDocumentRequestItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> WBS_ELEMENT =
        new BillingDocumentRequestItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> CONTROLLING_AREA =
        new BillingDocumentRequestItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Deprecated: Profitability Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> PROFITABILITY_SEGMENT =
        new BillingDocumentRequestItemField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> ORDER_ID =
        new BillingDocumentRequestItemField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> COST_CENTER =
        new BillingDocumentRequestItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "MatlAccountAssignmentGroup" )
    @JsonProperty( "MatlAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "MatlAccountAssignmentGroup" )
    private String matlAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> MATL_ACCOUNT_ASSIGNMENT_GROUP =
        new BillingDocumentRequestItemField<String>("MatlAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Source document of data contained in billing doc. request
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> REFERENCE_DOCUMENT =
        new BillingDocumentRequestItemField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Source Document Item
     */
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> REFERENCE_DOCUMENT_ITEM =
        new BillingDocumentRequestItemField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> HIGHER_LEVEL_ITEM =
        new BillingDocumentRequestItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillgDocRequestItemInPartSgmt</b>
     * </p>
     *
     * @return Item Number in the Partner Segment
     */
    @SerializedName( "BillgDocRequestItemInPartSgmt" )
    @JsonProperty( "BillgDocRequestItemInPartSgmt" )
    @Nullable
    @ODataField( odataName = "BillgDocRequestItemInPartSgmt" )
    private String billgDocRequestItemInPartSgmt;
    /**
     * Use with available fluent helpers to apply the <b>BillgDocRequestItemInPartSgmt</b> field to query operations.
     *
     */
    public final static BillingDocumentRequestItemField<String> BILLG_DOC_REQUEST_ITEM_IN_PART_SGMT =
        new BillingDocumentRequestItemField<String>("BillgDocRequestItemInPartSgmt");
    /**
     * Navigation property <b>to_BillingDocumentRequest</b> for <b>BillingDocumentRequestItem</b> to single
     * <b>BillingDocumentRequest</b>.
     *
     */
    @SerializedName( "to_BillingDocumentRequest" )
    @JsonProperty( "to_BillingDocumentRequest" )
    @ODataField( odataName = "to_BillingDocumentRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocumentRequest toBillingDocumentRequest;
    /**
     * Navigation property <b>to_Partner</b> for <b>BillingDocumentRequestItem</b> to multiple
     * <b>BillingDocReqItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocReqItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentRequestItem</b> to multiple
     * <b>BillingDocReqItemPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocReqItemPrcgElmnt> toPricingElement;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingDocumentRequest</b> navigation property to query
     * operations.
     *
     */
    public final static BillingDocumentRequestItemOneToOneLink<BillingDocumentRequest> TO_BILLING_DOCUMENT_REQUEST =
        new BillingDocumentRequestItemOneToOneLink<BillingDocumentRequest>("to_BillingDocumentRequest");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentRequestItemLink<BillingDocReqItemPartner> TO_PARTNER =
        new BillingDocumentRequestItemLink<BillingDocReqItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static BillingDocumentRequestItemLink<BillingDocReqItemPrcgElmnt> TO_PRICING_ELEMENT =
        new BillingDocumentRequestItemLink<BillingDocReqItemPrcgElmnt>("to_PricingElement");

    @Nonnull
    @Override
    public Class<BillingDocumentRequestItem> getType()
    {
        return BillingDocumentRequestItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @param billingDocumentRequest
     *            Billing Document Request
     */
    public void setBillingDocumentRequest( @Nullable final String billingDocumentRequest )
    {
        rememberChangedField("BillingDocumentRequest", this.billingDocumentRequest);
        this.billingDocumentRequest = billingDocumentRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItem</b>
     * </p>
     *
     * @param billingDocumentRequestItem
     *            Billing Document Request Item
     */
    public void setBillingDocumentRequestItem( @Nullable final String billingDocumentRequestItem )
    {
        rememberChangedField("BillingDocumentRequestItem", this.billingDocumentRequestItem);
        this.billingDocumentRequestItem = billingDocumentRequestItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceLogicalSystem</b>
     * </p>
     *
     * @param referenceLogicalSystem
     *            Logical System
     */
    public void setReferenceLogicalSystem( @Nullable final String referenceLogicalSystem )
    {
        rememberChangedField("ReferenceLogicalSystem", this.referenceLogicalSystem);
        this.referenceLogicalSystem = referenceLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @param productHierarchyNode
     *            Product Hierarchy
     */
    public void setProductHierarchyNode( @Nullable final String productHierarchyNode )
    {
        rememberChangedField("ProductHierarchyNode", this.productHierarchyNode);
        this.productHierarchyNode = productHierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentRequestItemText</b>
     * </p>
     *
     * @param billingDocumentRequestItemText
     *            Text of Billing Document Request Item
     */
    public void setBillingDocumentRequestItemText( @Nullable final String billingDocumentRequestItemText )
    {
        rememberChangedField("BillingDocumentRequestItemText", this.billingDocumentRequestItemText);
        this.billingDocumentRequestItemText = billingDocumentRequestItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantity</b>
     * </p>
     *
     * @param billingQuantity
     *            Billing Quantity
     */
    public void setBillingQuantity( @Nullable final BigDecimal billingQuantity )
    {
        rememberChangedField("BillingQuantity", this.billingQuantity);
        this.billingQuantity = billingQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingQuantityUnit</b>
     * </p>
     *
     * @param billingQuantityUnit
     *            Billing Quantity Unit
     */
    public void setBillingQuantityUnit( @Nullable final String billingQuantityUnit )
    {
        rememberChangedField("BillingQuantityUnit", this.billingQuantityUnit);
        this.billingQuantityUnit = billingQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of Billing item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmount</b>
     * </p>
     *
     * @param grossAmount
     *            Gross Value of the Billing Item in Document Currency
     */
    public void setGrossAmount( @Nullable final BigDecimal grossAmount )
    {
        rememberChangedField("GrossAmount", this.grossAmount);
        this.grossAmount = grossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsltPriceDetnExchangeRate</b>
     * </p>
     *
     * @param absltPriceDetnExchangeRate
     *            Absolute exchange rate for price determination
     */
    public void setAbsltPriceDetnExchangeRate( @Nullable final BigDecimal absltPriceDetnExchangeRate )
    {
        rememberChangedField("AbsltPriceDetnExchangeRate", this.absltPriceDetnExchangeRate);
        this.absltPriceDetnExchangeRate = absltPriceDetnExchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchRateIsIndrctQtan</b>
     * </p>
     *
     * @param priceDetnExchRateIsIndrctQtan
     *            Pricing exchange rate quotation is indirect
     */
    public void setPriceDetnExchRateIsIndrctQtan( @Nullable final Boolean priceDetnExchRateIsIndrctQtan )
    {
        rememberChangedField("PriceDetnExchRateIsIndrctQtan", this.priceDetnExchRateIsIndrctQtan);
        this.priceDetnExchRateIsIndrctQtan = priceDetnExchRateIsIndrctQtan;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     */
    public void setDepartureCountry( @Nullable final String departureCountry )
    {
        rememberChangedField("DepartureCountry", this.departureCountry);
        this.departureCountry = departureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification of Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Deprecated: Profitability Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @param matlAccountAssignmentGroup
     *            Account Assignment Group for Material
     */
    public void setMatlAccountAssignmentGroup( @Nullable final String matlAccountAssignmentGroup )
    {
        rememberChangedField("MatlAccountAssignmentGroup", this.matlAccountAssignmentGroup);
        this.matlAccountAssignmentGroup = matlAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Source document of data contained in billing doc. request
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Source Document Item
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillgDocRequestItemInPartSgmt</b>
     * </p>
     *
     * @param billgDocRequestItemInPartSgmt
     *            Item Number in the Partner Segment
     */
    public void setBillgDocRequestItemInPartSgmt( @Nullable final String billgDocRequestItemInPartSgmt )
    {
        rememberChangedField("BillgDocRequestItemInPartSgmt", this.billgDocRequestItemInPartSgmt);
        this.billgDocRequestItemInPartSgmt = billgDocRequestItemInPartSgmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillingDocumentRequestItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocumentRequest", getBillingDocumentRequest());
        result.put("BillingDocumentRequestItem", getBillingDocumentRequestItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentRequest", getBillingDocumentRequest());
        values.put("BillingDocumentRequestItem", getBillingDocumentRequestItem());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("ReferenceLogicalSystem", getReferenceLogicalSystem());
        values.put("Division", getDivision());
        values.put("Material", getMaterial());
        values.put("ProductHierarchyNode", getProductHierarchyNode());
        values.put("Plant", getPlant());
        values.put("BillingDocumentRequestItemText", getBillingDocumentRequestItemText());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        values.put("BillingQuantity", getBillingQuantity());
        values.put("BillingQuantityUnit", getBillingQuantityUnit());
        values.put("NetAmount", getNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("GrossAmount", getGrossAmount());
        values.put("PricingDate", getPricingDate());
        values.put("AbsltPriceDetnExchangeRate", getAbsltPriceDetnExchangeRate());
        values.put("PriceDetnExchRateIsIndrctQtan", getPriceDetnExchRateIsIndrctQtan());
        values.put("TaxAmount", getTaxAmount());
        values.put("DepartureCountry", getDepartureCountry());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("WBSElement", getWBSElement());
        values.put("ControllingArea", getControllingArea());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("OrderID", getOrderID());
        values.put("CostCenter", getCostCenter());
        values.put("MatlAccountAssignmentGroup", getMatlAccountAssignmentGroup());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("BillgDocRequestItemInPartSgmt", getBillgDocRequestItemInPartSgmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentRequest") ) {
                final Object value = values.remove("BillingDocumentRequest");
                if( (value == null) || (!value.equals(getBillingDocumentRequest())) ) {
                    setBillingDocumentRequest(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentRequestItem") ) {
                final Object value = values.remove("BillingDocumentRequestItem");
                if( (value == null) || (!value.equals(getBillingDocumentRequestItem())) ) {
                    setBillingDocumentRequestItem(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ReferenceLogicalSystem") ) {
                final Object value = values.remove("ReferenceLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceLogicalSystem())) ) {
                    setReferenceLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ProductHierarchyNode") ) {
                final Object value = values.remove("ProductHierarchyNode");
                if( (value == null) || (!value.equals(getProductHierarchyNode())) ) {
                    setProductHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentRequestItemText") ) {
                final Object value = values.remove("BillingDocumentRequestItemText");
                if( (value == null) || (!value.equals(getBillingDocumentRequestItemText())) ) {
                    setBillingDocumentRequestItemText(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingQuantity") ) {
                final Object value = values.remove("BillingQuantity");
                if( (value == null) || (!value.equals(getBillingQuantity())) ) {
                    setBillingQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingQuantityUnit") ) {
                final Object value = values.remove("BillingQuantityUnit");
                if( (value == null) || (!value.equals(getBillingQuantityUnit())) ) {
                    setBillingQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("GrossAmount") ) {
                final Object value = values.remove("GrossAmount");
                if( (value == null) || (!value.equals(getGrossAmount())) ) {
                    setGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AbsltPriceDetnExchangeRate") ) {
                final Object value = values.remove("AbsltPriceDetnExchangeRate");
                if( (value == null) || (!value.equals(getAbsltPriceDetnExchangeRate())) ) {
                    setAbsltPriceDetnExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("PriceDetnExchRateIsIndrctQtan") ) {
                final Object value = values.remove("PriceDetnExchRateIsIndrctQtan");
                if( (value == null) || (!value.equals(getPriceDetnExchRateIsIndrctQtan())) ) {
                    setPriceDetnExchRateIsIndrctQtan(((Boolean) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DepartureCountry") ) {
                final Object value = values.remove("DepartureCountry");
                if( (value == null) || (!value.equals(getDepartureCountry())) ) {
                    setDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("MatlAccountAssignmentGroup") ) {
                final Object value = values.remove("MatlAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getMatlAccountAssignmentGroup())) ) {
                    setMatlAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("BillgDocRequestItemInPartSgmt") ) {
                final Object value = values.remove("BillgDocRequestItemInPartSgmt");
                if( (value == null) || (!value.equals(getBillgDocRequestItemInPartSgmt())) ) {
                    setBillgDocRequestItemInPartSgmt(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingDocumentRequest") ) {
                final Object value = (values).remove("to_BillingDocumentRequest");
                if( value instanceof Map ) {
                    if( toBillingDocumentRequest == null ) {
                        toBillingDocumentRequest = new BillingDocumentRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocumentRequest.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocReqItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new BillingDocReqItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocReqItemPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new BillingDocReqItemPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BillingDocumentRequestItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentRequestItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentRequestItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentRequestItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingDocumentRequest != null ) {
            (values).put("to_BillingDocumentRequest", toBillingDocumentRequest);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentRequest</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocumentRequest</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequest fetchBillingDocumentRequest()
    {
        return fetchFieldAsSingle("to_BillingDocumentRequest", BillingDocumentRequest.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * If the navigation property <b>to_BillingDocumentRequest</b> of a queried <b>BillingDocumentRequestItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentRequest getBillingDocumentRequestOrFetch()
    {
        if( toBillingDocumentRequest == null ) {
            toBillingDocumentRequest = fetchBillingDocumentRequest();
        }
        return toBillingDocumentRequest;
    }

    /**
     * Retrieval of associated <b>BillingDocumentRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingDocumentRequest</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequestItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingDocumentRequest</b> is already loaded, the result
     *         will contain the <b>BillingDocumentRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocumentRequest> getBillingDocumentRequestIfPresent()
    {
        return Option.of(toBillingDocumentRequest);
    }

    /**
     * Overwrites the associated <b>BillingDocumentRequest</b> entity for the loaded navigation property
     * <b>to_BillingDocumentRequest</b>.
     *
     * @param value
     *            New <b>BillingDocumentRequest</b> entity.
     */
    public void setBillingDocumentRequest( final BillingDocumentRequest value )
    {
        toBillingDocumentRequest = value;
    }

    /**
     * Fetches the <b>BillingDocReqItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocReqItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", BillingDocReqItemPartner.class);
    }

    /**
     * Retrieval of associated <b>BillingDocReqItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocReqItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>BillingDocReqItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequestItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>BillingDocReqItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocReqItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>BillingDocReqItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocReqItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<BillingDocReqItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocReqItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>BillingDocumentRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocReqItemPartner</b> entities.
     */
    public void addPartner( BillingDocReqItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillingDocReqItemPrcgElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocReqItemPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqItemPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", BillingDocReqItemPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>BillingDocReqItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocReqItemPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocReqItemPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>BillingDocReqItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentRequestItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>BillingDocReqItemPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocReqItemPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>BillingDocReqItemPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocReqItemPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<BillingDocReqItemPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocReqItemPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>BillingDocumentRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocReqItemPrcgElmnt</b> entities.
     */
    public void addPricingElement( BillingDocReqItemPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentRequestItem instances.
     *
     */
    public final static class BillingDocumentRequestItemBuilder
    {

        private BillingDocumentRequest toBillingDocumentRequest;
        private String billingDocumentRequest = null;
        private List<BillingDocReqItemPartner> toPartner = Lists.newArrayList();
        private List<BillingDocReqItemPrcgElmnt> toPricingElement = Lists.newArrayList();

        private BillingDocumentRequestItem.BillingDocumentRequestItemBuilder toBillingDocumentRequest(
            final BillingDocumentRequest value )
        {
            toBillingDocumentRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingDocumentRequest</b> for <b>BillingDocumentRequestItem</b> to single
         * <b>BillingDocumentRequest</b>.
         *
         * @param value
         *            The BillingDocumentRequest to build this BillingDocumentRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequestItem.BillingDocumentRequestItemBuilder billingDocumentRequest(
            final BillingDocumentRequest value )
        {
            return toBillingDocumentRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingDocumentRequest</b>
         * </p>
         *
         * @param value
         *            The billingDocumentRequest to build this BillingDocumentRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequestItem.BillingDocumentRequestItemBuilder billingDocumentRequest( final String value )
        {
            billingDocumentRequest = value;
            return this;
        }

        private BillingDocumentRequestItem.BillingDocumentRequestItemBuilder toPartner(
            final List<BillingDocReqItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>BillingDocumentRequestItem</b> to multiple
         * <b>BillingDocReqItemPartner</b>.
         *
         * @param value
         *            The BillingDocReqItemPartners to build this BillingDocumentRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequestItem.BillingDocumentRequestItemBuilder partner( BillingDocReqItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private BillingDocumentRequestItem.BillingDocumentRequestItemBuilder toPricingElement(
            final List<BillingDocReqItemPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>BillingDocumentRequestItem</b> to multiple
         * <b>BillingDocReqItemPrcgElmnt</b>.
         *
         * @param value
         *            The BillingDocReqItemPrcgElmnts to build this BillingDocumentRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentRequestItem.BillingDocumentRequestItemBuilder pricingElement(
            BillingDocReqItemPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

    }

}
